/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class LineIterator
implements Iterator<String>,
Closeable {
    private final @UnknownKeyFor @NonNull @Initialized BufferedReader bufferedReader;
    private @Nullable @UnknownKeyFor @Initialized String cachedLine;
    private @UnknownKeyFor @NonNull @Initialized boolean finished = false;

    public LineIterator(@UnknownKeyFor @NonNull @Initialized Reader reader) throws @UnknownKeyFor @NonNull @Initialized IllegalArgumentException {
        if (reader == null) {
            throw new IllegalArgumentException("Reader must not be null");
        }
        this.bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    @Override
    @EnsuresNonNullIf(expression={"cachedLine"}, result=true)
    public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
        if (this.cachedLine != null) {
            return true;
        }
        if (this.finished) {
            return false;
        }
        try {
            String line;
            do {
                if ((line = this.bufferedReader.readLine()) != null) continue;
                this.finished = true;
                return false;
            } while (!this.isValidLine(line));
            this.cachedLine = line;
            return true;
        }
        catch (IOException ioe) {
            try {
                this.close();
            }
            catch (IOException e) {
                ioe.addSuppressed(e);
            }
            throw new IllegalStateException(ioe);
        }
    }

    protected @UnknownKeyFor @NonNull @Initialized boolean isValidLine(@UnknownKeyFor @NonNull @Initialized String line) {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String next() {
        return this.nextLine();
    }

    public @UnknownKeyFor @NonNull @Initialized String nextLine() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more lines");
        }
        String currentLine = this.cachedLine;
        this.cachedLine = null;
        return currentLine;
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.finished = true;
        this.cachedLine = null;
        if (this.bufferedReader != null) {
            this.bufferedReader.close();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove unsupported on LineIterator");
    }

    @Deprecated
    public static void closeQuietly(@Nullable @UnknownKeyFor @Initialized LineIterator iterator) {
        try {
            if (iterator != null) {
                iterator.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

