/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class AgeFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -2132740084016138541L;
    private final @UnknownKeyFor @NonNull @Initialized long cutoff;
    private final @UnknownKeyFor @NonNull @Initialized boolean acceptOlder;

    public AgeFileFilter(@UnknownKeyFor @NonNull @Initialized long cutoff) {
        this(cutoff, true);
    }

    public AgeFileFilter(@UnknownKeyFor @NonNull @Initialized long cutoff, @UnknownKeyFor @NonNull @Initialized boolean acceptOlder) {
        this.acceptOlder = acceptOlder;
        this.cutoff = cutoff;
    }

    public AgeFileFilter(@UnknownKeyFor @NonNull @Initialized Date cutoffDate) {
        this(cutoffDate, true);
    }

    public AgeFileFilter(@UnknownKeyFor @NonNull @Initialized Date cutoffDate, @UnknownKeyFor @NonNull @Initialized boolean acceptOlder) {
        this(cutoffDate.getTime(), acceptOlder);
    }

    public AgeFileFilter(@UnknownKeyFor @NonNull @Initialized File cutoffReference) {
        this(cutoffReference, true);
    }

    public AgeFileFilter(@UnknownKeyFor @NonNull @Initialized File cutoffReference, @UnknownKeyFor @NonNull @Initialized boolean acceptOlder) {
        this(cutoffReference.lastModified(), acceptOlder);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean accept(@UnknownKeyFor @NonNull @Initialized File file) {
        boolean newer = FileUtils.isFileNewer(file, this.cutoff);
        return this.acceptOlder ? !newer : newer;
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        String condition = this.acceptOlder ? "<=" : ">";
        return super.toString() + "(" + condition + this.cutoff + ")";
    }
}

