/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.client.GameKeys;
import com.endertech.minecraft.forge.data.TagHelper;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.IWind;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="forgeendertech", value={Dist.CLIENT})
public class DevInfo {
    static final GameTime UPDATE_INTERVAL = GameTime.quaterSecond();
    static final GameTime EXCEPTION_PRINT_INTERVAL = GameTime.seconds(10);
    protected static float rayTraceDistance = 10.0f;
    protected static boolean showInventoryTooltip = false;
    protected static boolean renderGameOverlay = false;
    protected static boolean hotKeyWasDown = false;
    private static HitResult rayTraceResult = null;

    @SubscribeEvent
    public static void onKeyPressed(InputEvent.KeyInputEvent event) {
        if (ForgeEndertech.isDebugMode() && Minecraft.m_91087_().f_91073_ != null) {
            int hotKey = 281;
            if (GameKeys.isDown(281)) {
                if (!hotKeyWasDown && GameKeys.isShiftDown()) {
                    showInventoryTooltip = !showInventoryTooltip;
                    renderGameOverlay = !renderGameOverlay;
                }
                hotKeyWasDown = true;
            } else {
                hotKeyWasDown = false;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onInventoryTooltip(ItemTooltipEvent event) {
        if (!showInventoryTooltip) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (!stack.m_41619_()) {
            List lines = event.getToolTip();
            DevInfo.addItemInfo(stack, lines);
        }
    }

    @SubscribeEvent
    public static void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        block11: {
            if (!renderGameOverlay) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            Options gs = GameKeys.getGameSettings();
            if (mc.f_91080_ == null && event.getType().equals((Object)RenderGameOverlayEvent.ElementType.ALL)) {
                try {
                    boolean shouldRecalcTraceResult;
                    ArrayList<Component> lines = new ArrayList<Component>();
                    DevInfo.addWorldInfo(mc.f_91073_, lines);
                    lines.add((Component)new TextComponent(""));
                    boolean bl = shouldRecalcTraceResult = rayTraceResult == null || UPDATE_INTERVAL.pastIn((Level)mc.f_91073_);
                    if (shouldRecalcTraceResult) {
                        rayTraceResult = gs.f_92091_.m_90857_() ? mc.f_91077_ : (HitResult)ForgeEntity.rayTraceBlockBeingLookedAt((Entity)mc.f_91074_, ClipContext.Block.VISUAL, ClipContext.Fluid.ANY, event.getPartialTicks(), rayTraceDistance).orElse(null);
                    }
                    if (rayTraceResult != null) {
                        switch (rayTraceResult.m_6662_()) {
                            case BLOCK: {
                                if (!(rayTraceResult instanceof BlockHitResult)) break;
                                DevInfo.addBlockInfo(mc.f_91073_, ((BlockHitResult)rayTraceResult).m_82425_(), lines);
                                break;
                            }
                            case ENTITY: {
                                if (!(rayTraceResult instanceof EntityHitResult)) break;
                                DevInfo.addEntityInfo(((EntityHitResult)rayTraceResult).m_82443_(), lines);
                                break;
                            }
                        }
                    }
                    PoseStack matrix = event.getMatrixStack();
                    matrix.m_85836_();
                    int color = -2130706433;
                    int x = 2;
                    int y = 2;
                    int step = 10;
                    for (Component line : lines) {
                        mc.f_91062_.m_92883_(matrix, line.getString(), (float)x, (float)y, color);
                        y += step;
                    }
                    matrix.m_85849_();
                }
                catch (Exception e) {
                    if (!EXCEPTION_PRINT_INTERVAL.pastIn((Level)mc.f_91073_)) break block11;
                    e.printStackTrace();
                }
            }
        }
    }

    protected static void addCaptionLine(List<Component> lines, String caption) {
        lines.add((Component)new TextComponent("==" + caption + "=="));
    }

    protected static void addInfoLine(List<Component> lines, String caption, Object value) {
        lines.add((Component)DevInfo.underlined(caption + ": ").m_130946_(String.valueOf(value)));
    }

    protected static void addWorldInfo(ClientLevel world, List<Component> lines) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        BlockPos pos = player.m_142538_();
        BiomeId biome = BiomeId.from((LevelAccessor)world, pos);
        GameWorld.WorldData data = GameWorld.getData((LevelAccessor)world);
        IWind wind = GameWorld.getWindAt((Level)world, pos);
        DevInfo.addCaptionLine(lines, "World Info");
        DevInfo.addInfoLine(lines, "Biome", biome.toString());
        DevInfo.addInfoLine(lines, "Wind", Float.valueOf(wind.getStrengthIn(player.m_6350_())));
        DevInfo.addInfoLine(lines, "isRaining", world.m_46471_());
        DevInfo.addInfoLine(lines, "Level", "rain = " + world.f_46438_ + ", thunder = " + world.f_46440_);
        DevInfo.addInfoLine(lines, "SmokeParticles", data.smokeParticlesCount);
        DevInfo.addInfoLine(lines, "GameTime", world.m_46467_());
    }

    protected static void addBlockInfo(ClientLevel world, BlockPos pos, List<Component> lines) {
        BlockState state = world.m_8055_(pos);
        UnitId id = UnitId.from(state);
        DevInfo.addCaptionLine(lines, "Block Info");
        lines.add((Component)DevInfo.formatedId(id));
        DevInfo.addInfoLine(lines, "State", state);
        if (rayTraceResult instanceof BlockHitResult) {
            Direction face;
            boolean solid = state.m_60783_((BlockGetter)world, pos, face = ((BlockHitResult)rayTraceResult).m_82434_());
            DevInfo.addInfoLine(lines, "Side", face + " (" + (solid ? "solid" : "not solid") + ")");
        }
        DevInfo.addInfoLine(lines, "Sky", "canSeeSky=" + ForgeBlock.isUnderOpenSky((Level)world, pos) + " isUnderRain=" + ForgeBlock.isUnderRain((Level)world, pos));
        DevInfo.addInfoLine(lines, "BlockPos", Args.join(Args.get("x", pos.m_123341_()), Args.get("y", pos.m_123342_()), Args.get("z", pos.m_123343_())));
        DevInfo.addInfoLine(lines, "Shape", state.m_60808_((BlockGetter)world, pos));
        DevInfo.addInfoLine(lines, "CollisionShape", state.m_60812_((BlockGetter)world, pos));
        DevInfo.addInfoLine(lines, "TileEntity", world.m_7702_(pos));
        BlockEntity tile = world.m_7702_(pos);
        if (tile != null) {
            DevInfo.addCompoundInfo(tile.save(new CompoundTag()), lines, IEmitter.COMMON_ACTIVE_TAG_NAME);
        }
    }

    static void addEntityInfo(Entity entity, List<Component> lines) {
        DevInfo.addCaptionLine(lines, "Entity Info");
        DevInfo.addInfoLine(lines, "id", ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)entity.m_6095_()));
        DevInfo.addInfoLine(lines, "name", entity.m_7755_());
        DevInfo.addInfoLine(lines, "isUnderRain", ForgeEntity.isUnderRain(entity));
        DevInfo.addCompoundInfo(entity.m_20240_(new CompoundTag()), lines, IEmitter.COMMON_ACTIVE_TAG_NAME);
    }

    protected static void addItemInfo(ItemStack stack, List<Component> lines) {
        Item item = stack.m_41720_();
        UnitId unitId = UnitId.from(item);
        DevInfo.addInfoLine(lines, "Durability", stack.m_41776_());
        lines.add((Component)DevInfo.formatedId(unitId));
        DevInfo.addInfoLine(lines, "BurnTime", Optional.of(ForgeHooks.getBurnTime((ItemStack)stack, null)).map(ticks -> ticks + " (carbon:" + (double)ticks.intValue() / 1600.0 + ")").orElse("unknown"));
        DevInfo.addInfoLine(lines, "Category", Optional.ofNullable(item.m_41471_()).map(group -> group.m_40783_()).orElse("none"));
        if (item instanceof BucketItem) {
            DevInfo.addInfoLine(lines, "FluidTags", ((BucketItem)item).getFluid().getTags());
        }
        DevInfo.addCompoundInfo(stack.m_41783_(), lines, name -> true);
    }

    protected static void addCompoundInfo(CompoundTag compound, List<Component> lines, Predicate<String> name) {
        if (compound != null) {
            lines.add((Component)DevInfo.underlined("NBT: "));
            for (String key : compound.m_128431_()) {
                TagHelper.Types type = TagHelper.getType(compound, key);
                if (!name.test(key) || !type.isOrdinal() && type != TagHelper.Types.STRING) continue;
                String line = type + " " + key;
                line = line + " = " + compound.m_128423_(key);
                lines.add((Component)new TextComponent(line).m_130940_(ChatFormatting.RESET));
            }
        } else {
            lines.add((Component)new TextComponent("no NBT"));
        }
    }

    protected static MutableComponent underlined(String string) {
        return new TextComponent(string).m_130940_(ChatFormatting.UNDERLINE);
    }

    protected static ChatFormatting reset() {
        return ChatFormatting.RESET;
    }

    protected static MutableComponent formatedId(UnitId id) {
        return DevInfo.underlined("ID: ").m_130946_(id.toString());
    }
}

