/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.common.KeyValuePair;
import com.endertech.minecraft.forge.blocks.BlockStatesSet;
import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.RelatedUnit;
import java.util.Collections;
import java.util.Set;
import net.minecraft.world.level.block.state.BlockState;

public class ForgeEmitter
extends RelatedUnit
implements IEmitter {
    protected Set<BlockState> relatedBlocks = Collections.emptySet();
    private final String activeTag;
    private final KeyValuePair identityTag;
    private final String[] relatedBlocksArray;
    private final IEmitter.Type type;

    public ForgeEmitter(UnitConfig config, Properties<?> props) {
        super(config, props.id);
        String category = this.getClassCategory();
        this.activeTag = UnitConfig.getStr(config, category, "activeTag", props.activeTag, "Defines the name of the NBT tag that stores info about tile entity active state.\nEmitter is considered active if the return value is greater than 0 or true.\nSet to an empty string if you don't need this function.");
        this.identityTag = UnitConfig.getKeyValuePair(config, category, "identityTag", props.identityTag, "This parameter is required only for those blocks that use NBT tags to fully identify themselves.\nThe format is <tagKey>=<value>\nIf the value is a string, it must be enclosed in double quotes. Example: id=\"ic2:generator\"\nLeave this blank if you don't need it.");
        this.type = IEmitter.Type.getFrom(config, category, props.type, "Defines the type of this emitter.\nValid types (case insensitive):\n  BLOCK - a simple Block without a Tile Entity that will be updated each time it receives a random tick.\n  TILE - a Block with a Tile Entity that will be updated onces per second.\n  ENTITY - a mobile Entity that will be updated onces per second.\n  FUEL - a Tile Entity with a HARDCODED hook that will be updated each time it consumes fuel.");
        this.relatedBlocksArray = UnitConfig.getStrArray(config, category, "relatedBlocks", props.relatedBlocks, "Defines a list of blocks which should be considered as part of this multiblock.");
        this.saveConfig();
    }

    @Override
    public String getActiveTag() {
        return this.activeTag;
    }

    @Override
    public KeyValuePair getIdentityTag() {
        return this.identityTag;
    }

    @Override
    public IEmitter.Type getType() {
        return this.type;
    }

    @Override
    public Set<BlockState> getRelatedBlocks() {
        return this.relatedBlocks;
    }

    @Override
    public void onPostInit() {
        this.relatedBlocks = BlockStatesSet.parseFrom(this.relatedBlocksArray);
    }

    @Deprecated
    public boolean isEntity() {
        return this.getType().isEntity();
    }

    public static class Properties<T extends Properties<T>>
    extends RelatedUnit.Properties<T> {
        public IEmitter.Type type = IEmitter.Type.BLOCK;
        public String activeTag = "";
        public String fuelTag = "";
        public KeyValuePair identityTag = KeyValuePair.EMPTY;
        public String[] relatedBlocks = new String[0];

        @Deprecated
        protected Properties(Class<T> selfClazz) {
            super(selfClazz);
        }

        protected Properties(Class<T> selfClazz, IEmitter.Type type) {
            super(selfClazz);
            this.type = type;
        }

        public static Properties<?> with(IEmitter.Type type) {
            return new Properties<Properties>(Properties.class, type);
        }

        public T type(IEmitter.Type type) {
            this.type = type;
            return (T)((Properties)this.self);
        }

        public T activeTag(String activeTag) {
            this.activeTag = activeTag;
            return (T)((Properties)this.self);
        }

        public T stateActive() {
            return (T)((Properties)this.metadata("[active=true]"));
        }

        public T stateLit() {
            return (T)((Properties)this.metadata("[lit=true]"));
        }

        public T activeStateHardcoded() {
            return this.activeTag("#hardcoded");
        }

        public T identityTag(KeyValuePair identityTag) {
            this.identityTag = identityTag;
            return (T)((Properties)this.self);
        }

        public T fuelTag(String fuelTag) {
            this.fuelTag = fuelTag;
            return (T)((Properties)this.self);
        }

        public T relatedBlocks(String ... relatedBlocks) {
            this.relatedBlocks = relatedBlocks;
            return (T)((Properties)this.self);
        }
    }
}

