/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui;

import com.ldtteam.blockui.MatrixUtils;
import com.ldtteam.blockui.views.BOWindow;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.BitStorage;
import net.minecraft.util.SimpleBitStorage;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;

public class BOScreen
extends Screen {
    protected double renderScale = 1.0;
    protected double mcScale = 1.0;
    protected BOWindow window;
    protected double x = 0.0;
    protected double y = 0.0;
    public static boolean isMouseLeftDown = false;
    protected boolean isOpen = false;
    private static final BitStorage ACCEPTED_KEY_PRESSED_MAP = new SimpleBitStorage(1, 349);

    public BOScreen(BOWindow w) {
        super((Component)new TextComponent("Blockout GUI"));
        this.window = w;
    }

    public void m_6305_(PoseStack ms, int mx, int my, float f) {
        if (this.f_96541_ == null || !this.isOpen) {
            return;
        }
        double fbWidth = this.f_96541_.m_91268_().m_85441_();
        double fbHeight = this.f_96541_.m_91268_().m_85442_();
        double guiWidth = Math.max(fbWidth, 320.0);
        double guiHeight = Math.max(fbHeight, 240.0);
        float renderZlevel = MatrixUtils.getLastMatrixTranslateZ(ms);
        float oldZ = this.f_96541_.m_91291_().f_115093_;
        this.f_96541_.m_91291_().f_115093_ = renderZlevel;
        boolean oldFilteringValue = ForgeRenderTypes.enableTextTextureLinearFiltering;
        ForgeRenderTypes.enableTextTextureLinearFiltering = false;
        this.mcScale = this.f_96541_.m_91268_().m_85449_();
        this.renderScale = this.window.getRenderType().calcRenderScale(this.f_96541_.m_91268_(), this.window);
        if (this.window.hasLightbox()) {
            this.f_96543_ = (int)fbWidth;
            this.f_96544_ = (int)fbHeight;
            super.m_7333_(ms);
        }
        this.f_96543_ = this.window.getWidth();
        this.f_96544_ = this.window.getHeight();
        this.x = Math.floor((guiWidth - (double)this.f_96543_ * this.renderScale) / 2.0);
        this.y = Math.floor((guiHeight - (double)this.f_96544_ * this.renderScale) / 2.0);
        PoseStack shaderPs = RenderSystem.m_157191_();
        Matrix4f oldProjection = RenderSystem.m_157192_();
        RenderSystem.m_157425_((Matrix4f)Matrix4f.m_162203_((float)0.0f, (float)((float)fbWidth), (float)0.0f, (float)((float)fbHeight), (float)-10000.0f, (float)50000.0f));
        shaderPs.m_85836_();
        shaderPs.m_166856_();
        PoseStack newMs = new PoseStack();
        newMs.m_85837_(this.x, this.y, (double)renderZlevel);
        newMs.m_85841_((float)this.renderScale, (float)this.renderScale, 1.0f);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69482_();
        RenderSystem.m_69461_();
        RenderSystem.m_69453_();
        try {
            this.window.draw(newMs, this.calcRelativeX(mx), this.calcRelativeY(my));
            this.window.drawLast(newMs, this.calcRelativeX(mx), this.calcRelativeY(my));
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"Rendering BO screen");
            CrashReportCategory category = crashReport.m_127514_("BO screen rendering details");
            category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
            category.m_128165_("Scaling mode (window render type)", () -> this.window.getRenderType().name());
            category.m_128165_("Vanilla gui scale", () -> Double.toString(this.mcScale));
            category.m_128165_("BO gui scale", () -> Double.toString(this.renderScale));
            throw new ReportedException(crashReport);
        }
        finally {
            shaderPs.m_85849_();
            RenderSystem.m_157425_((Matrix4f)oldProjection);
            RenderSystem.m_157182_();
            this.f_96541_.m_91291_().f_115093_ = oldZ;
            ForgeRenderTypes.enableTextTextureLinearFiltering = oldFilteringValue;
        }
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        if (key >= 0 && key <= 348) {
            try {
                return ACCEPTED_KEY_PRESSED_MAP.m_13514_(key) == 0 || this.window.onKeyTyped('\u0000', key);
            }
            catch (Exception e) {
                CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"KeyPressed event for BO screen");
                CrashReportCategory category = crashReport.m_127514_("BO screen key event details");
                category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
                category.m_128165_("GLFW key value", () -> Integer.toString(key));
                throw new ReportedException(crashReport);
            }
        }
        return false;
    }

    public boolean m_5534_(char ch, int key) {
        try {
            return this.window.onKeyTyped(ch, key);
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"CharTyped event for BO screen");
            CrashReportCategory category = crashReport.m_127514_("BO screen char event details");
            category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
            category.m_128165_("Char value", () -> Character.toString(ch));
            throw new ReportedException(crashReport);
        }
    }

    public boolean m_6375_(double mxIn, double myIn, int keyCode) {
        double mx = this.calcRelativeX(mxIn);
        double my = this.calcRelativeY(myIn);
        try {
            if (keyCode == 0) {
                isMouseLeftDown = true;
                return this.window.click(mx, my);
            }
            if (keyCode == 1) {
                return this.window.rightClick(mx, my);
            }
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"MousePressed event for BO screen");
            CrashReportCategory category = crashReport.m_127514_("BO screen mouse event details");
            category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
            category.m_128165_("GLFW mouse key value", () -> Integer.toString(keyCode));
            throw new ReportedException(crashReport);
        }
        return false;
    }

    public boolean m_6050_(double mx, double my, double scrollDiff) {
        if (scrollDiff != 0.0) {
            try {
                return this.window.scrollInput(scrollDiff * 10.0, this.calcRelativeX(mx), this.calcRelativeY(my));
            }
            catch (Exception e) {
                CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"MouseScroll event for BO screen");
                CrashReportCategory category = crashReport.m_127514_("BO screen scroll event details");
                category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
                category.m_128165_("Scroll value", () -> Double.toString(scrollDiff));
                throw new ReportedException(crashReport);
            }
        }
        return false;
    }

    public boolean m_7979_(double xIn, double yIn, int speed, double deltaX, double deltaY) {
        try {
            return this.window.onMouseDrag(this.calcRelativeX(xIn), this.calcRelativeY(yIn), speed, deltaX, deltaY);
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"MouseDragged event for BO screen");
            CrashReportCategory category = crashReport.m_127514_("BO screen mouse event details");
            category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
            throw new ReportedException(crashReport);
        }
    }

    public boolean m_6348_(double mxIn, double myIn, int keyCode) {
        if (keyCode == 0) {
            isMouseLeftDown = false;
            try {
                return this.window.onMouseReleased(this.calcRelativeX(mxIn), this.calcRelativeY(myIn));
            }
            catch (Exception e) {
                CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"MouseReleased event for BO screen");
                CrashReportCategory category = crashReport.m_127514_("BO screen mouse event details");
                category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
                category.m_128165_("GLFW mouse key value", () -> Integer.toString(keyCode));
                throw new ReportedException(crashReport);
            }
        }
        return false;
    }

    public void m_7856_() {
        this.f_96541_.f_91068_.m_90926_(true);
        OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.CROSSHAIR_ELEMENT, (boolean)false);
    }

    public void m_96624_() {
        try {
            if (this.f_96541_ != null) {
                if (!this.isOpen) {
                    this.window.onOpened();
                    this.isOpen = true;
                } else {
                    this.window.onUpdate();
                    if (!this.f_96541_.f_91074_.m_6084_() || this.f_96541_.f_91074_.f_20890_) {
                        this.f_96541_.f_91074_.m_6915_();
                    }
                }
            }
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"Ticking/Updating BO screen");
            CrashReportCategory category = crashReport.m_127514_("BO screen update details");
            category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
            category.m_128165_("Is opened", () -> Boolean.toString(this.isOpen));
            throw new ReportedException(crashReport);
        }
    }

    public void m_7861_() {
        try {
            this.window.onClosed();
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"Closing BO screen");
            CrashReportCategory category = crashReport.m_127514_("BO screen closing details");
            category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
            category.m_128165_("Is opened", () -> Boolean.toString(this.isOpen));
            throw new ReportedException(crashReport);
        }
        finally {
            BOWindow.clearFocus();
            this.f_96541_.f_91068_.m_90926_(false);
            OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.CROSSHAIR_ELEMENT, (boolean)true);
        }
    }

    public boolean m_7043_() {
        return this.window.doesWindowPauseGame();
    }

    private double calcRelativeX(double xIn) {
        return (xIn * this.mcScale - this.x) / this.renderScale;
    }

    private double calcRelativeY(double yIn) {
        return (yIn * this.mcScale - this.y) / this.renderScale;
    }

    public double getRenderScale() {
        return this.renderScale;
    }

    public double getVanillaGuiScale() {
        return this.mcScale;
    }

    static {
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(65, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(67, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(86, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(88, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(256, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(257, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(258, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(259, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(260, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(261, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(262, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(263, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(264, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(265, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(266, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(267, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(268, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(269, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(280, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(281, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(282, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(283, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(284, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(290, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(291, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(292, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(293, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(294, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(295, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(296, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(297, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(298, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(299, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(300, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(301, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(302, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(303, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(304, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(305, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(306, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(307, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(308, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(309, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(310, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(311, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(312, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(313, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(314, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(320, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(321, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(322, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(323, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(324, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(325, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(326, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(327, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(328, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(329, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(330, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(331, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(332, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(333, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(334, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(335, 1);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(336, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(340, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(341, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(342, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(343, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(344, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(345, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(346, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(347, 0);
        ACCEPTED_KEY_PRESSED_MAP.m_13524_(348, 1);
    }
}

