/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Gradient;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.ImageRepeatable;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextFieldVanilla;
import com.ldtteam.blockui.controls.ToggleButton;
import com.ldtteam.blockui.mod.Log;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.Box;
import com.ldtteam.blockui.views.DropDownList;
import com.ldtteam.blockui.views.Group;
import com.ldtteam.blockui.views.OverlayView;
import com.ldtteam.blockui.views.ScrollingGroup;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.blockui.views.SwitchView;
import com.ldtteam.blockui.views.View;
import com.ldtteam.blockui.views.ZoomDragView;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class Loader
extends SimplePreparableReloadListener<Map<ResourceLocation, PaneParams>> {
    public static final Loader INSTANCE = new Loader();
    private final Map<ResourceLocation, Function<PaneParams, ? extends Pane>> paneFactories = new HashMap<ResourceLocation, Function<PaneParams, ? extends Pane>>();
    private Map<ResourceLocation, PaneParams> xmlCache = new HashMap<ResourceLocation, PaneParams>();

    private Loader() {
        this.register("view", View::new);
        this.register("group", Group::new);
        this.register("scrollgroup", ScrollingGroup::new);
        this.register("list", ScrollingList::new);
        this.register("text", Text::new);
        this.register("button", Button::construct);
        this.register("buttonimage", Button::construct);
        this.register("toggle", ToggleButton::new);
        this.register("label", Text::new);
        this.register("input", TextFieldVanilla::new);
        this.register("image", Image::new);
        this.register("imagerepeat", ImageRepeatable::new);
        this.register("box", Box::new);
        this.register("itemicon", ItemIcon::new);
        this.register("switch", SwitchView::new);
        this.register("dropdown", DropDownList::new);
        this.register("overlay", OverlayView::new);
        this.register("gradient", Gradient::new);
        this.register("zoomdragview", ZoomDragView::new);
    }

    public void register(String name, Function<PaneParams, ? extends Pane> factoryMethod) {
        ResourceLocation key = new ResourceLocation(name);
        if (this.paneFactories.containsKey(key)) {
            throw new IllegalArgumentException("Duplicate pane type '" + name + "' when registering Pane class method.");
        }
        this.paneFactories.put(key, factoryMethod);
    }

    private Pane createFromPaneParams(PaneParams params) {
        ResourceLocation paneType = new ResourceLocation(params.getType());
        if (this.paneFactories.containsKey(paneType)) {
            return this.paneFactories.get(paneType).apply(params);
        }
        if (this.paneFactories.containsKey(new ResourceLocation(paneType.m_135815_()))) {
            Log.getLogger().warn("Namespace override for " + paneType.m_135815_() + " not found. Using default.");
            return this.paneFactories.get(new ResourceLocation(paneType.m_135815_())).apply(params);
        }
        Log.getLogger().error("There is no factory method for " + paneType.m_135815_());
        return null;
    }

    public static Pane createFromPaneParams(PaneParams params, View parent) {
        if ("layout".equalsIgnoreCase(params.getType())) {
            params.getResource("source", r -> Loader.createFromXMLFile(r, parent));
            return null;
        }
        if (parent instanceof BOWindow && params.getType().equals("window")) {
            ((BOWindow)parent).loadParams(params);
            parent.parseChildren(params);
            return parent;
        }
        if (parent instanceof View && params.getType().equals("window")) {
            parent.parseChildren(params);
            return parent;
        }
        params.setParentView(parent);
        Pane pane = INSTANCE.createFromPaneParams(params);
        if (pane != null) {
            pane.putInside(parent);
            pane.parseChildren(params);
        }
        return pane;
    }

    public static void createFromXMLFile(ResourceLocation resource, View parent) {
        if (Loader.INSTANCE.xmlCache.containsKey(resource)) {
            try {
                Loader.createFromPaneParams(Loader.INSTANCE.xmlCache.get(resource), parent);
            }
            catch (Exception e) {
                throw new RuntimeException("Can't parse xml at: " + resource.toString(), e);
            }
        } else {
            throw new RuntimeException("Gui at \"" + resource.toString() + "\" was not found!");
        }
    }

    protected Map<ResourceLocation, PaneParams> prepare(ResourceManager rm, ProfilerFiller profiler) {
        DocumentBuilder documentBuilder;
        profiler.m_7242_();
        profiler.m_6180_("BlockUI-xml-lookup-parsing");
        HashMap<ResourceLocation, PaneParams> foundXmls = new HashMap<ResourceLocation, PaneParams>();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            profiler.m_7238_();
            profiler.m_7241_();
            throw new RuntimeException(e);
        }
        rm.m_6540_("gui", pathStr -> pathStr.endsWith(".xml")).forEach(rl -> {
            Document doc;
            try {
                Resource res = rm.m_142591_(rl);
                doc = documentBuilder.parse(res.m_6679_());
            }
            catch (IOException | SAXException e) {
                Log.getLogger().error("Failed to load xml at: " + rl.toString(), (Throwable)e);
                return;
            }
            doc.getDocumentElement().normalize();
            foundXmls.put((ResourceLocation)rl, new PaneParams(doc.getDocumentElement()));
        });
        profiler.m_7238_();
        profiler.m_7241_();
        return foundXmls;
    }

    protected void apply(Map<ResourceLocation, PaneParams> foundXmls, ResourceManager rm, ProfilerFiller profiler) {
        this.xmlCache = foundXmls;
    }
}

