/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.controls;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.Parsers;
import com.ldtteam.blockui.mod.Log;
import com.ldtteam.blockui.util.records.SizeI;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;

public class Image
extends Pane {
    protected ResourceLocation resourceLocation;
    protected int u = 0;
    protected int v = 0;
    protected int uWidth = 0;
    protected int vHeight = 0;
    protected int mapWidth = 0;
    protected int mapHeight = 0;

    public Image() {
    }

    public Image(PaneParams params) {
        super(params);
        params.applyShorthand("imageoffset", Parsers.INT, 2, a -> {
            this.u = (Integer)a.get(0);
            this.v = (Integer)a.get(1);
        });
        params.applyShorthand("imagesize", Parsers.INT, 2, a -> {
            this.uWidth = (Integer)a.get(0);
            this.vHeight = (Integer)a.get(1);
        });
        this.resourceLocation = params.getResource("source", this::loadMapDimensions);
    }

    private void loadMapDimensions(ResourceLocation rl) {
        SizeI dimensions = Image.getImageDimensions(rl);
        this.mapWidth = dimensions.width();
        this.mapHeight = dimensions.height();
        this.checkBlitSize();
    }

    private void checkBlitSize() {
        String xmlLoc = this.window == null ? "unknown" : this.window.getXmlResourceLocation().toString();
        if (this.u + (this.uWidth == 0 ? this.mapWidth : this.uWidth) > this.mapWidth) {
            throw new RuntimeException("Invalid blit width for image: id - " + this.id + ", window - " + xmlLoc);
        }
        if (this.v + (this.vHeight == 0 ? this.mapHeight : this.vHeight) > this.mapHeight) {
            throw new RuntimeException("Invalid blit height for image: id - " + this.id + ", window - " + xmlLoc);
        }
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.checkBlitSize();
    }

    public void setMapDimensions(int height, int width) {
        this.mapHeight = height;
        this.mapWidth = width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SizeI getImageDimensions(ResourceLocation resourceLocation) {
        int pos = resourceLocation.m_135815_().lastIndexOf(".");
        if (pos == -1) {
            throw new IllegalStateException("No extension for file: " + resourceLocation.toString());
        }
        String suffix = resourceLocation.m_135815_().substring(pos + 1);
        Iterator<ImageReader> it = ImageIO.getImageReadersBySuffix(suffix);
        while (it.hasNext()) {
            SizeI sizeI;
            ImageReader reader;
            block12: {
                reader = it.next();
                ImageInputStream stream = ImageIO.createImageInputStream(Minecraft.m_91087_().m_91098_().m_142591_(resourceLocation).m_6679_());
                try {
                    reader.setInput(stream);
                    sizeI = new SizeI(reader.getWidth(reader.getMinIndex()), reader.getHeight(reader.getMinIndex()));
                    if (stream == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            Log.getLogger().warn((Object)e);
                            reader.dispose();
                            continue;
                        }
                    }
                    catch (Throwable throwable3) {
                        reader.dispose();
                        throw throwable3;
                    }
                }
                stream.close();
            }
            reader.dispose();
            return sizeI;
        }
        return new SizeI(0, 0);
    }

    public void setImage(ResourceLocation rl, int u, int v, int uWidth, int vHeight) {
        this.resourceLocation = rl;
        this.u = u;
        this.v = v;
        this.uWidth = uWidth;
        this.vHeight = vHeight;
        this.loadMapDimensions(rl);
    }

    public void setImage(ResourceLocation rl, boolean keepUv) {
        this.resourceLocation = rl;
        if (!keepUv) {
            this.u = 0;
            this.v = 0;
            this.uWidth = 0;
            this.vHeight = 0;
        }
        this.loadMapDimensions(rl);
    }

    @Override
    public void drawSelf(PoseStack ms, double mx, double my) {
        Objects.requireNonNull(this.resourceLocation, () -> this.id + " | " + this.window.getXmlResourceLocation());
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        if (this.u != 0 || this.v != 0 || this.uWidth != 0 || this.vHeight != 0) {
            Image.blit(ms, this.resourceLocation, this.x, this.y, this.width, this.height, this.u, this.v, this.uWidth == 0 ? this.mapWidth : this.uWidth, this.vHeight == 0 ? this.mapHeight : this.vHeight, this.mapWidth, this.mapHeight);
        } else {
            Image.blit(ms, this.resourceLocation, this.x, this.y, this.width, this.height);
        }
        RenderSystem.m_69461_();
    }
}

