/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealth.config;

import com.google.gson.annotations.JsonAdapter;
import net.torocraft.torohealth.config.loader.ColorJsonAdpater;
import net.torocraft.torohealth.config.loader.IConfig;

public class Config
implements IConfig {
    public boolean watchForChanges = true;
    public Hud hud = new Hud();
    public Bar bar = new Bar();
    public InWorld inWorld = new InWorld();
    public Particle particle = new Particle();

    @Override
    public void update() {
        this.particle.distanceSquared = this.particle.distance * this.particle.distance;
    }

    @Override
    public boolean shouldWatch() {
        return this.watchForChanges;
    }

    public static class Hud {
        public int distance = 60;
        public float x = 4.0f;
        public float y = 4.0f;
        public float scale = 1.0f;
        public int hideDelay = 20;
        public AnchorPoint anchorPoint = AnchorPoint.TOP_LEFT;
        public boolean showEntity = true;
        public boolean showBar = true;
        public boolean showSkin = true;
        public boolean onlyWhenHurt = false;
    }

    public static class Bar {
        public NumberType damageNumberType = NumberType.LAST;
        @JsonAdapter(value=ColorJsonAdpater.class)
        public int friendColor = 65280;
        @JsonAdapter(value=ColorJsonAdpater.class)
        public int friendColorSecondary = 32768;
        @JsonAdapter(value=ColorJsonAdpater.class)
        public int foeColor = 0xFF0000;
        @JsonAdapter(value=ColorJsonAdpater.class)
        public int foeColorSecondary = 0x800000;
    }

    public static class InWorld {
        public Mode mode = Mode.NONE;
        public float distance = 60.0f;
        public boolean onlyWhenLookingAt = false;
        public boolean onlyWhenHurt = false;
    }

    public static class Particle {
        public boolean show = true;
        @JsonAdapter(value=ColorJsonAdpater.class)
        public int damageColor = 0xFF0000;
        @JsonAdapter(value=ColorJsonAdpater.class)
        public int healColor = 65280;
        public int distance = 60;
        public transient int distanceSquared = 0;
    }

    public static enum AnchorPoint {
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_CENTER,
        BOTTOM_RIGHT;

    }

    public static enum NumberType {
        NONE,
        LAST,
        CUMULATIVE;

    }

    public static enum Mode {
        NONE,
        WHEN_HOLDING_WEAPON,
        ALWAYS;

    }
}

