/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealth.display;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.torocraft.torohealth.config.Config;
import net.torocraft.torohealth.display.BarDisplay;
import net.torocraft.torohealth.display.EntityDisplay;

public class Hud
extends Screen {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("torohealth:textures/gui/default_skin_basic.png");
    private EntityDisplay entityDisplay = new EntityDisplay();
    private LivingEntity entity;
    private BarDisplay barDisplay;
    private Config config = new Config();
    private int age;

    public Hud() {
        super((Component)new TextComponent("ToroHealth HUD"));
        this.f_96541_ = Minecraft.m_91087_();
        this.barDisplay = new BarDisplay(Minecraft.m_91087_(), (GuiComponent)this);
    }

    public void draw(PoseStack matrix, Config config) {
        if (this.f_96541_.f_91066_.f_92063_) {
            return;
        }
        this.config = config;
        if (this.config == null) {
            this.config = new Config();
        }
        float x = this.determineX();
        float y = this.determineY();
        this.draw(matrix, x, y, config.hud.scale);
    }

    private float determineX() {
        float x = this.config.hud.x;
        Config.AnchorPoint anchor = this.config.hud.anchorPoint;
        float wScreen = this.f_96541_.m_91268_().m_85446_();
        switch (anchor) {
            case BOTTOM_CENTER: 
            case TOP_CENTER: {
                return wScreen / 2.0f + x;
            }
            case BOTTOM_RIGHT: 
            case TOP_RIGHT: {
                return wScreen + x;
            }
        }
        return x;
    }

    private float determineY() {
        float y = this.config.hud.y;
        Config.AnchorPoint anchor = this.config.hud.anchorPoint;
        float hScreen = this.f_96541_.m_91268_().m_85446_();
        switch (anchor) {
            case BOTTOM_CENTER: 
            case BOTTOM_RIGHT: 
            case BOTTOM_LEFT: {
                return y + hScreen;
            }
        }
        return y;
    }

    public void m_96624_() {
        ++this.age;
    }

    public void setEntity(LivingEntity entity) {
        if (entity != null) {
            this.age = 0;
        }
        if (entity == null && this.age > this.config.hud.hideDelay) {
            this.setEntityWork(null);
        }
        if (entity != null && entity != this.entity) {
            this.setEntityWork(entity);
        }
    }

    private void setEntityWork(LivingEntity entity) {
        this.entity = entity;
        this.entityDisplay.setEntity(entity);
    }

    public LivingEntity getEntity() {
        return this.entity;
    }

    private void draw(PoseStack matrix, float x, float y, float scale) {
        if (this.entity == null) {
            return;
        }
        if (this.config.hud.onlyWhenHurt && this.entity.m_21223_() >= this.entity.m_21233_()) {
            return;
        }
        matrix.m_85836_();
        matrix.m_85841_(scale, scale, scale);
        matrix.m_85837_((double)(x - 10.0f), (double)(y - 10.0f), 0.0);
        if (this.config.hud.showSkin) {
            this.drawSkin(matrix);
        }
        matrix.m_85837_(10.0, 10.0, 0.0);
        if (this.config.hud.showEntity) {
            this.entityDisplay.draw(matrix, scale);
        }
        matrix.m_85837_(44.0, 0.0, 0.0);
        if (this.config.hud.showBar) {
            this.barDisplay.draw(matrix, this.entity);
        }
        matrix.m_85849_();
    }

    private void drawSkin(PoseStack matrix) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int w = 160;
        int h = 60;
        Hud.m_93133_((PoseStack)matrix, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)w, (int)h, (int)w, (int)h);
    }
}

