/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.configs;

import net.minecraftforge.common.ForgeConfigSpec;

public class RSDungeonsConfig {
    public static final ForgeConfigSpec GENERAL_SPEC;
    public static ForgeConfigSpec.BooleanValue shulkerBoxInEndDungeons;
    public static ForgeConfigSpec.IntValue badlandsDungeonAttemptsPerChunk;
    public static ForgeConfigSpec.IntValue darkForestDungeonAttemptsPerChunk;
    public static ForgeConfigSpec.IntValue desertDungeonAttemptsPerChunk;
    public static ForgeConfigSpec.IntValue jungleDungeonAttemptsPerChunk;
    public static ForgeConfigSpec.IntValue mushroomDungeonAttemptsPerChunk;
    public static ForgeConfigSpec.IntValue snowDungeonAttemptsPerChunk;
    public static ForgeConfigSpec.IntValue icyDungeonAttemptsPerChunk;
    public static ForgeConfigSpec.IntValue swampDungeonAttemptsPerChunk;
    public static ForgeConfigSpec.IntValue endDungeonAttemptsPerChunk;
    public static ForgeConfigSpec.IntValue netherDungeonAttemptsPerChunk;
    public static ForgeConfigSpec.IntValue oceanDungeonAttemptsPerChunk;
    public static ForgeConfigSpec.ConfigValue<Integer> badlandsDungeonMinHeight;
    public static ForgeConfigSpec.ConfigValue<Integer> darkForestDungeonMinHeight;
    public static ForgeConfigSpec.ConfigValue<Integer> desertDungeonMinHeight;
    public static ForgeConfigSpec.ConfigValue<Integer> jungleDungeonMinHeight;
    public static ForgeConfigSpec.ConfigValue<Integer> mushroomDungeonMinHeight;
    public static ForgeConfigSpec.ConfigValue<Integer> snowDungeonMinHeight;
    public static ForgeConfigSpec.ConfigValue<Integer> icyDungeonMinHeight;
    public static ForgeConfigSpec.ConfigValue<Integer> swampDungeonMinHeight;
    public static ForgeConfigSpec.ConfigValue<Integer> endDungeonMinHeight;
    public static ForgeConfigSpec.ConfigValue<Integer> netherDungeonMinHeight;
    public static ForgeConfigSpec.ConfigValue<Integer> oceanDungeonMinHeight;
    public static ForgeConfigSpec.ConfigValue<Integer> badlandsDungeonMaxHeight;
    public static ForgeConfigSpec.ConfigValue<Integer> darkForestDungeonMaxHeight;
    public static ForgeConfigSpec.ConfigValue<Integer> desertDungeonMaxHeight;
    public static ForgeConfigSpec.ConfigValue<Integer> jungleDungeonMaxHeight;
    public static ForgeConfigSpec.ConfigValue<Integer> mushroomDungeonMaxHeight;
    public static ForgeConfigSpec.ConfigValue<Integer> snowDungeonMaxHeight;
    public static ForgeConfigSpec.ConfigValue<Integer> icyDungeonMaxHeight;
    public static ForgeConfigSpec.ConfigValue<Integer> swampDungeonMaxHeight;
    public static ForgeConfigSpec.ConfigValue<Integer> endDungeonMaxHeight;
    public static ForgeConfigSpec.ConfigValue<Integer> netherDungeonMaxHeight;
    public static ForgeConfigSpec.ConfigValue<Integer> oceanDungeonMaxHeight;

    private static void setupConfig(ForgeConfigSpec.Builder builder) {
        shulkerBoxInEndDungeons = builder.comment(new String[]{"\n Whether End Dungeons spawns Shulker Boxes. if false, spawns regular Chests instead.", "(Configuredfeatures are unable to be overridden by datapack due to bad Forge hook placement. Hence this config option)"}).translation("repurposedstructures.shulkerboxinenddungeons").define("shulkerBoxInEndDungeons", true);
        builder.comment(new String[]{"-----------------------------------------------------------------------------------------", " How many positions Repurposed Structures Dungeons will pick per chunk to check if it can spawn at those positions.", " Will replace Vanilla Dungeons with RS's themed dungeons if both would've been in same biome. (except for RS's Ocean Dungeon)", " 0 for no Dungeons at all and 1000 for max Dungeon spawnrate.", " Note: Vanilla Dungeons will spawn again if a RS Dungeon's entry is set to 0 for the biome."});
        builder.push("AttemptsPerChunk");
        badlandsDungeonAttemptsPerChunk = builder.translation("repurposedstructures.badlandsdungeonattemptsperchunk").defineInRange("badlandsDungeonAttemptsPerChunk", 8, 0, 1000);
        darkForestDungeonAttemptsPerChunk = builder.translation("repurposedstructures.darkforestdungeonattemptsperchunk").defineInRange("darkForestDungeonAttemptsPerChunk", 8, 0, 1000);
        desertDungeonAttemptsPerChunk = builder.translation("repurposedstructures.desertdungeonattemptsperchunk").defineInRange("desertDungeonAttemptsPerChunk", 8, 0, 1000);
        jungleDungeonAttemptsPerChunk = builder.translation("repurposedstructures.jungledungeonattemptsperchunk").defineInRange("jungleDungeonAttemptsPerChunk", 8, 0, 1000);
        mushroomDungeonAttemptsPerChunk = builder.translation("repurposedstructures.mushroomdungeonattemptsperchunk").defineInRange("mushroomDungeonAttemptsPerChunk", 8, 0, 1000);
        snowDungeonAttemptsPerChunk = builder.translation("repurposedstructures.snowdungeonattemptsperchunk").defineInRange("snowDungeonAttemptsPerChunk", 8, 0, 1000);
        icyDungeonAttemptsPerChunk = builder.translation("repurposedstructures.snowdungeonattemptsperchunk").defineInRange("snowDungeonAttemptsPerChunk", 8, 0, 1000);
        swampDungeonAttemptsPerChunk = builder.translation("repurposedstructures.swampdungeonattemptsperchunk").defineInRange("swampDungeonAttemptsPerChunk", 8, 0, 1000);
        endDungeonAttemptsPerChunk = builder.translation("repurposedstructures.enddungeonattemptsperchunk").defineInRange("endDungeonAttemptsPerChunk", 12, 0, 1000);
        netherDungeonAttemptsPerChunk = builder.translation("repurposedstructures.netherdungeonattemptsperchunk").defineInRange("netherDungeonAttemptsPerChunk", 12, 0, 1000);
        oceanDungeonAttemptsPerChunk = builder.translation("repurposedstructures.oceandungeonattemptsperchunk").defineInRange("oceanDungeonAttemptsPerChunk", 3, 0, 1000);
        builder.pop();
        builder.comment(new String[]{"-----------------------------------------------------------------------------------------", " Minimum Y height that this dungeon can spawn at.", " Note: The dungeon will spawn between min and max y height set in config."});
        builder.push("Min Height");
        badlandsDungeonMinHeight = builder.translation("repurposedstructures.badlandsdungeonminheight").define("badlandsDungeonMinHeight", (Object)35);
        darkForestDungeonMinHeight = builder.translation("repurposedstructures.darkforestdungeonminheight").define("darkForestDungeonMinHeight", (Object)35);
        desertDungeonMinHeight = builder.translation("repurposedstructures.desertdungeonminheight").define("desertDungeonMinHeight", (Object)35);
        jungleDungeonMinHeight = builder.translation("repurposedstructures.jungledungeonminheight").define("jungleDungeonMinHeight", (Object)35);
        mushroomDungeonMinHeight = builder.translation("repurposedstructures.mushroomdungeonminheight").define("mushroomDungeonMinHeight", (Object)35);
        snowDungeonMinHeight = builder.translation("repurposedstructures.snowdungeonminheight").define("snowDungeonMinHeight", (Object)35);
        icyDungeonMinHeight = builder.translation("repurposedstructures.icydungeonminheight").define("icyDungeonMinHeight", (Object)35);
        swampDungeonMinHeight = builder.translation("repurposedstructures.swampdungeonminheight").define("swampDungeonMinHeight", (Object)35);
        endDungeonMinHeight = builder.translation("repurposedstructures.enddungeonminheight").define("endDungeonMinHeight", (Object)2);
        netherDungeonMinHeight = builder.translation("repurposedstructures.netherdungeonminheight").define("netherDungeonMinHeight", (Object)2);
        oceanDungeonMinHeight = builder.translation("repurposedstructures.oceandungeonminheight").define("oceanDungeonMinHeight", (Object)20);
        builder.pop();
        builder.comment(new String[]{"-----------------------------------------------------------------------------------------", " Maximum Y height that this dungeon can spawn at.", " Note: The dungeon will spawn between min and max y height set in config.", " Setting this to below min height config will make dungeon spawn only at min height."});
        builder.push("Max Height");
        badlandsDungeonMaxHeight = builder.translation("repurposedstructures.badlandsdungeonmaxheight").define("badlandsDungeonMaxHeight", (Object)255);
        darkForestDungeonMaxHeight = builder.translation("repurposedstructures.darkforestdungeonmaxheight").define("darkForestDungeonMaxHeight", (Object)255);
        desertDungeonMaxHeight = builder.translation("repurposedstructures.desertdungeonmaxheight").define("desertDungeonMaxHeight", (Object)255);
        jungleDungeonMaxHeight = builder.translation("repurposedstructures.jungledungeonmaxheight").define("jungleDungeonMaxHeight", (Object)255);
        mushroomDungeonMaxHeight = builder.translation("repurposedstructures.mushroomdungeonmaxheight").define("mushroomDungeonMaxHeight", (Object)255);
        snowDungeonMaxHeight = builder.translation("repurposedstructures.snowdungeonmaxheight").define("snowDungeonMaxHeight", (Object)255);
        icyDungeonMaxHeight = builder.translation("repurposedstructures.icydungeonmaxheight").define("icyDungeonMaxHeight", (Object)255);
        swampDungeonMaxHeight = builder.translation("repurposedstructures.swampdungeonmaxheight").define("swampDungeonMaxHeight", (Object)255);
        endDungeonMaxHeight = builder.translation("repurposedstructures.enddungeonmaxheight").define("endDungeonMaxHeight", (Object)255);
        netherDungeonMaxHeight = builder.translation("repurposedstructures.netherdungeonmaxheight").define("netherDungeonMaxHeight", (Object)255);
        oceanDungeonMaxHeight = builder.translation("repurposedstructures.oceandungeonmaxheight").define("oceanDungeonMaxHeight", (Object)255);
        builder.pop();
    }

    static {
        ForgeConfigSpec.Builder configBuilder = new ForgeConfigSpec.Builder();
        RSDungeonsConfig.setupConfig(configBuilder);
        GENERAL_SPEC = configBuilder.build();
    }
}

