/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc;

import com.google.gson.JsonObject;
import com.telepathicgrunt.repurposedstructures.configs.RSModdedLootConfig;
import com.telepathicgrunt.repurposedstructures.misc.EndRemasteredDedicatedLoot;
import com.telepathicgrunt.repurposedstructures.mixin.resources.LootContextAccessor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class StructureModdedLootImporter
extends LootModifier {
    private static final Map<ResourceLocation, ResourceLocation> TABLE_IMPORTS = StructureModdedLootImporter.createMap();
    private static Set<ResourceLocation> BLACKLISTED_LOOTTABLES;

    private static Map<ResourceLocation, ResourceLocation> createMap() {
        HashMap<ResourceLocation, ResourceLocation> tableMap = new HashMap<ResourceLocation, ResourceLocation>();
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshaft/birch"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshaft/crimson"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshaft/desert"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshaft/end"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshaft/icy"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshaft/jungle"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshaft/nether"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshaft/ocean"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshaft/savanna"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshaft/stone"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshaft/dark_forest"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshaft/swamp"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshaft/taiga"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshaft/warped"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/bastions/underground/bridge"), new ResourceLocation("minecraft:chests/stronghold_corridor"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/bastions/underground/other"), new ResourceLocation("minecraft:chests/stronghold_corridor"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/bastions/underground/skeleton_horse_stable"), new ResourceLocation("minecraft:chests/stronghold_corridor"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/cities/nether"), new ResourceLocation("minecraft:chests/bastion_treasure"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeon/badlands"), new ResourceLocation("minecraft:chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeon/dark_forest"), new ResourceLocation("minecraft:chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeon/desert"), new ResourceLocation("minecraft:chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeon/end"), new ResourceLocation("minecraft:chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeon/jungle"), new ResourceLocation("minecraft:chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeon/mushroom"), new ResourceLocation("minecraft:chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeon/nether"), new ResourceLocation("minecraft:chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeon/ocean"), new ResourceLocation("minecraft:chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeon/snow"), new ResourceLocation("minecraft:chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeon/swamp"), new ResourceLocation("minecraft:chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/fortress/jungle_center_chest"), new ResourceLocation("minecraft:chests/stronghold_crossing"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/fortress/jungle_hallway_chest"), new ResourceLocation("minecraft:chests/stronghold_corridor"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/fortress/jungle_shrine_chest"), new ResourceLocation("minecraft:chests/stronghold_crossing"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/igloos/grassy_chest"), new ResourceLocation("minecraft:chests/igloo_chest"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/igloos/stone_chest"), new ResourceLocation("minecraft:chests/igloo_chest"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mansion/birch"), new ResourceLocation("minecraft:chests/woodland_mansion"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mansion/desert"), new ResourceLocation("minecraft:chests/woodland_mansion"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mansion/jungle"), new ResourceLocation("minecraft:chests/woodland_mansion"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mansion/oak"), new ResourceLocation("minecraft:chests/woodland_mansion"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mansion/savanna"), new ResourceLocation("minecraft:chests/woodland_mansion"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mansion/snowy"), new ResourceLocation("minecraft:chests/woodland_mansion"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mansion/taiga"), new ResourceLocation("minecraft:chests/woodland_mansion"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outpost/badlands_chest"), new ResourceLocation("minecraft:chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outpost/birch_chest"), new ResourceLocation("minecraft:chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outpost/crimson_chest"), new ResourceLocation("minecraft:chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outpost/desert_chest"), new ResourceLocation("minecraft:chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outpost/giant_tree_taiga_chest"), new ResourceLocation("minecraft:chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outpost/icy_chest"), new ResourceLocation("minecraft:chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outpost/jungle_chest"), new ResourceLocation("minecraft:chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outpost/nether_brick_chest"), new ResourceLocation("minecraft:chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outpost/oak_chest"), new ResourceLocation("minecraft:chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outpost/snowy_chest"), new ResourceLocation("minecraft:chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outpost/taiga_chest"), new ResourceLocation("minecraft:chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outpost/warped_chest"), new ResourceLocation("minecraft:chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outpost/end_shulker_box"), new ResourceLocation("minecraft:chests/end_city_treasure"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/pyramid/badlands_chest"), new ResourceLocation("minecraft:chests/desert_pyramid"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/pyramid/nether_chest"), new ResourceLocation("minecraft:chests/desert_pyramid"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/pyramid/snowy_chest"), new ResourceLocation("minecraft:chests/desert_pyramid"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/pyramid/icy_chest"), new ResourceLocation("minecraft:chests/desert_pyramid"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/pyramid/jungle_chest"), new ResourceLocation("minecraft:chests/desert_pyramid"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/pyramid/mushroom_chest"), new ResourceLocation("minecraft:chests/desert_pyramid"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/pyramid/ocean_chest"), new ResourceLocation("minecraft:chests/desert_pyramid"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/pyramid/giant_tree_taiga_chest"), new ResourceLocation("minecraft:chests/desert_pyramid"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/pyramid/flower_forest_chest"), new ResourceLocation("minecraft:chests/desert_pyramid"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/pyramid/end_chest"), new ResourceLocation("minecraft:chests/end_city_treasure"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/ruin/nether"), new ResourceLocation("minecraft:chests/bastion_other"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/ruin/land_hot/large"), new ResourceLocation("minecraft:chests/village/village_desert_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/ruin/land_hot/small"), new ResourceLocation("minecraft:chests/village/village_desert_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/ruin/land_warm/large"), new ResourceLocation("minecraft:chests/village/village_plains_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/ruin/land_warm/small"), new ResourceLocation("minecraft:chests/village/village_plains_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/ruined_portal/large_portal_chest"), new ResourceLocation("minecraft:chests/ruined_portal"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/ruined_portal/small_portal_chest"), new ResourceLocation("minecraft:chests/ruined_portal"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/shipwreck/crimson/map_chest"), new ResourceLocation("minecraft:chests/shipwreck_map"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/shipwreck/crimson/supply_chest"), new ResourceLocation("minecraft:chests/shipwreck_supply"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/shipwreck/crimson/treasure_chest"), new ResourceLocation("minecraft:chests/shipwreck_treasure"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/shipwreck/end/map_chest"), new ResourceLocation("minecraft:chests/shipwreck_map"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/shipwreck/end/supply_chest"), new ResourceLocation("minecraft:chests/shipwreck_supply"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/shipwreck/end/treasure_chest"), new ResourceLocation("minecraft:chests/end_city_treasure"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/shipwreck/warped/map_chest"), new ResourceLocation("minecraft:chests/shipwreck_map"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/shipwreck/warped/supply_chest"), new ResourceLocation("minecraft:chests/shipwreck_supply"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/shipwreck/warped/treasure_chest"), new ResourceLocation("minecraft:chests/shipwreck_treasure"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/shipwreck/nether_bricks/treasure_chest"), new ResourceLocation("minecraft:chests/shipwreck_treasure"));
        tableMap.put(new ResourceLocation("repurposed_structures", "shulker_boxes/stronghold/end_storage_room"), new ResourceLocation("minecraft:chests/end_city_treasure"));
        tableMap.put(new ResourceLocation("repurposed_structures", "shulker_boxes/stronghold/end_hallway"), new ResourceLocation("minecraft:chests/end_city_treasure"));
        tableMap.put(new ResourceLocation("repurposed_structures", "shulker_boxes/stronghold/end_library"), new ResourceLocation("minecraft:chests/end_city_treasure"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/stronghold/nether_storage_room"), new ResourceLocation("minecraft:chests/stronghold_crossing"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/stronghold/nether_hallway"), new ResourceLocation("minecraft:chests/stronghold_corridor"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/stronghold/nether_library"), new ResourceLocation("minecraft:chests/stronghold_library"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/temple/nether_basalt_chest"), new ResourceLocation("minecraft:chests/nether_bridge"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/temple/nether_crimson_chest"), new ResourceLocation("minecraft:chests/nether_bridge"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/temple/nether_soul_chest"), new ResourceLocation("minecraft:chests/nether_bridge"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/temple/nether_warped_chest"), new ResourceLocation("minecraft:chests/nether_bridge"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/temple/nether_warped_trapped_chest"), new ResourceLocation("minecraft:chests/nether_bridge"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/temple/nether_wasteland_chest"), new ResourceLocation("minecraft:chests/nether_bridge"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/temple/nether_basalt_dispenser"), new ResourceLocation("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/temple/nether_crimson_dispenser"), new ResourceLocation("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/temple/nether_soul_dispenser"), new ResourceLocation("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/temple/nether_warped_dispenser"), new ResourceLocation("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/temple/nether_wasteland_dispenser"), new ResourceLocation("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/village/village_badands_house"), new ResourceLocation("minecraft:chests/village/village_desert_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/village/village_birch_house"), new ResourceLocation("minecraft:chests/village/village_plains_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/village/village_dark_forest_house"), new ResourceLocation("minecraft:chests/village/village_plains_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/village/village_giant_taiga_house"), new ResourceLocation("minecraft:chests/village/village_taiga_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/village/village_jungle_house"), new ResourceLocation("minecraft:chests/village/village_savanna_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/village/village_mountains_house"), new ResourceLocation("minecraft:chests/village/village_snowy_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/village/village_oak_house"), new ResourceLocation("minecraft:chests/village/village_plains_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/village/village_swamp_house"), new ResourceLocation("minecraft:chests/village/village_plains_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/village/village_crimson_cartographer"), new ResourceLocation("minecraft:chests/village/village_cartographer"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/village/village_crimson_fisher"), new ResourceLocation("minecraft:chests/village/village_fisher"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/village/village_crimson_tanner"), new ResourceLocation("minecraft:chests/village/village_tannery"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/village/village_crimson_weaponsmith"), new ResourceLocation("minecraft:chests/village/village_weaponsmith"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/village/village_crimson_house"), new ResourceLocation("minecraft:chests/village/village_desert_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/village/village_warped_cartographer"), new ResourceLocation("minecraft:chests/village/village_cartographer"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/village/village_warped_fisher"), new ResourceLocation("minecraft:chests/village/village_fisher"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/village/village_warped_tanner"), new ResourceLocation("minecraft:chests/village/village_tannery"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/village/village_warped_weaponsmith"), new ResourceLocation("minecraft:chests/village/village_weaponsmith"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/village/village_warped_house"), new ResourceLocation("minecraft:chests/village/village_desert_house"));
        tableMap.put(new ResourceLocation("betterstrongholds", "chests/end/armoury"), new ResourceLocation("minecraft:chests/end_city_treasure"));
        tableMap.put(new ResourceLocation("betterstrongholds", "chests/end/common"), new ResourceLocation("minecraft:chests/end_city_treasure"));
        tableMap.put(new ResourceLocation("betterstrongholds", "chests/end/crypt"), new ResourceLocation("minecraft:chests/end_city_treasure"));
        tableMap.put(new ResourceLocation("betterstrongholds", "chests/end/grand_library"), new ResourceLocation("minecraft:chests/end_city_treasure"));
        tableMap.put(new ResourceLocation("betterstrongholds", "chests/end/library_md"), new ResourceLocation("minecraft:chests/end_city_treasure"));
        tableMap.put(new ResourceLocation("betterstrongholds", "chests/end/mess"), new ResourceLocation("minecraft:chests/end_city_treasure"));
        tableMap.put(new ResourceLocation("betterstrongholds", "chests/end/prison_lg"), new ResourceLocation("minecraft:chests/end_city_treasure"));
        tableMap.put(new ResourceLocation("betterstrongholds", "chests/end/trap"), new ResourceLocation("minecraft:chests/end_city_treasure"));
        tableMap.put(new ResourceLocation("betterstrongholds", "chests/end/treasure"), new ResourceLocation("minecraft:chests/end_city_treasure"));
        tableMap.put(new ResourceLocation("betterstrongholds", "chests/nether/common"), new ResourceLocation("minecraft:chests/stronghold_crossing"));
        tableMap.put(new ResourceLocation("betterstrongholds", "chests/nether/mess"), new ResourceLocation("minecraft:chests/stronghold_crossing"));
        tableMap.put(new ResourceLocation("betterstrongholds", "chests/nether/armoury"), new ResourceLocation("minecraft:chests/stronghold_corridor"));
        tableMap.put(new ResourceLocation("betterstrongholds", "chests/nether/crypt"), new ResourceLocation("minecraft:chests/stronghold_corridor"));
        tableMap.put(new ResourceLocation("betterstrongholds", "chests/nether/prison_lg"), new ResourceLocation("minecraft:chests/stronghold_corridor"));
        tableMap.put(new ResourceLocation("betterstrongholds", "chests/nether/trap"), new ResourceLocation("minecraft:chests/stronghold_corridor"));
        tableMap.put(new ResourceLocation("betterstrongholds", "chests/nether/treasure"), new ResourceLocation("minecraft:chests/stronghold_corridor"));
        tableMap.put(new ResourceLocation("betterstrongholds", "chests/nether/grand_library"), new ResourceLocation("minecraft:chests/stronghold_library"));
        tableMap.put(new ResourceLocation("betterstrongholds", "chests/nether/library_md"), new ResourceLocation("minecraft:chests/stronghold_library"));
        return tableMap;
    }

    public StructureModdedLootImporter(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (!((Boolean)RSModdedLootConfig.importModdedItems.get()).booleanValue() || StructureModdedLootImporter.isInBlacklist(context.getQueriedLootTableId())) {
            return generatedLoot;
        }
        ResourceLocation tableToImportLoot = TABLE_IMPORTS.get(context.getQueriedLootTableId());
        if (tableToImportLoot == null) {
            return generatedLoot;
        }
        LootContext newContext = StructureModdedLootImporter.copyLootContextWithNewQueryID(context, tableToImportLoot);
        List newlyGeneratedLoot = context.m_78940_(tableToImportLoot).m_79129_(newContext);
        newlyGeneratedLoot.removeIf(itemStack -> itemStack.m_41720_().getRegistryName().m_135827_().equals("minecraft"));
        EndRemasteredDedicatedLoot.handleDedicatedModCompat(newlyGeneratedLoot, context);
        generatedLoot.addAll(newlyGeneratedLoot);
        return generatedLoot;
    }

    private static boolean isInBlacklist(ResourceLocation lootTableID) {
        if (BLACKLISTED_LOOTTABLES == null) {
            String cleanedBlacklist = ((String)RSModdedLootConfig.blacklistedRSLoottablesFromImportingModdedItems.get()).trim();
            BLACKLISTED_LOOTTABLES = cleanedBlacklist.equals("") ? new HashSet<ResourceLocation>() : Arrays.stream(cleanedBlacklist.split(",")).map(String::trim).map(ResourceLocation::new).collect(Collectors.toSet());
        }
        return BLACKLISTED_LOOTTABLES.contains(lootTableID);
    }

    protected static LootContext copyLootContextWithNewQueryID(LootContext oldLootContext, ResourceLocation newQueryID) {
        LootContext newContext = new LootContext.Builder(oldLootContext).m_78975_(LootContextParamSets.f_81411_);
        ((LootContextAccessor)newContext).repurposedstructures_setQueriedLootTableId(newQueryID);
        return newContext;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<StructureModdedLootImporter> {
        public StructureModdedLootImporter read(ResourceLocation location, JsonObject object, LootItemCondition[] conditions) {
            return new StructureModdedLootImporter(conditions);
        }

        public JsonObject write(StructureModdedLootImporter instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

