/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.predicates;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSPredicates;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTestType;

public class MatterPhaseRuleTest
extends RuleTest {
    public static final Codec<MatterPhaseRuleTest> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StringRepresentable.m_14350_(MATTER_PHASE::values, MATTER_PHASE::byName).fieldOf("phase_to_test_for").stable().forGetter(ruletest -> ruletest.phaseToTestFor), (App)Codec.BOOL.fieldOf("invert_condition").orElse((Object)false).forGetter(ruletest -> ruletest.invertCondition)).apply((Applicative)instance, instance.stable(MatterPhaseRuleTest::new)));
    private final MATTER_PHASE phaseToTestFor;
    private final boolean invertCondition;

    private MatterPhaseRuleTest(MATTER_PHASE phaseToTestFor, boolean invertCondition) {
        this.phaseToTestFor = phaseToTestFor;
        this.invertCondition = invertCondition;
    }

    public boolean m_7715_(BlockState state, Random random) {
        boolean phaseMatch = false;
        switch (this.phaseToTestFor) {
            case AIR: {
                if (!state.m_60795_()) break;
                phaseMatch = true;
                break;
            }
            case LIQUID: {
                if (state.m_60819_().m_76178_()) break;
                phaseMatch = true;
                break;
            }
            case SOLID: {
                if (state.m_60795_() || !state.m_60819_().m_76178_() || !state.m_60815_()) break;
                phaseMatch = true;
                break;
            }
            case AIR_RAIL_OR_CHAIN: {
                if (!state.m_60795_() && !state.m_60713_(Blocks.f_50184_) && !state.m_60713_(Blocks.f_50156_)) break;
                phaseMatch = true;
            }
        }
        if (this.invertCondition) {
            phaseMatch = !phaseMatch;
        }
        return phaseMatch;
    }

    protected RuleTestType<?> m_7319_() {
        return RSPredicates.MATTER_PHASE_RULE_TEST;
    }

    public static enum MATTER_PHASE implements StringRepresentable
    {
        SOLID("SOLID"),
        LIQUID("LIQUID"),
        AIR("AIR"),
        AIR_RAIL_OR_CHAIN("AIR_RAIL_OR_CHAIN");

        private final String name;
        private static final Map<String, MATTER_PHASE> BY_NAME;

        private MATTER_PHASE(String name) {
            this.name = name;
        }

        public static MATTER_PHASE byName(String name) {
            return BY_NAME.get(name.toUpperCase(Locale.ROOT));
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            BY_NAME = (Map)Util.m_137469_((Object)Maps.newHashMap(), hashMap -> {
                MATTER_PHASE[] var1;
                for (MATTER_PHASE type : var1 = MATTER_PHASE.values()) {
                    hashMap.put(type.name, type);
                }
            });
        }
    }
}

