/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class RandomReplaceWithPropertiesProcessor
extends StructureProcessor {
    public static final Codec<RandomReplaceWithPropertiesProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.f_122824_.m_194605_().fieldOf("input_block").forGetter(config -> config.inputBlock), (App)Registry.f_122824_.m_194605_().optionalFieldOf("output_block").forGetter(config -> config.outputBlock), (App)Registry.f_122824_.m_194605_().listOf().optionalFieldOf("output_blocks", (Object)ImmutableList.of()).forGetter(config -> config.outputBlocks), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(config -> Float.valueOf(config.probability))).apply((Applicative)instance, instance.stable(RandomReplaceWithPropertiesProcessor::new)));
    private final Block inputBlock;
    private final Optional<Block> outputBlock;
    private final List<Block> outputBlocks;
    private final float probability;

    public RandomReplaceWithPropertiesProcessor(Block inputBlock, Optional<Block> outputBlock, List<Block> outputBlocks, float probability) {
        this.inputBlock = inputBlock;
        this.outputBlock = outputBlock;
        this.outputBlocks = outputBlocks;
        this.probability = probability;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader worldReader, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo infoIn1, StructureTemplate.StructureBlockInfo infoIn2, StructurePlaceSettings settings) {
        if (infoIn2.f_74676_.m_60734_() == this.inputBlock) {
            BlockPos worldPos = infoIn2.f_74675_;
            WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
            random.setSeed(worldPos.m_121878_() * (long)worldPos.m_123342_());
            if (random.nextFloat() < this.probability) {
                if (this.outputBlock.isPresent()) {
                    BlockState newBlockState = this.outputBlock.get().m_49966_();
                    for (Property property : infoIn2.f_74676_.m_61147_()) {
                        if (!newBlockState.m_61138_(property)) continue;
                        newBlockState = this.getStateWithProperty(newBlockState, infoIn2.f_74676_, property);
                    }
                    return new StructureTemplate.StructureBlockInfo(infoIn2.f_74675_, newBlockState, infoIn2.f_74677_);
                }
                if (!this.outputBlocks.isEmpty()) {
                    BlockState newBlockState = this.outputBlocks.get(random.nextInt(this.outputBlocks.size())).m_49966_();
                    for (Property property : infoIn2.f_74676_.m_61147_()) {
                        if (!newBlockState.m_61138_(property)) continue;
                        newBlockState = this.getStateWithProperty(newBlockState, infoIn2.f_74676_, property);
                    }
                    return new StructureTemplate.StructureBlockInfo(infoIn2.f_74675_, newBlockState, infoIn2.f_74677_);
                }
                RepurposedStructures.LOGGER.warn("Repurposed Structures: repurposed_structures:random_replace_with_properties_processor in a processor file has no replacement block of any kind.");
            }
        }
        return infoIn2;
    }

    private <T extends Comparable<T>> BlockState getStateWithProperty(BlockState state, BlockState stateToCopy, Property<T> property) {
        return (BlockState)state.m_61124_(property, stateToCopy.m_61143_(property));
    }

    protected StructureProcessorType<?> m_6953_() {
        return RSProcessors.RANDOM_REPLACE_WITH_PROPERTIES_PROCESSOR;
    }
}

