/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.utils.Mutable;
import com.telepathicgrunt.repurposedstructures.world.structures.AdvancedJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.codeconfigs.AdvancedDistanceJigsawStructureCodeConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AdvancedDistanceJigsawStructure
extends AdvancedJigsawStructure {
    public AdvancedDistanceJigsawStructure(Predicate<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>> locationCheckPredicate, Function<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>, Optional<PieceGenerator<NoneFeatureConfiguration>>> pieceCreationPredicate) {
        super(locationCheckPredicate, pieceCreationPredicate);
    }

    public static AdvancedDistanceJigsawStructure create(AdvancedDistanceJigsawStructureCodeConfig advancedDistanceJigsawStructureCodeConfig) {
        Mutable<AdvancedDistanceJigsawStructure> box = new Mutable<AdvancedDistanceJigsawStructure>();
        AdvancedDistanceJigsawStructure finalInstance = new AdvancedDistanceJigsawStructure(context -> ((AdvancedDistanceJigsawStructure)((Object)((Object)box.getValue()))).isFeatureChunk((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context, advancedDistanceJigsawStructureCodeConfig), context -> ((AdvancedDistanceJigsawStructure)((Object)((Object)box.getValue()))).generatePieces((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context, advancedDistanceJigsawStructureCodeConfig));
        box.setValue(finalInstance);
        return finalInstance;
    }

    protected boolean isFeatureChunk(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, AdvancedDistanceJigsawStructureCodeConfig config) {
        int zBlockPos;
        int radius = config.distanceFromWorldOrigin;
        int xBlockPos = context.f_197355_().m_45604_();
        return xBlockPos * xBlockPos + (zBlockPos = context.f_197355_().m_45605_()) * zBlockPos > radius * radius;
    }

    public Optional<PieceGenerator<NoneFeatureConfiguration>> generatePieces(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, AdvancedDistanceJigsawStructureCodeConfig config) {
        int bottomClipOff;
        int topClipOff;
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos(context.f_197355_().m_45604_(), 0, context.f_197355_().m_45605_());
        if ((Integer)config.maxY.get() - (Integer)config.minY.get() <= 0) {
            RepurposedStructures.LOGGER.error("MinY should always be less than MaxY or else a crash will occur or no pieces will spawn. Problematic structure is:" + Registry.f_122841_.m_7981_((Object)this));
        }
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
        int structureStartHeight = random.nextInt((Integer)config.maxY.get() - (Integer)config.minY.get()) + (Integer)config.minY.get();
        blockpos.m_122175_(Direction.UP, structureStartHeight);
        if (config.verticalRange == null) {
            topClipOff = config.clipOutOfBoundsPieces ? (Integer)config.maxY.get() + 5 : Integer.MAX_VALUE;
            bottomClipOff = config.clipOutOfBoundsPieces ? (Integer)config.minY.get() - 5 : Integer.MIN_VALUE;
        } else {
            topClipOff = structureStartHeight + (Integer)config.verticalRange.get();
            bottomClipOff = structureStartHeight - (Integer)config.verticalRange.get();
        }
        ResourceLocation structureID = ForgeRegistries.STRUCTURE_FEATURES.getKey((IForgeRegistryEntry)this);
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new JigsawConfiguration(() -> (StructureTemplatePool)context.f_197360_().m_175515_(Registry.f_122884_).m_7745_(config.startPool), ((Integer)config.structureSize.get()).intValue()), structureID, (BlockPos)blockpos, false, false, topClipOff, bottomClipOff, (structurePiecesBuilder, pieces) -> {
            Optional<PoolElementStructurePiece> lowestPiece = pieces.stream().min(Comparator.comparingInt(p -> p.m_73547_().m_162396_()));
            int minY = lowestPiece.map(poolElementStructurePiece -> poolElementStructurePiece.m_73547_().m_162396_()).orElseGet(() -> ((BlockPos.MutableBlockPos)blockpos).m_123342_());
            if (minY < context.f_197352_().m_142062_()) {
                int newOffset = context.f_197352_().m_142062_() - minY;
                for (StructurePiece piece : pieces) {
                    piece.m_6324_(0, newOffset, 0);
                }
            }
        });
    }
}

