/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.utils.Mutable;
import com.telepathicgrunt.repurposedstructures.world.structures.GenericJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.codeconfigs.GenericJigsawStructureCodeConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class LandBasedEndStructure
extends GenericJigsawStructure {
    public LandBasedEndStructure(Predicate<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>> locationCheckPredicate, Function<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>, Optional<PieceGenerator<NoneFeatureConfiguration>>> pieceCreationPredicate) {
        super(locationCheckPredicate, pieceCreationPredicate);
    }

    public static LandBasedEndStructure create(GenericJigsawStructureCodeConfig genericJigsawStructureCodeConfig) {
        Mutable<LandBasedEndStructure> box = new Mutable<LandBasedEndStructure>();
        LandBasedEndStructure finalInstance = new LandBasedEndStructure(context -> ((LandBasedEndStructure)((Object)((Object)box.getValue()))).isFeatureChunk((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context, genericJigsawStructureCodeConfig), context -> ((LandBasedEndStructure)((Object)((Object)box.getValue()))).generatePieces((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context, genericJigsawStructureCodeConfig));
        box.setValue(finalInstance);
        return finalInstance;
    }

    @Override
    protected boolean isFeatureChunk(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, GenericJigsawStructureCodeConfig config) {
        return LandBasedEndStructure.getTerrainHeight(context.f_197355_(), context.f_197352_(), context.f_197357_()) >= Math.min(GeneralUtils.getMaxTerrainLimit(context.f_197352_()), 50);
    }

    private static int getTerrainHeight(ChunkPos chunkPos1, ChunkGenerator chunkGenerator, LevelHeightAccessor heightLimitView) {
        int xPos = chunkPos1.f_45578_ << 4;
        int zPos = chunkPos1.f_45579_ << 4;
        int height = chunkGenerator.m_156179_(xPos, zPos, Heightmap.Types.WORLD_SURFACE_WG, heightLimitView);
        BlockPos pos = new BlockPos(xPos, GeneralUtils.getMaxTerrainLimit(chunkGenerator), zPos);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            mutable.m_122190_((Vec3i)pos).m_122175_(direction, 16);
            height = Math.min(height, chunkGenerator.m_156179_(mutable.m_123341_(), mutable.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightLimitView));
        }
        return height;
    }

    @Override
    public Optional<PieceGenerator<NoneFeatureConfiguration>> generatePieces(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, GenericJigsawStructureCodeConfig config) {
        BlockPos blockpos = new BlockPos(context.f_197355_().m_45604_(), config.fixedYSpawn, context.f_197355_().m_45605_());
        ResourceLocation structureID = ForgeRegistries.STRUCTURE_FEATURES.getKey((IForgeRegistryEntry)this);
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new JigsawConfiguration(() -> (StructureTemplatePool)context.f_197360_().m_175515_(Registry.f_122884_).m_7745_(config.startPool), ((Integer)config.structureSize.get()).intValue()), structureID, blockpos, config.useHeightmap, config.useHeightmap, Integer.MAX_VALUE, Integer.MIN_VALUE, (structurePiecesBuilder, pieces) -> {
            GeneralUtils.centerAllPieces(blockpos, pieces);
            ((PoolElementStructurePiece)pieces.get(0)).m_6324_(0, config.centerOffset, 0);
            BoundingBox box = ((PoolElementStructurePiece)pieces.get(0)).m_73547_();
            BlockPos centerPos = new BlockPos((Vec3i)box.m_162394_());
            int radius = (int)Math.sqrt(box.m_71053_().m_123341_() * box.m_71053_().m_123341_() + box.m_71053_().m_123343_() * box.m_71053_().m_123343_()) / 2;
            ArrayList<Integer> landHeights = new ArrayList<Integer>();
            for (int xOffset = -radius; xOffset <= radius; xOffset += radius / 2) {
                for (int zOffset = -radius; zOffset <= radius; zOffset += radius / 2) {
                    int landHeight = context.f_197352_().m_156179_(centerPos.m_123341_() + xOffset, centerPos.m_123343_() + zOffset, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
                    landHeights.add(landHeight);
                }
            }
            int avgHeight = (int)Math.max(landHeights.stream().mapToInt(Integer::intValue).average().orElse(0.0), 50.0);
            int parentHeight = ((PoolElementStructurePiece)pieces.get(0)).m_73547_().m_162396_();
            int offsetAmount = avgHeight - parentHeight + config.centerOffset;
            pieces.forEach(child -> child.m_6324_(0, offsetAmount, 0));
            GeneralUtils.centerAllPieces(centerPos, pieces);
        });
    }
}

