/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.utils.Mutable;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.codeconfigs.StartPoolOnlyCodeConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ShipwreckEndStructure
extends AbstractBaseStructure<NoneFeatureConfiguration> {
    public ShipwreckEndStructure(Predicate<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>> locationCheckPredicate, Function<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>, Optional<PieceGenerator<NoneFeatureConfiguration>>> pieceCreationPredicate) {
        super(NoneFeatureConfiguration.f_67815_, locationCheckPredicate, pieceCreationPredicate);
    }

    public static ShipwreckEndStructure create(StartPoolOnlyCodeConfig startPoolOnlyCodeConfig) {
        Mutable<ShipwreckEndStructure> box = new Mutable<ShipwreckEndStructure>();
        ShipwreckEndStructure finalInstance = new ShipwreckEndStructure(context -> ((ShipwreckEndStructure)((Object)((Object)box.getValue()))).isFeatureChunk((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context, startPoolOnlyCodeConfig), context -> ((ShipwreckEndStructure)((Object)((Object)box.getValue()))).generatePieces((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context, startPoolOnlyCodeConfig));
        box.setValue(finalInstance);
        return finalInstance;
    }

    protected boolean isFeatureChunk(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, StartPoolOnlyCodeConfig config) {
        return ShipwreckEndStructure.getGenerationHeight(context.f_197355_(), context.f_197352_(), context.f_197357_()) >= Math.min(GeneralUtils.getMaxTerrainLimit(context.f_197352_()), 20);
    }

    private static int getGenerationHeight(ChunkPos chunkPos1, ChunkGenerator chunkGenerator, LevelHeightAccessor heightLimitView) {
        int x = chunkPos1.f_45578_ * 16;
        int z = chunkPos1.f_45579_ * 16;
        int heightmap1 = chunkGenerator.m_156179_(x + 5, z, Heightmap.Types.WORLD_SURFACE_WG, heightLimitView);
        int heightmap2 = chunkGenerator.m_156179_(x, z + 5, Heightmap.Types.WORLD_SURFACE_WG, heightLimitView);
        int heightmap3 = chunkGenerator.m_156179_(x - 5, z, Heightmap.Types.WORLD_SURFACE_WG, heightLimitView);
        int heightmap4 = chunkGenerator.m_156179_(x, z - 5, Heightmap.Types.WORLD_SURFACE_WG, heightLimitView);
        return Math.min(Math.min(heightmap1, heightmap2), Math.min(heightmap3, heightmap4));
    }

    public Optional<PieceGenerator<NoneFeatureConfiguration>> generatePieces(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, StartPoolOnlyCodeConfig config) {
        BlockPos blockpos = new BlockPos(context.f_197355_().m_45604_(), 64, context.f_197355_().m_45605_());
        ResourceLocation structureID = ForgeRegistries.STRUCTURE_FEATURES.getKey((IForgeRegistryEntry)this);
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new JigsawConfiguration(() -> (StructureTemplatePool)context.f_197360_().m_175515_(Registry.f_122884_).m_7745_(config.startPool), 5), structureID, blockpos, false, false, Integer.MAX_VALUE, Integer.MIN_VALUE, (structurePiecesBuilder, pieces) -> {
            GeneralUtils.centerAllPieces(blockpos, pieces);
            WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
            random.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
            BlockPos blockPos = new BlockPos((Vec3i)((PoolElementStructurePiece)pieces.get(0)).m_73547_().m_162394_());
            int highestLandPos = context.f_197352_().m_142647_(blockPos.m_123341_(), blockPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
            highestLandPos = Math.max(30, highestLandPos);
            structurePiecesBuilder.m_192792_((Random)random, highestLandPos - 5, highestLandPos - 3);
        });
    }
}

