/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.utils.Mutable;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.codeconfigs.ShipwreckNetherCodeConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ShipwreckNetherStructure
extends AbstractBaseStructure<NoneFeatureConfiguration> {
    public ShipwreckNetherStructure(Predicate<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>> locationCheckPredicate, Function<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>, Optional<PieceGenerator<NoneFeatureConfiguration>>> pieceCreationPredicate) {
        super(NoneFeatureConfiguration.f_67815_, locationCheckPredicate, pieceCreationPredicate);
    }

    public static ShipwreckNetherStructure create(ShipwreckNetherCodeConfig shipwreckNetherCodeConfig) {
        Mutable<ShipwreckNetherStructure> box = new Mutable<ShipwreckNetherStructure>();
        ShipwreckNetherStructure finalInstance = new ShipwreckNetherStructure(context -> ((ShipwreckNetherStructure)((Object)((Object)box.getValue()))).isFeatureChunk((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context, shipwreckNetherCodeConfig), context -> ((ShipwreckNetherStructure)((Object)((Object)box.getValue()))).generatePieces((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context, shipwreckNetherCodeConfig));
        box.setValue(finalInstance);
        return finalInstance;
    }

    protected boolean isFeatureChunk(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, ShipwreckNetherCodeConfig config) {
        ChunkPos chunkPos = context.f_197355_();
        BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), context.f_197352_().m_6337_() + 1, chunkPos.m_45605_());
        int checkRadius = 16;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int xOffset = -checkRadius; xOffset <= checkRadius; xOffset += 8) {
            for (int zOffset = -checkRadius; zOffset <= checkRadius; zOffset += 8) {
                NoiseColumn blockView = context.f_197352_().m_141914_(xOffset + blockPos.m_123341_(), zOffset + blockPos.m_123343_(), context.f_197357_());
                for (int yOffset = 0; yOffset <= 30; yOffset += 5) {
                    mutable.m_122190_((Vec3i)blockPos).m_122184_(xOffset, yOffset, zOffset);
                    if (blockView.m_183556_(mutable.m_123342_()).m_60795_()) continue;
                    return false;
                }
            }
        }
        int structureCheckRadius = 3;
        for (int curChunkX = chunkPos.f_45578_ - structureCheckRadius; curChunkX <= chunkPos.f_45578_ + structureCheckRadius; ++curChunkX) {
            for (int curChunkZ = chunkPos.f_45579_ - structureCheckRadius; curChunkZ <= chunkPos.f_45579_ + structureCheckRadius; ++curChunkZ) {
                for (StructureFeature<?> structureFeature : RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)RSStructureTagMap.STRUCTURE_TAGS.SHIPWRECK_AVOID_NETHER_STRUCTURE)) {
                    StructureFeatureConfiguration structureConfig;
                    if (structureFeature == this || (structureConfig = context.f_197352_().m_62205_().m_64593_(structureFeature)) == null || structureConfig.m_68171_() <= 8) continue;
                    ChunkPos chunkPos2 = structureFeature.m_191122_(structureConfig, context.f_197354_(), curChunkX, curChunkZ);
                    if (curChunkX != chunkPos2.f_45578_ || curChunkZ != chunkPos2.f_45579_) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Optional<PieceGenerator<NoneFeatureConfiguration>> generatePieces(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, ShipwreckNetherCodeConfig config) {
        BlockPos blockpos = new BlockPos(context.f_197355_().m_45604_(), context.f_197352_().m_6337_() + config.sealevelOffset, context.f_197355_().m_45605_());
        ResourceLocation structureID = ForgeRegistries.STRUCTURE_FEATURES.getKey((IForgeRegistryEntry)this);
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new JigsawConfiguration(() -> (StructureTemplatePool)context.f_197360_().m_175515_(Registry.f_122884_).m_7745_(config.startPool), 6), structureID, blockpos, false, false, Integer.MAX_VALUE, Integer.MIN_VALUE, (structurePiecesBuilder, pieces) -> GeneralUtils.centerAllPieces(blockpos, pieces));
    }
}

