/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.apache.commons.io.FileUtils;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.graphics.CursorBox;
import xaero.common.gui.GuiTransfer;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.GuiWorldTpCommand;
import xaero.common.gui.MyBigButton;
import xaero.common.gui.MyTinyButton;
import xaero.common.gui.ScreenBase;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointWorldRootContainer;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.settings.ModSettings;

public class GuiWaypointsOptions
extends ScreenBase {
    private XaeroMinimapSession minimapSession;
    private WaypointsManager waypointsManager;
    private Button automaticButton;
    private Button subAutomaticButton;
    private Button deleteButton;
    private Button subDeleteButton;
    private Button connectButton;
    private boolean buttonTest;
    private WaypointWorld waypointWorld;
    private WaypointWorld automaticWaypointWorld;
    private WaypointWorldRootContainer rootContainer;
    private boolean teleportationOptionShown;
    private boolean selectedWorldIsConnected;
    public CursorBox mwTooltip = new CursorBox("gui.xaero_use_multiworld_tooltip");
    public CursorBox teleportationTooltip = new CursorBox("gui.xaero_teleportation_tooltip", "\u00a7c");
    public CursorBox connectionTooltip = new CursorBox("gui.xaero_world_connection_tooltip");

    public GuiWaypointsOptions(IXaeroMinimap modMain, XaeroMinimapSession minimapSession, Screen parent, Screen escapeScreen, WaypointWorld waypointWorld, String frozenAutoContainerID, String frozenAutoWorldID) {
        super(modMain, parent, escapeScreen, (Component)new TranslatableComponent("gui.xaero_options"));
        this.minimapSession = minimapSession;
        this.waypointsManager = minimapSession.getWaypointsManager();
        this.waypointWorld = waypointWorld;
        this.rootContainer = waypointWorld.getContainer().getRootContainer();
        this.automaticWaypointWorld = this.waypointsManager.getWorld(frozenAutoContainerID, frozenAutoWorldID);
        this.teleportationOptionShown = this.rootContainer.isTeleportationEnabled();
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.parent.m_6574_(this.f_96541_, this.f_96543_, this.f_96544_);
        this.selectedWorldIsConnected = this.rootContainer.getSubWorldConnections().isConnected(this.automaticWaypointWorld, this.waypointWorld);
        this.m_142416_((GuiEventListener)new MyTinyButton(this.f_96543_ / 2 - 203, 32, (Component)new TranslatableComponent("gui.xaero_close", new Object[0]), b -> this.actionPerformed(b, 5)));
        this.m_142416_((GuiEventListener)new MyBigButton(6, this.f_96543_ / 2 - 203, 57, (Component)new TranslatableComponent("gui.xaero_transfer", new Object[0]), b -> this.actionPerformed(b, 6)));
        this.automaticButton = new MyBigButton(7, this.f_96543_ / 2 - 203, 82, (Component)new TranslatableComponent("gui.xaero_make_automatic", new Object[0]), b -> this.actionPerformed(b, 7));
        this.m_142416_((GuiEventListener)this.automaticButton);
        this.subAutomaticButton = new MyBigButton(8, this.f_96543_ / 2 - 203, 107, (Component)new TranslatableComponent("gui.xaero_make_multi_automatic", new Object[0]), b -> this.actionPerformed(b, 8));
        this.m_142416_((GuiEventListener)this.subAutomaticButton);
        this.deleteButton = new MyBigButton(9, this.f_96543_ / 2 - 203, 132, (Component)new TranslatableComponent("gui.xaero_delete_world", new Object[0]), b -> this.actionPerformed(b, 9));
        this.m_142416_((GuiEventListener)this.deleteButton);
        this.subDeleteButton = new MyBigButton(10, this.f_96543_ / 2 - 203, 157, (Component)new TranslatableComponent("gui.xaero_delete_multi_world", new Object[0]), b -> this.actionPerformed(b, 10));
        this.m_142416_((GuiEventListener)this.subDeleteButton);
        this.m_142416_((GuiEventListener)new MyBigButton(200, this.f_96543_ / 2 + 3, 57, (Component)new TextComponent(this.getConfigButtonName(0)), b -> this.onConfigButtonClick((MyBigButton)b)));
        MyBigButton teleportationEnabledButton = (MyBigButton)this.m_142416_((GuiEventListener)new MyBigButton(201, this.f_96543_ / 2 + 3, 82, (Component)new TextComponent(this.getConfigButtonName(1)), b -> this.onConfigButtonClick((MyBigButton)b)));
        teleportationEnabledButton.f_93623_ = this.teleportationOptionShown;
        this.m_142416_((GuiEventListener)new MyBigButton(13, this.f_96543_ / 2 + 3, 107, (Component)new TranslatableComponent("gui.xaero_world_teleport_command"), b -> this.actionPerformed(b, 13)));
        this.connectButton = new MyBigButton(14, this.f_96543_ / 2 + 3, 132, (Component)new TextComponent(this.getConfigButtonName(4)), b -> this.actionPerformed(b, 14));
        this.m_142416_((GuiEventListener)this.connectButton);
        this.connectButton.f_93623_ = this.waypointsManager.isMultiplayer(this.rootContainer.getKey()) && this.waypointWorld.getContainer() != this.automaticWaypointWorld.getContainer() && this.rootContainer == this.automaticWaypointWorld.getContainer().getRootContainer();
        this.m_142416_((GuiEventListener)new MyBigButton(202, this.f_96543_ / 2 + 3, 182, (Component)new TextComponent(this.getConfigButtonName(2)), b -> this.onConfigButtonClick((MyBigButton)b)));
        this.m_142416_((GuiEventListener)new MyBigButton(203, this.f_96543_ / 2 + 3, 207, (Component)new TextComponent(this.getConfigButtonName(3)), b -> this.onConfigButtonClick((MyBigButton)b)));
    }

    private String getConfigButtonName(int buttonId) {
        switch (buttonId) {
            case 0: {
                return I18n.m_118938_((String)"gui.xaero_use_multiworld", (Object[])new Object[0]) + ": " + ModSettings.getTranslation(this.rootContainer.isUsingMultiworldDetection());
            }
            case 1: {
                return I18n.m_118938_((String)"gui.xaero_teleportation", (Object[])new Object[0]) + ": " + ModSettings.getTranslation(this.rootContainer.isTeleportationEnabled());
            }
            case 2: {
                return I18n.m_118938_((String)"gui.xaero_sort", (Object[])new Object[0]) + ": " + I18n.m_118938_((String)this.rootContainer.getSortType().optionName, (Object[])new Object[0]);
            }
            case 3: {
                return I18n.m_118938_((String)"gui.xaero_sort_reversed", (Object[])new Object[0]) + ": " + ModSettings.getTranslation(this.rootContainer.isSortReversed());
            }
            case 4: {
                return this.selectedWorldIsConnected ? I18n.m_118938_((String)"gui.xaero_disconnect_from_auto", (Object[])new Object[0]) : I18n.m_118938_((String)"gui.xaero_connect_with_auto", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private void onConfigButtonClick(MyBigButton button) {
        this.buttonTest = true;
        WaypointWorldRootContainer wc = this.rootContainer;
        switch (button.getId() - 200) {
            case 0: {
                wc.setUsingMultiworldDetection(!this.rootContainer.isUsingMultiworldDetection());
                wc.setDefaultMultiworldId(null);
                break;
            }
            case 1: {
                wc.setTeleportationEnabled(!wc.isTeleportationEnabled());
                break;
            }
            case 2: {
                this.rootContainer.toggleSortType();
                this.parent.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
                break;
            }
            case 3: {
                this.rootContainer.toggleSortReversed();
                this.parent.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            }
        }
        wc.saveConfig();
        button.m_93666_((Component)new TextComponent(this.getConfigButtonName(button.getId() - 200)));
    }

    public boolean m_6375_(double par1, double par2, int par3) {
        this.buttonTest = false;
        boolean toReturn = super.m_6375_(par1, par2, par3);
        if (!this.buttonTest) {
            this.goBack();
        }
        return toReturn;
    }

    protected void actionPerformed(Button p_146284_1_, int id) {
        this.buttonTest = true;
        if (p_146284_1_.f_93623_) {
            switch (id) {
                case 5: {
                    this.goBack();
                    break;
                }
                case 6: {
                    this.f_96541_.m_91152_((Screen)new GuiTransfer(this.modMain, this.minimapSession, this.parent, this.escape));
                    break;
                }
                case 7: {
                    this.f_96541_.m_91152_((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (Component)new TranslatableComponent("gui.xaero_make_automatic_msg1"), (Component)new TranslatableComponent("gui.xaero_make_automatic_msg2")));
                    break;
                }
                case 8: {
                    this.f_96541_.m_91152_((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (Component)new TranslatableComponent("gui.xaero_make_multi_automatic_msg1"), (Component)new TranslatableComponent("gui.xaero_make_multi_automatic_msg2")));
                    break;
                }
                case 9: {
                    this.f_96541_.m_91152_((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (Component)new TranslatableComponent("gui.xaero_delete_world_msg1"), (Component)new TranslatableComponent("gui.xaero_delete_world_msg2")));
                    break;
                }
                case 10: {
                    this.f_96541_.m_91152_((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (Component)new TranslatableComponent("gui.xaero_delete_multi_world_msg1"), (Component)new TranslatableComponent("gui.xaero_delete_multi_world_msg2")));
                    break;
                }
                case 11: {
                    this.f_96541_.m_91152_((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (Component)new TranslatableComponent("gui.xaero_multiply_msg1"), (Component)new TranslatableComponent("gui.xaero_multiply_msg2")));
                    break;
                }
                case 12: {
                    this.f_96541_.m_91152_((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (Component)new TranslatableComponent("gui.xaero_multiply_msg1"), (Component)new TranslatableComponent("gui.xaero_divide_msg2")));
                    break;
                }
                case 13: {
                    this.f_96541_.m_91152_((Screen)new GuiWorldTpCommand(this.modMain, (Screen)this, this.escape, this.waypointWorld));
                    break;
                }
                case 14: {
                    WaypointWorldContainer autoContainer = this.automaticWaypointWorld.getContainer();
                    WaypointWorldContainer selectedContainer = this.waypointWorld.getContainer();
                    String autoWorldName = autoContainer.getFullName(this.automaticWaypointWorld.getId(), autoContainer.getSubName()) + " (auto)";
                    String selectedWorldName = selectedContainer.getFullName(this.waypointWorld.getId(), selectedContainer.getSubName());
                    String connectionDisplayString = autoWorldName + "   \u00a7e<=>\u00a7r   " + selectedWorldName;
                    if (this.selectedWorldIsConnected) {
                        this.f_96541_.m_91152_((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (Component)new TranslatableComponent("gui.xaero_disconnect_from_auto_msg"), (Component)new TextComponent(connectionDisplayString)));
                        break;
                    }
                    this.f_96541_.m_91152_((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (Component)new TranslatableComponent("gui.xaero_connect_with_auto_msg"), (Component)new TextComponent(connectionDisplayString)));
                }
            }
        }
    }

    public void confirmResult(boolean result, int id) {
        block30: {
            block29: {
                boolean differentRoot = this.isDifferentRootContainer();
                boolean differentSub = this.isDifferentSubWorld(differentRoot);
                boolean exitOptions = true;
                if (!result) break block29;
                switch (id) {
                    case 7: {
                        if (!differentRoot) break;
                        WaypointWorldRootContainer selected = this.rootContainer;
                        WaypointWorldRootContainer auto = (WaypointWorldRootContainer)this.waypointsManager.getWaypointMap().get(this.waypointsManager.getAutoRootContainerID());
                        if (selected == null || auto == null) break;
                        String buKey = selected.getKey();
                        this.waypointsManager.getWaypointMap().put(auto.getKey(), selected);
                        this.waypointsManager.getWaypointMap().put(buKey, auto);
                        selected.setKey(auto.getKey());
                        auto.setKey(buKey);
                        selected.updateConnectionsField(this.minimapSession);
                        auto.updateConnectionsField(this.minimapSession);
                        Path selectedPath = selected.getDirectory().toPath();
                        Path autoPath = auto.getDirectory().toPath();
                        Path tempFolder = this.modMain.getWaypointsFolder().toPath().resolve("temp_to_add");
                        try {
                            Files.createDirectories(tempFolder, new FileAttribute[0]);
                            Path selectedTemp = tempFolder.resolve(selectedPath.getFileName());
                            if (Files.exists(selectedPath, new LinkOption[0])) {
                                Files.move(selectedPath, selectedTemp, new CopyOption[0]);
                            }
                            if (Files.exists(autoPath, new LinkOption[0])) {
                                Files.move(autoPath, selectedPath, new CopyOption[0]);
                            }
                            if (Files.exists(selectedTemp, new LinkOption[0])) {
                                Files.move(selectedTemp, autoPath, new CopyOption[0]);
                            }
                            Files.deleteIfExists(tempFolder);
                        }
                        catch (Throwable e) {
                            this.modMain.getInterfaces().getMinimapInterface().setCrashedWith(e);
                        }
                        selected.loadConfig();
                        auto.loadConfig();
                        this.waypointsManager.setCustomWorldID(null);
                        this.waypointsManager.setCustomContainerID(null);
                        this.waypointsManager.updateWaypoints();
                        break;
                    }
                    case 8: {
                        if (!differentSub) break;
                        WaypointWorld autoWorld = this.automaticWaypointWorld;
                        WaypointWorld selectedWorld = this.waypointWorld;
                        try {
                            Path autoFile = this.modMain.getSettings().getWaypointsFile(autoWorld).toPath();
                            Path selectedFile = this.modMain.getSettings().getWaypointsFile(selectedWorld).toPath();
                            Path autoTempFile = autoFile.getParent().resolve("temp_to_add").resolve(autoFile.getFileName());
                            Files.createDirectories(autoTempFile.getParent(), new FileAttribute[0]);
                            if (!Files.exists(autoFile, new LinkOption[0])) {
                                Files.createFile(autoFile, new FileAttribute[0]);
                            }
                            Files.move(autoFile, autoTempFile, new CopyOption[0]);
                            if (!Files.exists(selectedFile, new LinkOption[0])) {
                                Files.createFile(selectedFile, new FileAttribute[0]);
                            }
                            Files.move(selectedFile, autoFile, new CopyOption[0]);
                            if (Files.exists(autoTempFile, new LinkOption[0])) {
                                Files.move(autoTempFile, selectedFile, new CopyOption[0]);
                            }
                            Files.deleteIfExists(autoTempFile.getParent());
                        }
                        catch (Throwable e) {
                            this.modMain.getInterfaces().getMinimapInterface().setCrashedWith(e);
                            break;
                        }
                        WaypointWorldContainer autoWc = autoWorld.getContainer();
                        WaypointWorldContainer selectedWc = selectedWorld.getContainer();
                        autoWorld.setContainer(selectedWc);
                        selectedWorld.setContainer(autoWc);
                        selectedWc.worlds.put(selectedWorld.getId(), autoWorld);
                        autoWc.worlds.put(autoWorld.getId(), selectedWorld);
                        String buSelected = selectedWorld.getId();
                        selectedWorld.setId(autoWorld.getId());
                        autoWorld.setId(buSelected);
                        this.rootContainer.getSubWorldConnections().swapConnections(autoWorld, selectedWorld);
                        this.rootContainer.saveConfig();
                        this.waypointsManager.setCustomWorldID(null);
                        this.waypointsManager.setCustomContainerID(null);
                        this.waypointsManager.updateWaypoints();
                        break;
                    }
                    case 9: {
                        if (!differentRoot) break;
                        String selectedRootContainerId = this.rootContainer.getKey();
                        try {
                            File directory = this.modMain.getWaypointsFolder().toPath().resolve(selectedRootContainerId).toFile();
                            if (directory.exists()) {
                                FileUtils.deleteDirectory((File)directory);
                            }
                        }
                        catch (Throwable e) {
                            this.modMain.getInterfaces().getMinimapInterface().setCrashedWith(e);
                            break;
                        }
                        this.waypointsManager.getWaypointMap().remove(selectedRootContainerId);
                        this.waypointsManager.setCustomWorldID(null);
                        this.waypointsManager.setCustomContainerID(null);
                        this.waypointsManager.updateWaypoints();
                        break;
                    }
                    case 10: {
                        if (!differentSub) break;
                        WaypointWorld selectedWorld = this.waypointWorld;
                        try {
                            Files.deleteIfExists(this.modMain.getSettings().getWaypointsFile(selectedWorld).toPath());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        selectedWorld.getContainer().worlds.remove(selectedWorld.getId());
                        selectedWorld.getContainer().removeName(selectedWorld.getId());
                        this.waypointsManager.setCustomWorldID(null);
                        this.waypointsManager.setCustomContainerID(null);
                        this.waypointsManager.updateWaypoints();
                        break;
                    }
                    case 11: {
                        this.multiplyWaypoints(this.waypointWorld, 8.0);
                        break;
                    }
                    case 12: {
                        this.multiplyWaypoints(this.waypointWorld, 0.125);
                        break;
                    }
                    case 14: {
                        if (!this.selectedWorldIsConnected) {
                            this.rootContainer.getSubWorldConnections().addConnection(this.automaticWaypointWorld, this.waypointWorld);
                        } else {
                            this.rootContainer.getSubWorldConnections().removeConnection(this.automaticWaypointWorld, this.waypointWorld);
                        }
                        this.rootContainer.saveConfig();
                    }
                }
                if (exitOptions) {
                    if (this.parent instanceof GuiWaypoints) {
                        this.f_96541_.m_91152_((Screen)new GuiWaypoints(this.modMain, this.minimapSession, ((GuiWaypoints)this.parent).parent, this.escape));
                    } else {
                        this.goBack();
                    }
                }
                break block30;
            }
            this.f_96541_.m_91152_((Screen)this);
        }
    }

    private void multiplyWaypoints(WaypointWorld world, double factor) {
        HashMap<String, WaypointSet> sets = world.getSets();
        Iterator<WaypointSet> iter = sets.values().iterator();
        while (iter.hasNext()) {
            ArrayList<Waypoint> wpList = iter.next().getList();
            for (int i = 0; i < wpList.size(); ++i) {
                Waypoint wp = wpList.get(i);
                wp.setX((int)Math.floor((double)wp.getX() * factor));
                wp.setZ((int)Math.floor((double)wp.getZ() * factor));
            }
        }
        try {
            this.modMain.getSettings().saveWaypoints(world);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isDifferentRootContainer() {
        return this.waypointsManager.getAutoRootContainerID() != null && !this.waypointsManager.getAutoRootContainerID().equals(this.rootContainer.getKey());
    }

    private boolean isDifferentSubWorld(boolean differentRoot) {
        return !differentRoot && this.waypointWorld != this.automaticWaypointWorld;
    }

    public void m_6305_(PoseStack matrixStack, int par1, int par2, float par3) {
        this.automaticButton.f_93623_ = this.deleteButton.f_93623_ = this.isDifferentRootContainer();
        this.subAutomaticButton.f_93623_ = this.subDeleteButton.f_93623_ = this.isDifferentSubWorld(this.automaticButton.f_93623_);
        this.parent.m_6305_(matrixStack, 0, 0, par3);
        RenderSystem.m_69482_();
        RenderSystem.m_69456_((int)519);
        this.m_7333_(matrixStack);
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_69465_();
        super.m_6305_(matrixStack, par1, par2, par3);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 0.1);
        for (GuiEventListener el : this.m_6702_()) {
            AbstractWidget w;
            if (!(el instanceof AbstractWidget) || !((w = (AbstractWidget)el) instanceof MyBigButton)) continue;
            MyBigButton b = (MyBigButton)w;
            if (par1 < b.f_93620_ || par2 < b.f_93621_ || par1 >= b.f_93620_ + b.m_5711_() || par2 >= b.f_93621_ + 20) continue;
            if (b.getId() >= 200) {
                switch (b.getId() - 200) {
                    case 0: {
                        this.mwTooltip.drawBox(matrixStack, par1, par2, this.f_96543_, this.f_96544_);
                        break;
                    }
                    case 1: {
                        this.teleportationTooltip.drawBox(matrixStack, par1, par2, this.f_96543_, this.f_96544_);
                    }
                }
                continue;
            }
            if (b.getId() != 14 || !b.f_93623_) continue;
            this.connectionTooltip.drawBox(matrixStack, par1, par2, this.f_96543_, this.f_96544_);
        }
        matrixStack.m_85849_();
    }
}

