/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render.box;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Vector3d;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.client.render.face.FaceRenderType;
import team.creative.creativecore.client.render.face.IFaceRenderType;
import team.creative.creativecore.common.mod.OptifineHelper;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.creativecore.common.util.math.geo.NormalPlane;
import team.creative.creativecore.common.util.math.geo.Ray2d;
import team.creative.creativecore.common.util.math.geo.VectorFan;
import team.creative.creativecore.common.util.math.vec.Vec3f;
import team.creative.creativecore.common.util.mc.ColorUtils;

@OnlyIn(value=Dist.CLIENT)
public class RenderBox
extends AlignedBox {
    private static final VectorFan DOWN = new VectorFanSimple(new Vec3f[]{new Vec3f(0.0f, 0.0f, 1.0f), new Vec3f(0.0f, 0.0f, 0.0f), new Vec3f(1.0f, 0.0f, 0.0f), new Vec3f(1.0f, 0.0f, 1.0f)});
    private static final VectorFan UP = new VectorFanSimple(new Vec3f[]{new Vec3f(0.0f, 1.0f, 0.0f), new Vec3f(0.0f, 1.0f, 1.0f), new Vec3f(1.0f, 1.0f, 1.0f), new Vec3f(1.0f, 1.0f, 0.0f)});
    private static final VectorFan NORTH = new VectorFanSimple(new Vec3f[]{new Vec3f(1.0f, 1.0f, 0.0f), new Vec3f(1.0f, 0.0f, 0.0f), new Vec3f(0.0f, 0.0f, 0.0f), new Vec3f(0.0f, 1.0f, 0.0f)});
    private static final VectorFan SOUTH = new VectorFanSimple(new Vec3f[]{new Vec3f(0.0f, 1.0f, 1.0f), new Vec3f(0.0f, 0.0f, 1.0f), new Vec3f(1.0f, 0.0f, 1.0f), new Vec3f(1.0f, 1.0f, 1.0f)});
    private static final VectorFan WEST = new VectorFanSimple(new Vec3f[]{new Vec3f(0.0f, 1.0f, 0.0f), new Vec3f(0.0f, 0.0f, 0.0f), new Vec3f(0.0f, 0.0f, 1.0f), new Vec3f(0.0f, 1.0f, 1.0f)});
    private static final VectorFan EAST = new VectorFanSimple(new Vec3f[]{new Vec3f(1.0f, 1.0f, 1.0f), new Vec3f(1.0f, 0.0f, 1.0f), new Vec3f(1.0f, 0.0f, 0.0f), new Vec3f(1.0f, 1.0f, 0.0f)});
    public BlockState state;
    public int color = -1;
    public boolean keepVU = false;
    public boolean allowOverlap = false;
    public boolean doesNeedQuadUpdate = true;
    public boolean needsResorting = false;
    public boolean emissive = false;
    private IFaceRenderType renderEast = FaceRenderType.INSIDE_RENDERED;
    private IFaceRenderType renderWest = FaceRenderType.INSIDE_RENDERED;
    private IFaceRenderType renderUp = FaceRenderType.INSIDE_RENDERED;
    private IFaceRenderType renderDown = FaceRenderType.INSIDE_RENDERED;
    private IFaceRenderType renderSouth = FaceRenderType.INSIDE_RENDERED;
    private IFaceRenderType renderNorth = FaceRenderType.INSIDE_RENDERED;
    private Object quadEast = null;
    private Object quadWest = null;
    private Object quadUp = null;
    private Object quadDown = null;
    private Object quadSouth = null;
    private Object quadNorth = null;
    public Object customData;

    public RenderBox(AlignedBox cube) {
        super(cube);
    }

    public RenderBox(AlignedBox cube, RenderBox box) {
        super(cube);
        this.state = box.state;
        this.color = box.color;
        this.renderEast = box.renderEast;
        this.renderWest = box.renderWest;
        this.renderUp = box.renderUp;
        this.renderDown = box.renderDown;
        this.renderSouth = box.renderSouth;
        this.renderNorth = box.renderNorth;
    }

    public RenderBox(AlignedBox cube, BlockState state) {
        super(cube);
        this.state = state;
    }

    public RenderBox(AlignedBox cube, Block block) {
        this(cube, block.m_49966_());
    }

    public RenderBox(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, BlockState state) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.state = state;
    }

    public RenderBox(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Block block) {
        this(minX, minY, minZ, maxX, maxY, maxZ, block.m_49966_());
    }

    public RenderBox setColor(int color) {
        this.color = color;
        return this;
    }

    public RenderBox setKeepUV(boolean keep) {
        this.keepVU = keep;
        return this;
    }

    public void setQuad(Facing facing, List<BakedQuad> quads) {
        BakedQuad quad = quads == null || quads.isEmpty() ? null : (quads.size() == 1 ? quads.get(0) : quads);
        switch (facing) {
            case DOWN: {
                this.quadDown = quad;
                break;
            }
            case EAST: {
                this.quadEast = quad;
                break;
            }
            case NORTH: {
                this.quadNorth = quad;
                break;
            }
            case SOUTH: {
                this.quadSouth = quad;
                break;
            }
            case UP: {
                this.quadUp = quad;
                break;
            }
            case WEST: {
                this.quadWest = quad;
            }
        }
    }

    public Object getQuad(Facing facing) {
        switch (facing) {
            case DOWN: {
                return this.quadDown;
            }
            case EAST: {
                return this.quadEast;
            }
            case NORTH: {
                return this.quadNorth;
            }
            case SOUTH: {
                return this.quadSouth;
            }
            case UP: {
                return this.quadUp;
            }
            case WEST: {
                return this.quadWest;
            }
        }
        return null;
    }

    public int countQuads() {
        int quads = 0;
        if (this.quadUp != null) {
            quads += this.quadUp instanceof List ? ((List)this.quadUp).size() : 1;
        }
        if (this.quadDown != null) {
            quads += this.quadDown instanceof List ? ((List)this.quadDown).size() : 1;
        }
        if (this.quadEast != null) {
            quads += this.quadEast instanceof List ? ((List)this.quadEast).size() : 1;
        }
        if (this.quadWest != null) {
            quads += this.quadWest instanceof List ? ((List)this.quadWest).size() : 1;
        }
        if (this.quadSouth != null) {
            quads += this.quadSouth instanceof List ? ((List)this.quadSouth).size() : 1;
        }
        if (this.quadNorth != null) {
            quads += this.quadNorth instanceof List ? ((List)this.quadNorth).size() : 1;
        }
        return quads;
    }

    public void setType(Facing facing, IFaceRenderType renderer) {
        switch (facing) {
            case DOWN: {
                this.renderDown = renderer;
                break;
            }
            case EAST: {
                this.renderEast = renderer;
                break;
            }
            case NORTH: {
                this.renderNorth = renderer;
                break;
            }
            case SOUTH: {
                this.renderSouth = renderer;
                break;
            }
            case UP: {
                this.renderUp = renderer;
                break;
            }
            case WEST: {
                this.renderWest = renderer;
            }
        }
    }

    public IFaceRenderType getType(Facing facing) {
        switch (facing) {
            case DOWN: {
                return this.renderDown;
            }
            case EAST: {
                return this.renderEast;
            }
            case NORTH: {
                return this.renderNorth;
            }
            case SOUTH: {
                return this.renderSouth;
            }
            case UP: {
                return this.renderUp;
            }
            case WEST: {
                return this.renderWest;
            }
        }
        return FaceRenderType.INSIDE_RENDERED;
    }

    public boolean renderSide(Facing facing) {
        switch (facing) {
            case DOWN: {
                return this.renderDown.shouldRender();
            }
            case EAST: {
                return this.renderEast.shouldRender();
            }
            case NORTH: {
                return this.renderNorth.shouldRender();
            }
            case SOUTH: {
                return this.renderSouth.shouldRender();
            }
            case UP: {
                return this.renderUp.shouldRender();
            }
            case WEST: {
                return this.renderWest.shouldRender();
            }
        }
        return true;
    }

    public boolean intersectsWithFace(Facing facing, RenderInformationHolder holder, BlockPos offset) {
        switch (facing.axis) {
            case X: {
                return holder.maxY > this.minY - (float)offset.m_123342_() && holder.minY < this.maxY - (float)offset.m_123342_() && holder.maxZ > this.minZ - (float)offset.m_123343_() && holder.minZ < this.maxZ - (float)offset.m_123343_();
            }
            case Y: {
                return holder.maxX > this.minX - (float)offset.m_123341_() && holder.minX < this.maxX - (float)offset.m_123341_() && holder.maxZ > this.minZ - (float)offset.m_123343_() && holder.minZ < this.maxZ - (float)offset.m_123343_();
            }
            case Z: {
                return holder.maxX > this.minX - (float)offset.m_123341_() && holder.minX < this.maxX - (float)offset.m_123341_() && holder.maxY > this.minY - (float)offset.m_123342_() && holder.minY < this.maxY - (float)offset.m_123342_();
            }
        }
        return false;
    }

    protected Object getRenderQuads(Facing facing) {
        if (this.getType(facing).hasCachedFans()) {
            return this.getType(facing).getCachedFans();
        }
        switch (facing) {
            case DOWN: {
                return DOWN;
            }
            case EAST: {
                return EAST;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case UP: {
                return UP;
            }
            case WEST: {
                return WEST;
            }
        }
        return null;
    }

    protected float getOffsetX() {
        return this.minX;
    }

    protected float getOffsetY() {
        return this.minY;
    }

    protected float getOffsetZ() {
        return this.minZ;
    }

    protected float getOverallScale(Facing facing) {
        return this.getType(facing).getScale();
    }

    protected float getScaleX() {
        return this.maxX - this.minX;
    }

    protected float getScaleY() {
        return this.maxY - this.minY;
    }

    protected float getScaleZ() {
        return this.maxZ - this.minZ;
    }

    protected boolean scaleAndOffsetQuads(Facing facing) {
        return true;
    }

    protected boolean onlyScaleOnceNoOffset(Facing facing) {
        return this.getType(facing).hasCachedFans();
    }

    public void deleteQuadCache() {
        this.doesNeedQuadUpdate = true;
        this.quadEast = null;
        this.quadWest = null;
        this.quadUp = null;
        this.quadDown = null;
        this.quadSouth = null;
        this.quadNorth = null;
    }

    protected boolean previewScalingAndOffset() {
        return true;
    }

    public float getPreviewOffX() {
        return this.minX;
    }

    public float getPreviewOffY() {
        return this.minY;
    }

    public float getPreviewOffZ() {
        return this.minZ;
    }

    public float getPreviewScaleX() {
        return this.maxX - this.minX;
    }

    public float getPreviewScaleY() {
        return this.maxY - this.minY;
    }

    public float getPreviewScaleZ() {
        return this.maxZ - this.minZ;
    }

    public void renderPreview(PoseStack matrix, double x, double y, double z, int alpha) {
        int red = ColorUtils.red(this.color);
        int green = ColorUtils.green(this.color);
        int blue = ColorUtils.blue(this.color);
        matrix.m_85836_();
        matrix.m_85837_(x, y, z);
        if (this.previewScalingAndOffset()) {
            for (int i = 0; i < Facing.values().length; ++i) {
                Object renderQuads = this.getRenderQuads(Facing.values()[i]);
                if (renderQuads instanceof List) {
                    for (int j = 0; j < ((List)renderQuads).size(); ++j) {
                        ((VectorFan)((List)renderQuads).get(j)).renderPreview(this.getPreviewOffX(), this.getPreviewOffY(), this.getPreviewOffZ(), this.getPreviewScaleX(), this.getPreviewScaleY(), this.getPreviewScaleZ(), red, green, blue, alpha);
                    }
                    continue;
                }
                if (!(renderQuads instanceof VectorFan)) continue;
                ((VectorFan)renderQuads).renderPreview(this.getPreviewOffX(), this.getPreviewOffY(), this.getPreviewOffZ(), this.getPreviewScaleX(), this.getPreviewScaleY(), this.getPreviewScaleZ(), red, green, blue, alpha);
            }
        } else {
            for (int i = 0; i < Facing.values().length; ++i) {
                Object renderQuads = this.getRenderQuads(Facing.values()[i]);
                if (renderQuads instanceof List) {
                    for (int j = 0; j < ((List)renderQuads).size(); ++j) {
                        ((VectorFan)((List)renderQuads).get(j)).renderPreview(red, green, blue, alpha);
                    }
                    continue;
                }
                if (!(renderQuads instanceof VectorFan)) continue;
                ((VectorFan)renderQuads).renderPreview(red, green, blue, alpha);
            }
        }
        matrix.m_85849_();
    }

    public void renderLines(PoseStack matrix, double x, double y, double z, int alpha) {
        int red = ColorUtils.red(this.color);
        int green = ColorUtils.green(this.color);
        int blue = ColorUtils.blue(this.color);
        if (red == 1 && green == 1 && blue == 1) {
            blue = 0;
            green = 0;
            red = 0;
        }
        matrix.m_85836_();
        matrix.m_85837_(x, y, z);
        if (this.previewScalingAndOffset()) {
            for (int i = 0; i < Facing.values().length; ++i) {
                Object renderQuads = this.getRenderQuads(Facing.values()[i]);
                if (renderQuads instanceof List) {
                    for (int j = 0; j < ((List)renderQuads).size(); ++j) {
                        ((VectorFan)((List)renderQuads).get(j)).renderLines(this.getPreviewOffX(), this.getPreviewOffY(), this.getPreviewOffZ(), this.getPreviewScaleX(), this.getPreviewScaleY(), this.getPreviewScaleZ(), red, green, blue, alpha);
                    }
                    continue;
                }
                if (!(renderQuads instanceof VectorFan)) continue;
                ((VectorFan)renderQuads).renderLines(this.getPreviewOffX(), this.getPreviewOffY(), this.getPreviewOffZ(), this.getPreviewScaleX(), this.getPreviewScaleY(), this.getPreviewScaleZ(), red, green, blue, alpha);
            }
        } else {
            for (int i = 0; i < Facing.values().length; ++i) {
                Object renderQuads = this.getRenderQuads(Facing.values()[i]);
                if (renderQuads instanceof List) {
                    for (int j = 0; j < ((List)renderQuads).size(); ++j) {
                        ((VectorFan)((List)renderQuads).get(j)).renderLines(red, green, blue, alpha);
                    }
                    continue;
                }
                if (!(renderQuads instanceof VectorFan)) continue;
                ((VectorFan)renderQuads).renderLines(red, green, blue, alpha);
            }
        }
        matrix.m_85849_();
    }

    public void renderLines(PoseStack matrix, double x, double y, double z, int alpha, Vector3d center, double grow) {
        int red = ColorUtils.red(this.color);
        int green = ColorUtils.green(this.color);
        int blue = ColorUtils.blue(this.color);
        if (red == 1 && green == 1 && blue == 1) {
            blue = 0;
            green = 0;
            red = 0;
        }
        matrix.m_85836_();
        matrix.m_85837_(x, y, z);
        if (this.previewScalingAndOffset()) {
            for (int i = 0; i < Facing.values().length; ++i) {
                Object renderQuads = this.getRenderQuads(Facing.values()[i]);
                if (renderQuads instanceof List) {
                    for (int j = 0; j < ((List)renderQuads).size(); ++j) {
                        ((VectorFan)((List)renderQuads).get(j)).renderLines(this.getPreviewOffX(), this.getPreviewOffY(), this.getPreviewOffZ(), this.getPreviewScaleX(), this.getPreviewScaleY(), this.getPreviewScaleZ(), red, green, blue, alpha, center, grow);
                    }
                    continue;
                }
                if (!(renderQuads instanceof VectorFan)) continue;
                ((VectorFan)renderQuads).renderLines(this.getPreviewOffX(), this.getPreviewOffY(), this.getPreviewOffZ(), this.getPreviewScaleX(), this.getPreviewScaleY(), this.getPreviewScaleZ(), red, green, blue, alpha, center, grow);
            }
        } else {
            for (int i = 0; i < Facing.values().length; ++i) {
                Object renderQuads = this.getRenderQuads(Facing.values()[i]);
                if (renderQuads instanceof List) {
                    for (int j = 0; j < ((List)renderQuads).size(); ++j) {
                        ((VectorFan)((List)renderQuads).get(j)).renderLines(red, green, blue, alpha, center, grow);
                    }
                    continue;
                }
                if (!(renderQuads instanceof VectorFan)) continue;
                ((VectorFan)renderQuads).renderLines(red, green, blue, alpha, center, grow);
            }
        }
        matrix.m_85849_();
    }

    public boolean isTranslucent() {
        if (ColorUtils.isTransparent(this.color)) {
            return true;
        }
        return !this.state.m_60767_().m_76337_() || !this.state.m_60767_().m_76333_();
    }

    protected List<BakedQuad> getBakedQuad(LevelAccessor level, BakedModel blockModel, BlockState state, Facing facing, BlockPos pos, RenderType layer, Random rand) {
        return OptifineHelper.getBakedQuad(blockModel.m_6840_(state, facing.toVanilla(), rand), level, state, facing, pos, layer, rand);
    }

    public List<BakedQuad> getBakedQuad(LevelAccessor level, @Nullable BlockPos pos, BlockPos offset, BlockState state, BakedModel blockModel, Facing facing, RenderType layer, Random rand, boolean overrideTint, int defaultColor) {
        List<BakedQuad> blockQuads = this.getBakedQuad(level, blockModel, state, facing, pos, layer, rand);
        if (blockQuads.isEmpty()) {
            return Collections.emptyList();
        }
        RenderInformationHolder holder = new RenderInformationHolder(DefaultVertexFormat.f_85811_, facing, this.color != -1 ? this.color : defaultColor);
        holder.offset = offset;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (int i = 0; i < blockQuads.size(); ++i) {
            holder.setQuad(blockQuads.get(i), overrideTint, defaultColor);
            if (!this.needsResorting && OptifineHelper.isEmissive(holder.quad.m_173410_())) {
                this.needsResorting = true;
            }
            int[] data = holder.quad.m_111303_();
            int index = 0;
            int uvIndex = index + holder.uvOffset / 4;
            float tempMinX = Float.intBitsToFloat(data[index]);
            float tempMinY = Float.intBitsToFloat(data[index + 1]);
            float tempMinZ = Float.intBitsToFloat(data[index + 2]);
            float tempU = Float.intBitsToFloat(data[uvIndex]);
            holder.uvInverted = false;
            index = 1 * holder.format.m_86017_();
            uvIndex = index + holder.uvOffset / 4;
            holder.uvInverted = tempMinX != Float.intBitsToFloat(data[index]) ? (tempU != Float.intBitsToFloat(data[uvIndex]) ? Axis.X != facing.getUAxis() : Axis.X != facing.getVAxis()) : (tempMinY != Float.intBitsToFloat(data[index + 1]) ? (tempU != Float.intBitsToFloat(data[uvIndex]) ? Axis.Y != facing.getUAxis() : Axis.Y != facing.getVAxis()) : (tempU != Float.intBitsToFloat(data[uvIndex]) ? Axis.Z != facing.getUAxis() : Axis.Z != facing.getVAxis()));
            index = 2 * holder.format.m_86017_();
            float tempMaxX = Float.intBitsToFloat(data[index]);
            float tempMaxY = Float.intBitsToFloat(data[index + 1]);
            float tempMaxZ = Float.intBitsToFloat(data[index + 2]);
            holder.setBounds(tempMinX, tempMinY, tempMinZ, tempMaxX, tempMaxY, tempMaxZ);
            if (!this.intersectsWithFace(facing, holder, offset)) continue;
            uvIndex = holder.uvOffset / 4;
            float u1 = Float.intBitsToFloat(data[uvIndex]);
            float v1 = Float.intBitsToFloat(data[uvIndex + 1]);
            uvIndex = 2 * holder.format.m_86017_() + holder.uvOffset / 4;
            float u2 = Float.intBitsToFloat(data[uvIndex]);
            float v2 = Float.intBitsToFloat(data[uvIndex + 1]);
            if (holder.uvInverted) {
                holder.sizeU = facing.getV(tempMinX, tempMinY, tempMinZ) < facing.getV(tempMaxX, tempMaxY, tempMaxZ) ? u2 - u1 : u1 - u2;
                holder.sizeV = facing.getU(tempMinX, tempMinY, tempMinZ) < facing.getU(tempMaxX, tempMaxY, tempMaxZ) ? v2 - v1 : v1 - v2;
            } else {
                holder.sizeU = facing.getU(tempMinX, tempMinY, tempMinZ) < facing.getU(tempMaxX, tempMaxY, tempMaxZ) ? u2 - u1 : u1 - u2;
                holder.sizeV = facing.getV(tempMinX, tempMinY, tempMinZ) < facing.getV(tempMaxX, tempMaxY, tempMaxZ) ? v2 - v1 : v1 - v2;
            }
            Object renderQuads = this.getRenderQuads(holder.facing);
            if (renderQuads instanceof List) {
                for (int j = 0; j < ((List)renderQuads).size(); ++j) {
                    ((VectorFan)((List)renderQuads).get(j)).generate(holder, quads);
                }
                continue;
            }
            if (!(renderQuads instanceof VectorFan)) continue;
            ((VectorFan)renderQuads).generate(holder, quads);
        }
        return quads;
    }

    private static int uvOffset(VertexFormat format) {
        for (int i = 0; i < format.m_86023_().size(); ++i) {
            if (((VertexFormatElement)format.m_86023_().get(i)).m_86048_() != VertexFormatElement.Usage.UV) continue;
            return format.getOffset(i);
        }
        return -1;
    }

    public class RenderInformationHolder {
        public final Facing facing;
        public final int color;
        public final VertexFormat format;
        public final int uvOffset;
        public BlockPos offset;
        public boolean shouldOverrideColor;
        public BakedQuad quad;
        public NormalPlane normal;
        public Ray2d ray = new Ray2d(Axis.X, Axis.Y, 0.0, 0.0, 0.0, 0.0);
        public final boolean scaleAndOffset;
        public final float offsetX;
        public final float offsetY;
        public final float offsetZ;
        public final float scaleX;
        public final float scaleY;
        public final float scaleZ;
        public float minX;
        public float minY;
        public float minZ;
        public float maxX;
        public float maxY;
        public float maxZ;
        public float sizeX;
        public float sizeY;
        public float sizeZ;
        public boolean uvInverted;
        public float sizeU;
        public float sizeV;

        public RenderInformationHolder(VertexFormat format, Facing facing, int color) {
            this.color = color;
            this.format = format;
            this.facing = facing;
            this.uvOffset = RenderBox.uvOffset(format);
            RenderBox box = this.getBox();
            this.scaleAndOffset = box.scaleAndOffsetQuads(facing);
            if (this.scaleAndOffset) {
                if (box.onlyScaleOnceNoOffset(facing)) {
                    this.offsetZ = 0.0f;
                    this.offsetY = 0.0f;
                    this.offsetX = 0.0f;
                    this.scaleY = this.scaleZ = box.getOverallScale(facing);
                    this.scaleX = this.scaleZ;
                } else {
                    this.offsetX = box.getOffsetX();
                    this.offsetY = box.getOffsetY();
                    this.offsetZ = box.getOffsetZ();
                    this.scaleX = box.getScaleX();
                    this.scaleY = box.getScaleY();
                    this.scaleZ = box.getScaleZ();
                }
            } else {
                this.offsetZ = 0.0f;
                this.offsetY = 0.0f;
                this.offsetX = 0.0f;
                this.scaleZ = 0.0f;
                this.scaleY = 0.0f;
                this.scaleX = 0.0f;
            }
        }

        public void setQuad(BakedQuad quad, boolean overrideTint, int defaultColor) {
            this.quad = quad;
            this.shouldOverrideColor = overrideTint && (defaultColor == -1 || quad.m_111304_()) && this.color != -1;
        }

        public void setBounds(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
            this.minX = Math.min(minX, maxX);
            this.minY = Math.min(minY, maxY);
            this.minZ = Math.min(minZ, maxZ);
            this.maxX = Math.max(minX, maxX);
            this.maxY = Math.max(minY, maxY);
            this.maxZ = Math.max(minZ, maxZ);
            this.sizeX = this.maxX - this.minX;
            this.sizeY = this.maxY - this.minY;
            this.sizeZ = this.maxZ - this.minZ;
        }

        public RenderBox getBox() {
            return RenderBox.this;
        }

        public boolean hasBounds() {
            switch (this.facing.axis) {
                case X: {
                    return this.minY != 0.0f || this.maxY != 1.0f || this.minZ != 0.0f || this.maxZ != 1.0f;
                }
                case Y: {
                    return this.minX != 0.0f || this.maxX != 1.0f || this.minZ != 0.0f || this.maxZ != 1.0f;
                }
                case Z: {
                    return this.minX != 0.0f || this.maxX != 1.0f || this.minY != 0.0f || this.maxY != 1.0f;
                }
            }
            return false;
        }
    }

    private static class VectorFanSimple
    extends VectorFan {
        public VectorFanSimple(Vec3f[] coords) {
            super(coords);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void generate(RenderInformationHolder holder, List<BakedQuad> quads) {
            int index;
            for (index = 0; index < this.coords.length - 3; index += 2) {
                this.generate(holder, this.coords[0], this.coords[index + 1], this.coords[index + 2], this.coords[index + 3], quads);
            }
            if (index < this.coords.length - 2) {
                this.generate(holder, this.coords[0], this.coords[index + 1], this.coords[index + 2], this.coords[index + 2], quads);
            }
        }

        @Override
        protected boolean doMinMaxLate() {
            return true;
        }
    }
}

