/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.IModelData;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.client.render.box.RenderBox;
import team.creative.creativecore.client.render.model.CreativeRenderBlock;
import team.creative.creativecore.client.render.model.CreativeRenderItem;
import team.creative.creativecore.common.util.math.base.Facing;

public class CreativeBakedModel
implements BakedModel {
    public static Minecraft mc = Minecraft.m_91087_();
    public static ItemColors itemColores = null;
    public static TextureAtlasSprite woodenTexture;
    private static ItemStack lastItemStack;
    public static ItemOverrides customOverride;

    public static void lateInit() {
        itemColores = mc.getItemColors();
    }

    public static void setLastItemStack(ItemStack stack) {
        lastItemStack = stack;
    }

    public static TextureAtlasSprite getWoodenTexture() {
        if (woodenTexture == null) {
            woodenTexture = (TextureAtlasSprite)mc.m_91258_(TextureAtlas.f_118259_).apply(new ResourceLocation("minecraft", "blocks/planks_oak"));
        }
        return woodenTexture;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData extraData) {
        return CreativeBakedModel.getQuads(state, Facing.get(side), rand, extraData, false);
    }

    public static List<BakedQuad> compileBoxes(List<? extends RenderBox> boxes, Facing side, RenderType layer, Random rand, boolean item) {
        ArrayList<BakedQuad> baked = new ArrayList<BakedQuad>();
        for (int i = 0; i < boxes.size(); ++i) {
            RenderBox box = boxes.get(i);
            if (!box.renderSide(side)) continue;
            BlockState state = Blocks.f_50016_.m_49966_();
            if (box.state != null) {
                state = box.state;
            }
            BakedModel blockModel = mc.m_91289_().m_110910_(state);
            int defaultColor = -1;
            if (item) {
                defaultColor = itemColores.m_92676_(new ItemStack((ItemLike)state.m_60734_()), defaultColor);
            }
            baked.addAll(box.getBakedQuad(null, null, box.getOffset(), state, blockModel, side, layer, rand, true, defaultColor));
        }
        return baked;
    }

    public static List<BakedQuad> getQuads(BlockState state, Facing facing, Random rand, IModelData extraData, boolean threaded) {
        if (state != null) {
            CreativeRenderBlock renderer = CreativeCoreClient.RENDERED_BLOCKS.get(state.m_60734_());
            if (renderer != null) {
                return CreativeBakedModel.compileBoxes(renderer.getBoxes(state), facing, MinecraftForgeClient.getRenderType(), rand, false);
            }
            return Collections.EMPTY_LIST;
        }
        ItemStack stack = lastItemStack;
        CreativeRenderItem renderer = CreativeCoreClient.RENDERED_ITEMS.get(stack.m_41720_());
        if (renderer != null) {
            RenderType layer = MinecraftForgeClient.getRenderType();
            List<BakedQuad> cached = renderer.getCachedModel(facing, layer, stack, threaded);
            if (cached != null) {
                return cached;
            }
            List<? extends RenderBox> boxes = renderer.getBoxes(stack, layer);
            if (boxes != null) {
                cached = CreativeBakedModel.compileBoxes(boxes, facing, layer, rand, true);
                renderer.saveCachedModel(facing, layer, cached, stack, threaded);
                return cached;
            }
        }
        return Collections.EMPTY_LIST;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon(IModelData data) {
        return CreativeBakedModel.getWoodenTexture();
    }

    public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack poseStack) {
        CreativeRenderItem renderer;
        if (lastItemStack != null && (renderer = CreativeCoreClient.RENDERED_ITEMS.get(lastItemStack.m_41720_())) != null) {
            renderer.applyCustomOpenGLHackery(poseStack, lastItemStack, cameraTransformType);
        }
        return super.handlePerspective(cameraTransformType, poseStack);
    }

    public ItemOverrides m_7343_() {
        return customOverride;
    }

    public boolean isLayered() {
        return true;
    }

    public List<Pair<BakedModel, RenderType>> getLayerModels(ItemStack itemStack, boolean fabulous) {
        CreativeRenderItem renderer = CreativeCoreClient.RENDERED_ITEMS.get(lastItemStack.m_41720_());
        if (renderer != null) {
            RenderType[] itemLayers = renderer.getLayers(itemStack, fabulous);
            ArrayList<Pair<BakedModel, RenderType>> layers = new ArrayList<Pair<BakedModel, RenderType>>(itemLayers.length);
            for (int i = 0; i < itemLayers.length; ++i) {
                layers.add((Pair<BakedModel, RenderType>)new Pair((Object)this, (Object)itemLayers[i]));
            }
            return layers;
        }
        return Collections.EMPTY_LIST;
    }

    @Deprecated
    public List<BakedQuad> m_6840_(BlockState state, Direction direction, Random rand) {
        return null;
    }

    public boolean m_7547_() {
        return true;
    }

    public TextureAtlasSprite m_6160_() {
        return CreativeBakedModel.getWoodenTexture();
    }

    static {
        lastItemStack = null;
        customOverride = new ItemOverrides(){

            public BakedModel m_173464_(BakedModel original, ItemStack stack, ClientLevel level, LivingEntity entity, int p_173469_) {
                lastItemStack = stack;
                return super.m_173464_(original, stack, level, entity, p_173469_);
            }
        };
    }
}

