/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.gui;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import team.creative.creativecore.common.config.gui.PlayerSelectorDialog;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.handler.GuiLayerHandler;
import team.creative.creativecore.common.gui.integration.IGuiIntegratedParent;
import team.creative.creativecore.common.gui.sync.LayerOpenPacket;
import team.creative.creativecore.common.util.player.PlayerSelector;

public class GuiPlayerSelectorButton
extends GuiButton {
    private PlayerSelector info;

    public GuiPlayerSelectorButton(String name, PlayerSelector info) {
        super(name, null);
        this.pressed = x -> {
            PlayerSelectorDialog layer = (PlayerSelectorDialog)this.getParent().openLayer(new LayerOpenPacket("player", new CompoundTag()));
            layer.button = this;
            layer.init();
        };
        this.setTitle((Component)new TextComponent(GuiPlayerSelectorButton.getLabelText(info)));
        this.info = info;
    }

    public void set(PlayerSelector info) {
        this.info = info;
        this.setTitle((Component)new TextComponent(GuiPlayerSelectorButton.getLabelText(info)));
        this.raiseEvent(new GuiControlChangedEvent(this));
    }

    public static String getLabelText(PlayerSelector value) {
        Object info = value.info();
        if (((String)info).length() > 25) {
            info = ((String)info).substring(22) + "...";
        }
        return info;
    }

    public PlayerSelector get() {
        return this.info;
    }

    static {
        GuiLayerHandler.REGISTRY.register("player", new GuiLayerHandler(){

            @Override
            public GuiLayer create(IGuiIntegratedParent parent, CompoundTag nbt) {
                return new PlayerSelectorDialog();
            }
        });
    }
}

