/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiControlClickEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.event.GuiEventManager;
import team.creative.creativecore.common.gui.event.GuiTooltipEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.sync.LayerOpenPacket;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiParent
extends GuiControl
implements IGuiParent,
Iterable<GuiChildControl> {
    private GuiEventManager eventManager;
    protected List<GuiChildControl> controls = new CopyOnWriteArrayList<GuiChildControl>();
    protected List<GuiChildControl> hoverControls = new CopyOnWriteArrayList<GuiChildControl>();
    public GuiFlow flow;
    public Align align = Align.LEFT;
    public VAlign valign = VAlign.TOP;
    public int spacing = 2;

    public GuiParent(String name, GuiFlow flow) {
        super(name);
        this.flow = flow;
    }

    public GuiParent(String name, GuiFlow flow, int width, int height) {
        super(name, width, height);
        this.flow = flow;
    }

    public GuiParent(String name, GuiFlow flow, Align align, VAlign valign) {
        this(name, flow);
        this.align = align;
        this.valign = valign;
    }

    public GuiParent(String name, GuiFlow flow, int width, int height, Align align, VAlign valign) {
        this(name, flow, width, height);
        this.align = align;
        this.valign = valign;
    }

    public GuiParent(String name, GuiFlow flow, int width, int height, VAlign valign) {
        this(name, flow, width, height, Align.LEFT, valign);
    }

    public GuiParent(String name) {
        this(name, GuiFlow.STACK_X);
    }

    public GuiParent() {
        this("");
    }

    public GuiParent(GuiFlow flow) {
        this("", flow);
    }

    @Override
    public boolean isClient() {
        return this.getParent().isClient();
    }

    public double getScaleFactor() {
        return 1.0;
    }

    public double getOffsetY() {
        return 0.0;
    }

    public double getOffsetX() {
        return 0.0;
    }

    @Override
    public boolean isExpandableX() {
        if (super.isExpandableX()) {
            return true;
        }
        for (GuiChildControl child : this.controls) {
            if (!child.control.isExpandableX()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isExpandableY() {
        if (super.isExpandableY()) {
            return true;
        }
        for (GuiChildControl child : this.controls) {
            if (!child.control.isExpandableY()) continue;
            return true;
        }
        return false;
    }

    private static GuiControl get(String name, List<GuiChildControl> collection) {
        for (int i = 0; i < collection.size(); ++i) {
            GuiControl control = collection.get((int)i).control;
            if (control.name.equalsIgnoreCase(name)) {
                return control;
            }
            if (!(control instanceof GuiParent)) continue;
            if (control.name.isBlank()) {
                GuiControl result = ((GuiParent)control).get(name);
                if (result == null) continue;
                return result;
            }
            if (!name.startsWith(control.name + ".")) continue;
            return ((GuiParent)control).get(name.substring(control.name.length() + 1));
        }
        return null;
    }

    public GuiControl get(String name) {
        GuiControl result = GuiParent.get(name, this.controls);
        if (result != null) {
            return result;
        }
        return GuiParent.get(name, this.hoverControls);
    }

    public boolean has(String name) {
        return this.get(name) != null;
    }

    public GuiChildControl add(GuiControl control) {
        control.setParent(this);
        GuiChildControl child = new GuiChildControl(control);
        this.controls.add(child);
        return child;
    }

    public GuiChildControl addHover(GuiControl control) {
        control.setParent(this);
        GuiChildControl child = new GuiChildControl(control);
        this.hoverControls.add(child);
        return child;
    }

    public boolean remove(GuiChildControl control) {
        return this.controls.remove(control) || this.hoverControls.remove(control);
    }

    public GuiChildControl remove(GuiControl control) {
        GuiChildControl child;
        int i;
        for (i = 0; i < this.controls.size(); ++i) {
            child = this.controls.get(i);
            if (child.control != control) continue;
            this.controls.remove(i);
            return child;
        }
        for (i = 0; i < this.hoverControls.size(); ++i) {
            child = this.hoverControls.get(i);
            if (child.control != control) continue;
            this.hoverControls.remove(i);
            return child;
        }
        return null;
    }

    public void remove(String ... include) {
        this.controls.removeIf(x -> ArrayUtils.contains((Object[])include, (Object)x.control.name));
        this.hoverControls.removeIf(x -> ArrayUtils.contains((Object[])include, (Object)x.control.name));
    }

    public void removeExclude(String ... exclude) {
        this.controls.removeIf(x -> !ArrayUtils.contains((Object[])exclude, (Object)x.control.name));
        this.hoverControls.removeIf(x -> !ArrayUtils.contains((Object[])exclude, (Object)x.control.name));
    }

    public boolean isEmpty() {
        return this.controls.isEmpty() && this.hoverControls.isEmpty();
    }

    public void clear() {
        this.controls.clear();
        this.hoverControls.clear();
    }

    public int size() {
        return this.controls.size() + this.hoverControls.size();
    }

    @Override
    public Iterator<GuiChildControl> iterator() {
        return new Iterator<GuiChildControl>(){
            Iterator<GuiChildControl> itr;
            boolean first;
            {
                this.itr = GuiParent.this.hoverControls.iterator();
                this.first = true;
            }

            @Override
            public boolean hasNext() {
                if (this.itr.hasNext()) {
                    return true;
                }
                if (this.first) {
                    this.itr = GuiParent.this.controls.iterator();
                    this.first = false;
                }
                return this.itr.hasNext();
            }

            @Override
            public GuiChildControl next() {
                return this.itr.next();
            }
        };
    }

    protected void renderContent(PoseStack matrix, Rect contentRect, Rect realContentRect, int mouseX, int mouseY, List<GuiChildControl> collection, double scale, double xOffset, double yOffset, boolean hover) {
        for (int i = collection.size() - 1; i >= 0; --i) {
            Rect controlRect;
            Rect realRect;
            GuiChildControl child = collection.get(i);
            GuiControl control = child.control;
            if (!control.visible || (realRect = realContentRect.intersection(controlRect = contentRect.child(child.rect, scale, xOffset, yOffset))) == null && !hover) continue;
            if (hover) {
                RenderSystem.m_69471_();
            } else {
                realRect.scissor();
            }
            matrix.m_85836_();
            matrix.m_85837_(((double)child.getX() + xOffset) * scale, ((double)child.getY() + yOffset) * scale, 10.0);
            control.render(matrix, child, controlRect, hover ? controlRect : realRect, mouseX, mouseY);
            matrix.m_85849_();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(PoseStack matrix, GuiChildControl control, Rect contentRect, Rect realContentRect, int mouseX, int mouseY) {
        if (realContentRect == null) {
            return;
        }
        double scale = this.getScaleFactor();
        double xOffset = this.getOffsetX();
        double yOffset = this.getOffsetY();
        this.renderContent(matrix, contentRect, realContentRect, mouseX, mouseY, this.controls, scale, xOffset, yOffset, false);
        this.renderContent(matrix, contentRect, realContentRect, mouseX, mouseY, this.hoverControls, scale, xOffset, yOffset, true);
        super.renderContent(matrix, control, contentRect, realContentRect, mouseX, mouseY);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(PoseStack matrix, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
    }

    @Override
    public boolean isContainer() {
        return this.getParent().isContainer();
    }

    @Override
    public void init() {
        for (GuiChildControl child : this) {
            child.control.init();
        }
    }

    @Override
    public void closed() {
        for (GuiChildControl child : this) {
            child.control.closed();
        }
    }

    @Override
    public void tick() {
        for (GuiChildControl child : this) {
            child.control.tick();
        }
    }

    @Override
    public void closeTopLayer() {
        this.getParent().closeTopLayer();
    }

    @Override
    public GuiLayer openLayer(LayerOpenPacket packet) {
        return this.getParent().openLayer(packet);
    }

    @Override
    public GuiTooltipEvent getTooltipEvent(Rect rect, double x, double y) {
        GuiTooltipEvent event = super.getTooltipEvent(rect, x, y);
        if (event != null) {
            return event;
        }
        x *= this.getScaleFactor();
        y *= this.getScaleFactor();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        for (GuiChildControl child : this) {
            if (!child.control.isInteractable() || !child.isMouseOver(x, y) || (event = child.control.getTooltipEvent(child.rect, x - (double)child.getX(), y - (double)child.getY())) == null) continue;
            return event;
        }
        return null;
    }

    @Override
    public boolean testForDoubleClick(Rect rect, double x, double y) {
        x *= this.getScaleFactor();
        y *= this.getScaleFactor();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        for (GuiChildControl child : this) {
            if (!child.control.isInteractable() || !child.control.testForDoubleClick(child.rect, x - (double)child.getX(), y - (double)child.getY())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseMoved(Rect rect, double x, double y) {
        x *= this.getScaleFactor();
        y *= this.getScaleFactor();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        for (GuiChildControl child : this) {
            if (!child.control.isInteractable()) continue;
            child.control.mouseMoved(child.rect, x - (double)child.getX(), y - (double)child.getY());
        }
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        x *= this.getScaleFactor();
        y *= this.getScaleFactor();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        boolean result = false;
        for (GuiChildControl child : this) {
            if (!result && child.control.isInteractable() && child.isMouseOver(x, y) && child.control.mouseClicked(child.rect, x - (double)child.getX(), y - (double)child.getY(), button)) {
                this.raiseEvent(new GuiControlClickEvent(child.control, button, false));
                result = true;
                continue;
            }
            child.control.looseFocus();
        }
        return result;
    }

    @Override
    public boolean mouseDoubleClicked(Rect rect, double x, double y, int button) {
        x *= this.getScaleFactor();
        y *= this.getScaleFactor();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        boolean result = false;
        for (GuiChildControl child : this) {
            if (!result && child.control.isInteractable() && child.isMouseOver(x, y) && child.control.mouseDoubleClicked(child.rect, x - (double)child.getX(), y - (double)child.getY(), button)) {
                this.raiseEvent(new GuiControlClickEvent(child.control, button, false));
                result = true;
                continue;
            }
            child.control.looseFocus();
        }
        return result;
    }

    @Override
    public void mouseReleased(Rect rect, double x, double y, int button) {
        x *= this.getScaleFactor();
        y *= this.getScaleFactor();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        for (GuiChildControl child : this) {
            if (!child.control.isInteractable()) continue;
            child.control.mouseReleased(child.rect, x - (double)child.getX(), y - (double)child.getY(), button);
        }
    }

    @Override
    public void mouseDragged(Rect rect, double x, double y, int button, double dragX, double dragY, double time) {
        x *= this.getScaleFactor();
        y *= this.getScaleFactor();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        for (GuiChildControl child : this) {
            if (!child.control.isInteractable()) continue;
            child.control.mouseDragged(child.rect, x - (double)child.getX(), y - (double)child.getY(), button, dragX, dragY, time);
        }
    }

    @Override
    public boolean mouseScrolled(Rect rect, double x, double y, double delta) {
        x *= this.getScaleFactor();
        y *= this.getScaleFactor();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        for (GuiChildControl child : this) {
            if (!child.control.isInteractable() || !child.isMouseOver(x, y) || !child.control.mouseScrolled(child.rect, x - (double)child.getX(), y - (double)child.getY(), delta)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (GuiChildControl child : this) {
            if (!child.control.isInteractable() || !child.control.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        for (GuiChildControl child : this) {
            if (!child.control.isInteractable() || !child.control.keyReleased(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean charTyped(char codePoint, int modifiers) {
        for (GuiChildControl child : this) {
            if (!child.control.isInteractable() || !child.control.charTyped(codePoint, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void looseFocus() {
        for (GuiChildControl child : this) {
            child.control.looseFocus();
        }
    }

    @Override
    public void raiseEvent(GuiEvent event) {
        if (this.getParent() == null) {
            return;
        }
        if (this.eventManager != null) {
            this.eventManager.raiseEvent(event);
        }
        if (!event.isCanceled()) {
            this.getParent().raiseEvent(event);
        }
    }

    public void registerEventClick(Consumer<GuiControlClickEvent> consumer) {
        this.registerEvent(GuiControlClickEvent.class, consumer);
    }

    public void registerEventChanged(Consumer<GuiControlChangedEvent> consumer) {
        this.registerEvent(GuiControlChangedEvent.class, consumer);
    }

    public <T extends GuiEvent> void registerEvent(Class<T> clazz, Consumer<T> action) {
        if (this.eventManager == null) {
            this.eventManager = new GuiEventManager();
        }
        this.eventManager.registerEvent(clazz, action);
    }

    @Override
    public String getNestedName() {
        if (this.name.isBlank()) {
            if (this.getParent() instanceof GuiControl) {
                return ((GuiControl)((Object)this.getParent())).getNestedName();
            }
            return "";
        }
        return super.getNestedName();
    }

    @Override
    public void flowX(int width, int preferred) {
        this.flow.flowX(this.controls, this.spacing, this.align, width, preferred);
    }

    @Override
    public void flowY(int height, int preferred) {
        this.flow.flowY(this.controls, this.spacing, this.valign, height, preferred);
    }

    @Override
    public int getMinWidth() {
        return this.flow.minWidth(this.controls, this.spacing);
    }

    @Override
    protected int preferredWidth() {
        return this.flow.preferredWidth(this.controls, this.spacing);
    }

    @Override
    public int getMinHeight() {
        return this.flow.minHeight(this.controls, this.spacing);
    }

    @Override
    protected int preferredHeight() {
        return this.flow.preferredHeight(this.controls, this.spacing);
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.TRANSPARENT;
    }
}

