/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.controls.GuiLabel;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.style.display.DisplayColor;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiCheckBox
extends GuiLabel {
    public static final StyleDisplay partialStyle = new DisplayColor();
    public static final int checkBoxWidth = 7;
    public boolean value = false;
    public String title;
    public boolean partial = false;

    public GuiCheckBox(String name, String title, int x, int y, boolean value) {
        super(name, x, y);
        this.value = value;
        this.title = title;
    }

    public GuiCheckBox(String title, int x, int y, boolean value) {
        this(title, title, x, y, value);
    }

    @Override
    public int getPreferredWidth() {
        return super.getPreferredWidth() + 7 + 3;
    }

    @Override
    public int getPreferredHeight() {
        return Math.max(10, super.getPreferredHeight());
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.TRANSPARENT_NO_DISABLE;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(PoseStack matrix, Rect rect, int mouseX, int mouseY) {
        int yoffset = 0;
        GuiStyle style = this.getStyle();
        if (!this.enabled) {
            style.disabled.render(matrix, 0.0, (double)yoffset, 7.0, 7.0);
        }
        style.get(ControlFormatting.ControlStyleBorder.SMALL).render(matrix, 0.0, (double)yoffset, 7.0, 7.0);
        style.get(ControlFormatting.ControlStyleFace.NESTED_BACKGROUND, rect.inside(mouseX, mouseY)).render(matrix, 1.0, (double)(yoffset + 1), 5.0, 5.0);
        if (this.value) {
            Minecraft.m_91087_().f_91062_.m_92883_(matrix, "x", 1.0f, (float)(yoffset - 1), this.enabled ? -1 : style.fontColorHighlight.toInt());
        } else if (this.partial) {
            partialStyle.render(matrix, 2.0, (double)(yoffset + 2), 3.0, 3.0);
        }
        matrix.m_85836_();
        matrix.m_85837_(10.0, 0.0, 0.0);
        this.text.render(matrix);
        matrix.m_85849_();
    }

    public boolean mouseClicked(double x, double y, int button) {
        GuiCheckBox.playSound(SoundEvents.f_12490_);
        this.value = !this.value;
        this.raiseEvent(new GuiControlChangedEvent(this));
        return true;
    }
}

