/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.controls.GuiButtonFixed;
import team.creative.creativecore.common.gui.controls.GuiStackSelectorExtension;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.type.HashMapList;

public class GuiStackSelector
extends GuiButtonFixed {
    protected GuiStackSelectorExtension extension;
    public StackCollector collector;
    protected HashMapList<String, ItemStack> stacks;
    public Player player;
    public boolean searchBar;
    protected ItemStack selected = ItemStack.f_41583_;

    public GuiStackSelector(String name, int x, int y, int width, Player player, StackCollector collector, boolean searchBar) {
        super(name, x, y, width, 18, null);
        this.pressed = button -> {
            if (this.extension == null) {
                this.openBox();
            } else {
                this.closeBox();
            }
        };
        this.searchBar = searchBar;
        this.player = player;
        this.collector = collector;
        this.updateCollectedStacks();
        this.selectFirst();
    }

    public GuiStackSelector(String name, int x, int y, int width, Player player, StackCollector collector) {
        this(name, x, y, width, player, collector, true);
    }

    public boolean selectFirst() {
        ItemStack first;
        if (this.stacks != null && (first = this.stacks.getFirst()) != null) {
            this.setSelected(first);
            return true;
        }
        return false;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    public void updateCollectedStacks() {
        this.stacks = this.collector.collect(this.player);
    }

    public boolean setSelectedForce(ItemStack stack) {
        this.setTitle(new TextBuilder().stack(stack).add(stack.m_41611_()).build());
        this.selected = stack;
        this.raiseEvent(new GuiControlChangedEvent(this));
        return true;
    }

    public boolean setSelected(ItemStack stack) {
        if (this.stacks.contains(stack)) {
            this.setTitle(new TextBuilder().stack(stack).add(stack.m_41611_()).build());
            this.selected = stack;
            this.raiseEvent(new GuiControlChangedEvent(this));
            return true;
        }
        return false;
    }

    public HashMapList<String, ItemStack> getStacks() {
        return this.stacks;
    }

    public ItemStack getSelected() {
        return this.selected;
    }

    public void openBox() {
        this.extension = this.createBox();
        GuiLayer layer = this.getLayer();
        layer.add(this.extension);
        this.extension.moveTop();
        this.extension.init();
        this.extension.setX(this.getControlOffsetX());
        this.extension.setY(this.getControlOffsetY() + this.getHeight());
        if (this.extension.getY() + this.extension.getHeight() > layer.getHeight() && this.getY() >= this.extension.getHeight()) {
            this.extension.setY(this.extension.getY() - this.getHeight() + this.extension.getHeight());
        }
    }

    public void closeBox() {
        if (this.extension != null) {
            this.getLayer().remove(this.extension);
            this.extension = null;
        }
    }

    protected GuiStackSelectorExtension createBox() {
        return new GuiStackSelectorExtension(this.name + "extension", this.getPlayer(), this.getX(), this.getY() + this.getHeight(), this.getWidth(), 80, this);
    }

    public boolean select(String line) {
        return false;
    }

    public static boolean contains(String search, ItemStack stack) {
        if (search.equals("")) {
            return true;
        }
        if (GuiStackSelector.getItemName(stack).toLowerCase().contains(search)) {
            return true;
        }
        for (Component line : stack.m_41651_(null, (TooltipFlag)TooltipFlag.Default.NORMAL)) {
            if (!line.getString().toLowerCase().contains(search)) continue;
            return true;
        }
        return false;
    }

    public static String getItemName(ItemStack stack) {
        String itemName = "";
        try {
            itemName = stack.m_41611_().getString();
        }
        catch (Exception e) {
            itemName = stack.m_41720_().getRegistryName().toString();
        }
        return itemName;
    }

    public static abstract class StackCollector {
        public StackSelector selector;

        public StackCollector(StackSelector selector) {
            this.selector = selector;
        }

        public abstract HashMapList<String, ItemStack> collect(Player var1);
    }

    public static class GuiBlockSelector
    extends SearchSelector {
        @Override
        public boolean allow(ItemStack stack) {
            if (super.allow(stack)) {
                return Block.m_49814_((Item)stack.m_41720_()) != null && !(Block.m_49814_((Item)stack.m_41720_()) instanceof AirBlock);
            }
            return false;
        }
    }

    public static class SearchSelector
    extends StackSelector {
        public String search = "";

        @Override
        public boolean allow(ItemStack stack) {
            return GuiStackSelector.contains(this.search, stack);
        }
    }

    public static abstract class StackSelector {
        public abstract boolean allow(ItemStack var1);
    }

    public static class CreativeCollector
    extends InventoryCollector {
        public CreativeCollector(StackSelector selector) {
            super(selector);
        }

        @Override
        public HashMapList<String, ItemStack> collect(Player player) {
            HashMapList<String, ItemStack> stacks = super.collect(player);
            NonNullList tempStacks = NonNullList.m_122779_();
            for (Item item : ForgeRegistries.ITEMS) {
                if (item.getCreativeTabs().isEmpty()) continue;
                item.m_6787_(CreativeModeTab.f_40754_, tempStacks);
            }
            ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
            for (ItemStack stack : tempStacks) {
                if (stack.m_41619_() || !this.selector.allow(stack)) continue;
                newStacks.add(stack);
            }
            stacks.add("selector.all", (ItemStack)newStacks);
            return stacks;
        }
    }

    public static class InventoryCollector
    extends StackCollector {
        public InventoryCollector(StackSelector selector) {
            super(selector);
        }

        @Override
        public HashMapList<String, ItemStack> collect(Player player) {
            HashMapList<String, ItemStack> stacks = new HashMapList<String, ItemStack>();
            if (player != null) {
                ArrayList<ItemStack> tempStacks = new ArrayList<ItemStack>();
                for (ItemStack stack : player.f_36095_.m_38927_()) {
                    if (!stack.m_41619_() && this.selector.allow(stack)) {
                        tempStacks.add(stack.m_41777_());
                        continue;
                    }
                    LazyOptional result = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
                    if (!result.isPresent()) continue;
                    this.collect((IItemHandler)result.cast(), tempStacks);
                }
                stacks.add("selector.inventory", (ItemStack)tempStacks);
            }
            return stacks;
        }

        protected void collect(IItemHandler inventory, List<ItemStack> stacks) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (!stack.m_41619_() && this.selector.allow(stack)) {
                    stacks.add(stack.m_41777_());
                    continue;
                }
                LazyOptional result = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
                if (!result.isPresent()) continue;
                this.collect((IItemHandler)result.cast(), stacks);
            }
        }
    }
}

