/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.flow;

import java.util.Iterator;
import java.util.List;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.type.list.MarkList;

public class GuiStackX
extends GuiFlow {
    @Override
    public int minWidth(List<GuiChildControl> controls, int spacing) {
        boolean has = false;
        int width = -spacing;
        for (GuiChildControl child : controls) {
            int min = child.getMinWidth();
            if (min != -1) {
                width += min;
                has = true;
            }
            width += spacing;
        }
        return has ? width : -1;
    }

    @Override
    public int preferredWidth(List<GuiChildControl> controls, int spacing) {
        int width = -spacing;
        for (GuiChildControl child : controls) {
            width += child.getPreferredWidth() + spacing;
        }
        return width;
    }

    @Override
    public int minHeight(List<GuiChildControl> controls, int spacing) {
        int height = -1;
        for (GuiChildControl child : controls) {
            height = Math.max(height, child.getMinHeight());
        }
        return height;
    }

    @Override
    public int preferredHeight(List<GuiChildControl> controls, int spacing) {
        int height = 0;
        for (GuiChildControl child : controls) {
            height = Math.max(height, child.getPreferredHeight());
        }
        return height;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void flowX(List<GuiChildControl> controls, int spacing, Align align, int width, int preferred) {
        block24: {
            int available;
            block25: {
                block23: {
                    available = width - spacing * (controls.size() - 1);
                    MarkList<GuiChildControl> list = new MarkList<GuiChildControl>(controls);
                    if (width >= preferred) {
                        if (align == Align.STRETCH && !GuiStackX.areChildrenExpandableX(controls)) {
                            for (GuiChildControl guiChildControl : list) {
                                int min = guiChildControl.getMinWidth();
                                if (min != -1) {
                                    available -= min;
                                    guiChildControl.setWidth(min);
                                    continue;
                                }
                                guiChildControl.setWidth(0);
                            }
                            while (available > 0 && !list.isEmpty()) {
                                int average = (int)Math.ceil((double)available / (double)list.remaing());
                                Iterator iterator = list.iterator();
                                while (iterator.hasNext()) {
                                    GuiChildControl child = (GuiChildControl)iterator.next();
                                    available -= child.addWidth(Math.min(average, available));
                                    if (!child.isMaxWidth()) continue;
                                    iterator.mark();
                                }
                            }
                        } else {
                            Iterator itr = list.iterator();
                            while (itr.hasNext()) {
                                GuiChildControl guiChildControl = (GuiChildControl)itr.next();
                                guiChildControl.setWidth(guiChildControl.getPreferredWidth());
                                if (!guiChildControl.control.isExpandableX()) {
                                    itr.mark();
                                }
                                available -= guiChildControl.getWidth();
                            }
                            if (align == Align.STRETCH || GuiStackX.areChildrenExpandableX(controls)) {
                                while (available > 0 && !list.isEmpty()) {
                                    int average = (int)Math.ceil((double)available / (double)list.remaing());
                                    Iterator iterator = list.iterator();
                                    while (iterator.hasNext()) {
                                        GuiChildControl child = (GuiChildControl)iterator.next();
                                        available -= child.addWidth(Math.min(average, available));
                                        if (!child.isMaxWidth()) continue;
                                        iterator.mark();
                                    }
                                }
                            }
                        }
                    } else {
                        for (GuiChildControl guiChildControl : list) {
                            int min = guiChildControl.getMinWidth();
                            if (min != -1) {
                                available -= min;
                                guiChildControl.setWidth(min);
                                continue;
                            }
                            guiChildControl.setWidth(0);
                        }
                        while (available > 0 && !list.isEmpty()) {
                            int average = (int)Math.ceil((double)available / (double)list.remaing());
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                GuiChildControl child = (GuiChildControl)iterator.next();
                                int prefer = child.getPreferredWidth();
                                available -= child.addWidth(Math.min(average, Math.min(prefer - child.getWidth(), available)));
                                if (!child.isMaxWidth() && prefer > child.getWidth()) continue;
                                iterator.mark();
                            }
                        }
                        list.clear();
                        while (available > 0 && !list.isEmpty()) {
                            int average = (int)Math.ceil((double)available / (double)list.remaing());
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                GuiChildControl child = (GuiChildControl)iterator.next();
                                available -= child.addWidth(Math.min(average, available));
                                if (!child.isMaxWidth()) continue;
                                iterator.mark();
                            }
                        }
                    }
                    for (GuiChildControl guiChildControl : controls) {
                        guiChildControl.flowX();
                    }
                    if (available > 0 && align != Align.LEFT) break block23;
                    int x = 0;
                    for (GuiChildControl child : controls) {
                        child.setX(x);
                        x += child.getWidth() + spacing;
                    }
                    break block24;
                }
                if (align != Align.RIGHT) break block25;
                int x = width;
                for (GuiChildControl child : controls) {
                    child.setX(x -= child.getWidth());
                    x -= spacing;
                }
                break block24;
            }
            if (align != Align.CENTER && align != Align.STRETCH) break block24;
            int contentWidth = width - (available + spacing * (controls.size() - 1));
            int n = width / 2 - contentWidth / 2;
            for (GuiChildControl child : controls) {
                void var9_35;
                child.setX((int)var9_35);
                var9_35 += child.getWidth() + spacing;
            }
        }
    }

    @Override
    public void flowY(List<GuiChildControl> controls, int spacing, VAlign valign, int height, int preferred) {
        boolean expandable = GuiStackX.areChildrenExpandableY(controls);
        if (valign == VAlign.TOP && !expandable) {
            for (GuiChildControl child : controls) {
                child.setY(0);
                child.setHeight(Math.min(height, child.getPreferredHeight()));
                child.flowY();
            }
        } else if (valign == VAlign.STRETCH || expandable) {
            for (GuiChildControl child : controls) {
                if (child.control.isExpandableY() || valign == VAlign.STRETCH) {
                    child.setHeight(height);
                } else {
                    child.setHeight(Math.min(height, child.getPreferredHeight()));
                }
                child.setY(0);
                child.flowY();
            }
        } else if (valign == VAlign.BOTTOM) {
            for (GuiChildControl child : controls) {
                child.setHeight(Math.min(height, child.getPreferredHeight()));
                child.setY(height - child.getHeight());
                child.flowY();
            }
        } else {
            for (GuiChildControl child : controls) {
                child.setHeight(Math.min(height, child.getPreferredHeight()));
                child.setY((int)Math.ceil((double)height / 2.0 - (double)child.getHeight() / 2.0));
                child.flowY();
            }
        }
    }
}

