/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.level;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.TransientEntitySectionManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.eventbus.api.Event;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.client.render.level.IRenderChunkSupplier;
import team.creative.creativecore.common.level.FakeChunkCache;
import team.creative.creativecore.common.level.IOrientatedLevel;
import team.creative.creativecore.common.level.listener.LevelBoundsListener;
import team.creative.creativecore.common.level.system.BlockUpdateLevelSystem;

public abstract class CreativeLevel
extends Level
implements IOrientatedLevel {
    public Entity parent;
    final EntityTickList tickingEntities = new EntityTickList();
    private final TransientEntitySectionManager<Entity> entityStorage = new TransientEntitySectionManager(Entity.class, (LevelCallback)new EntityCallbacks());
    @OnlyIn(value=Dist.CLIENT)
    public IRenderChunkSupplier renderChunkSupplier;
    private final Map<String, MapItemSavedData> mapData = Maps.newHashMap();
    private final Int2ObjectMap<Entity> entitiesById = new Int2ObjectOpenHashMap();
    private final List<AbstractClientPlayer> players = Lists.newArrayList();
    private final FakeChunkCache chunkSource;
    public final BlockUpdateLevelSystem blockUpdate = new BlockUpdateLevelSystem(this);
    public boolean hasChanged = false;
    public boolean preventNeighborUpdate = false;

    protected CreativeLevel(WritableLevelData worldInfo, int radius, Supplier<ProfilerFiller> supplier, boolean client, boolean debug, long seed) {
        super(worldInfo, CreativeCore.FAKE_DIMENSION_NAME, CreativeCore.FAKE_DIMENSION, supplier, client, debug, seed);
        this.chunkSource = new FakeChunkCache(this, radius);
    }

    public void registerLevelBoundListener(LevelBoundsListener listener) {
        this.blockUpdate.registerLevelBoundListener(listener);
    }

    public void m_46586_(BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.preventNeighborUpdate) {
            return;
        }
        if (this.f_46443_) {
            BlockState blockstate = this.m_8055_(pos);
            try {
                blockstate.m_60690_((Level)this, pos, blockIn, fromPos, false);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Exception while updating neighbours");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Block being updated");
                crashreportcategory.m_128165_("Source block type", () -> {
                    try {
                        return String.format("ID #%s (%s // %s)", blockIn.getRegistryName(), blockIn.m_7705_(), blockIn.getClass().getCanonicalName());
                    }
                    catch (Throwable throwable1) {
                        return "ID #" + blockIn.getRegistryName();
                    }
                });
                CrashReportCategory.m_178950_((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)this, (BlockPos)pos, (BlockState)blockstate);
                throw new ReportedException(crashreport);
            }
        } else {
            super.m_46586_(pos, blockIn, fromPos);
        }
    }

    public void m_46590_(BlockPos pos, Block block, Direction facing) {
        if (this.preventNeighborUpdate) {
            return;
        }
        super.m_46590_(pos, block, facing);
    }

    public void m_46672_(BlockPos pos, Block block) {
        if (this.preventNeighborUpdate) {
            return;
        }
        super.m_46672_(pos, block);
    }

    public BlockPos transformToRealWorld(BlockPos pos) {
        return this.getOrigin().transformPointToWorld(pos);
    }

    public ChunkSource m_7726_() {
        return this.chunkSource;
    }

    public void unload(LevelChunk chunk) {
        chunk.m_187957_();
        this.chunkSource.m_7827_().m_141940_(chunk.m_7697_(), false);
    }

    public void onChunkLoaded(ChunkPos pos) {
    }

    public List<? extends Player> m_6907_() {
        return this.players;
    }

    public void m_7260_(BlockPos pos, BlockState state, BlockState p_184138_3_, int p_184138_4_) {
        this.hasChanged = true;
    }

    public Entity m_6815_(int id) {
        return (Entity)this.entitiesById.get(id);
    }

    public LevelEntityGetter<Entity> m_142646_() {
        return this.entityStorage.m_157645_();
    }

    public Iterable<Entity> loadedEntities() {
        return this.m_142646_().m_142273_();
    }

    public String m_46464_() {
        return "Chunks[C] W: " + this.chunkSource.m_6754_() + " E: " + this.entityStorage.m_157664_();
    }

    public MapItemSavedData m_7489_(String data) {
        return this.mapData.get(data);
    }

    public void m_142325_(String id, MapItemSavedData data) {
        this.mapData.put(id, data);
    }

    public int m_7354_() {
        return 0;
    }

    public void m_6801_(int p_175715_1_, BlockPos p_175715_2_, int p_175715_3_) {
    }

    public LevelTickAccess<Block> m_183326_() {
        return BlackholeTickAccess.m_193145_();
    }

    public LevelTickAccess<Fluid> m_183324_() {
        return BlackholeTickAccess.m_193145_();
    }

    final class EntityCallbacks
    implements LevelCallback<Entity> {
        EntityCallbacks() {
        }

        public void onCreated(Entity p_171696_) {
        }

        public void onDestroyed(Entity p_171700_) {
        }

        public void onTickingStart(Entity p_171704_) {
            CreativeLevel.this.tickingEntities.m_156908_(p_171704_);
        }

        public void onTickingEnd(Entity p_171708_) {
            CreativeLevel.this.tickingEntities.m_156912_(p_171708_);
        }

        public void onTrackingStart(Entity p_171712_) {
            if (p_171712_ instanceof AbstractClientPlayer) {
                CreativeLevel.this.players.add((AbstractClientPlayer)p_171712_);
            }
        }

        public void onTrackingEnd(Entity p_171716_) {
            p_171716_.m_19877_();
            CreativeLevel.this.players.remove(p_171716_);
            p_171716_.onRemovedFromWorld();
            MinecraftForge.EVENT_BUS.post((Event)new EntityLeaveWorldEvent(p_171716_, (Level)CreativeLevel.this));
        }
    }
}

