/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.network;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import team.creative.creativecore.common.network.CanBeNull;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.Vec3f;

public class CreativeFieldParserEntry {
    private static final Gson GSON = new Gson();
    public final Field field;
    public boolean nullable;
    public final CreativeFieldParser parser;
    private static final List<CreativeFieldParserSpecial> specialParsers = new ArrayList<CreativeFieldParserSpecial>();
    private static final HashMap<Class<?>, CreativeFieldParser> parsers = new HashMap();

    public CreativeFieldParserEntry(Field field, CreativeFieldParser parser) {
        this.field = field;
        this.nullable = field.isAnnotationPresent(CanBeNull.class);
        this.parser = parser;
    }

    public void write(CreativePacket packet, FriendlyByteBuf buffer) {
        try {
            Object content = this.field.get(packet);
            if (this.nullable) {
                buffer.writeBoolean(content != null);
            }
            if (content != null) {
                this.parser.write(content, this.field.getType(), this.field.getGenericType(), buffer);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public void read(CreativePacket packet, FriendlyByteBuf buffer) {
        try {
            Object content = this.nullable && !buffer.readBoolean() ? null : this.parser.read(this.field.getType(), this.field.getGenericType(), buffer);
            this.field.set(packet, content);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static <T> void registerParser(Class<T> classType, CreativeFieldParser<T> parser) {
        parsers.put(classType, parser);
    }

    public static <T> void registerSpecialParser(CreativeFieldParserSpecial parser) {
        specialParsers.add(parser);
    }

    public static CreativeFieldParserEntry getParser(Field field) {
        CreativeFieldParser parser = CreativeFieldParserEntry.getParser(field.getType(), field.getGenericType());
        if (parser != null) {
            return new CreativeFieldParserEntry(field, parser);
        }
        return null;
    }

    public static CreativeFieldParser getParser(Class classType, Type genericType) {
        try {
            CreativeFieldParser parser = parsers.get(classType);
            if (parser != null) {
                return parser;
            }
            for (int i = 0; i < specialParsers.size(); ++i) {
                if (!CreativeFieldParserEntry.specialParsers.get((int)i).predicate.test(classType, genericType)) continue;
                return specialParsers.get(i);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return null;
    }

    static {
        SimpleFieldParser<Boolean> booleanParser = new SimpleFieldParser<Boolean>(){

            @Override
            protected void writeContent(Boolean content, FriendlyByteBuf buffer) {
                buffer.writeBoolean(content.booleanValue());
            }

            @Override
            protected Boolean readContent(FriendlyByteBuf buffer) {
                return buffer.readBoolean();
            }
        };
        CreativeFieldParserEntry.registerParser(Boolean.TYPE, booleanParser);
        CreativeFieldParserEntry.registerParser(Boolean.class, booleanParser);
        SimpleFieldParser<Byte> byteParser = new SimpleFieldParser<Byte>(){

            @Override
            protected void writeContent(Byte content, FriendlyByteBuf buffer) {
                buffer.writeByte((int)content.byteValue());
            }

            @Override
            protected Byte readContent(FriendlyByteBuf buffer) {
                return buffer.readByte();
            }
        };
        CreativeFieldParserEntry.registerParser(Byte.TYPE, byteParser);
        CreativeFieldParserEntry.registerParser(Byte.class, byteParser);
        SimpleFieldParser<Short> shortParser = new SimpleFieldParser<Short>(){

            @Override
            protected void writeContent(Short content, FriendlyByteBuf buffer) {
                buffer.writeShort((int)content.shortValue());
            }

            @Override
            protected Short readContent(FriendlyByteBuf buffer) {
                return buffer.readShort();
            }
        };
        CreativeFieldParserEntry.registerParser(Short.TYPE, shortParser);
        CreativeFieldParserEntry.registerParser(Short.class, shortParser);
        SimpleFieldParser<Integer> intParser = new SimpleFieldParser<Integer>(){

            @Override
            protected void writeContent(Integer content, FriendlyByteBuf buffer) {
                buffer.writeInt(content.intValue());
            }

            @Override
            protected Integer readContent(FriendlyByteBuf buffer) {
                return buffer.readInt();
            }
        };
        CreativeFieldParserEntry.registerParser(Integer.TYPE, intParser);
        CreativeFieldParserEntry.registerParser(Integer.class, intParser);
        SimpleFieldParser<Long> longParser = new SimpleFieldParser<Long>(){

            @Override
            protected void writeContent(Long content, FriendlyByteBuf buffer) {
                buffer.writeLong(content.longValue());
            }

            @Override
            protected Long readContent(FriendlyByteBuf buffer) {
                return buffer.readLong();
            }
        };
        CreativeFieldParserEntry.registerParser(Long.TYPE, longParser);
        CreativeFieldParserEntry.registerParser(Long.class, longParser);
        SimpleFieldParser<Float> floatParser = new SimpleFieldParser<Float>(){

            @Override
            protected void writeContent(Float content, FriendlyByteBuf buffer) {
                buffer.writeFloat(content.floatValue());
            }

            @Override
            protected Float readContent(FriendlyByteBuf buffer) {
                return Float.valueOf(buffer.readFloat());
            }
        };
        CreativeFieldParserEntry.registerParser(Float.TYPE, floatParser);
        CreativeFieldParserEntry.registerParser(Float.class, floatParser);
        SimpleFieldParser<Double> doubleParser = new SimpleFieldParser<Double>(){

            @Override
            protected void writeContent(Double content, FriendlyByteBuf buffer) {
                buffer.writeDouble(content.doubleValue());
            }

            @Override
            protected Double readContent(FriendlyByteBuf buffer) {
                return buffer.readDouble();
            }
        };
        CreativeFieldParserEntry.registerParser(Double.TYPE, doubleParser);
        CreativeFieldParserEntry.registerParser(Double.class, doubleParser);
        CreativeFieldParserEntry.registerParser(BlockPos.class, new SimpleFieldParser<BlockPos>(){

            @Override
            protected void writeContent(BlockPos content, FriendlyByteBuf buffer) {
                buffer.m_130064_(content);
            }

            @Override
            protected BlockPos readContent(FriendlyByteBuf buffer) {
                return buffer.m_130135_();
            }
        });
        CreativeFieldParserEntry.registerParser(String.class, new SimpleFieldParser<String>(){

            @Override
            protected void writeContent(String content, FriendlyByteBuf buffer) {
                buffer.m_130070_(content);
            }

            @Override
            protected String readContent(FriendlyByteBuf buffer) {
                return buffer.m_130136_(Short.MAX_VALUE);
            }
        });
        CreativeFieldParserEntry.registerParser(Component.class, new SimpleFieldParser<Component>(){

            @Override
            protected void writeContent(Component content, FriendlyByteBuf buffer) {
                buffer.m_130083_(content);
            }

            @Override
            protected Component readContent(FriendlyByteBuf buffer) {
                return buffer.m_130238_();
            }
        });
        CreativeFieldParserEntry.registerParser(CompoundTag.class, new SimpleFieldParser<CompoundTag>(){

            @Override
            protected void writeContent(CompoundTag content, FriendlyByteBuf buffer) {
                buffer.m_130079_(content);
            }

            @Override
            protected CompoundTag readContent(FriendlyByteBuf buffer) {
                return buffer.m_130260_();
            }
        });
        CreativeFieldParserEntry.registerParser(ItemStack.class, new SimpleFieldParser<ItemStack>(){

            @Override
            protected void writeContent(ItemStack content, FriendlyByteBuf buffer) {
                buffer.m_130055_(content);
            }

            @Override
            protected ItemStack readContent(FriendlyByteBuf buffer) {
                return buffer.m_130267_();
            }
        });
        CreativeFieldParserEntry.registerParser(ResourceLocation.class, new SimpleFieldParser<ResourceLocation>(){

            @Override
            protected void writeContent(ResourceLocation content, FriendlyByteBuf buffer) {
                buffer.m_130085_(content);
            }

            @Override
            protected ResourceLocation readContent(FriendlyByteBuf buffer) {
                return buffer.m_130281_();
            }
        });
        CreativeFieldParserEntry.registerParser(BlockState.class, new SimpleFieldParser<BlockState>(){

            @Override
            protected void writeContent(BlockState content, FriendlyByteBuf buffer) {
                buffer.writeInt(Block.m_49956_((BlockState)content));
            }

            @Override
            protected BlockState readContent(FriendlyByteBuf buffer) {
                return Block.m_49803_((int)buffer.readInt());
            }
        });
        CreativeFieldParserEntry.registerParser(Vector3d.class, new SimpleFieldParser<Vector3d>(){

            @Override
            protected void writeContent(Vector3d content, FriendlyByteBuf buffer) {
                buffer.writeDouble(content.f_86214_);
                buffer.writeDouble(content.f_86215_);
                buffer.writeDouble(content.f_86216_);
            }

            @Override
            protected Vector3d readContent(FriendlyByteBuf buffer) {
                return new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            }
        });
        CreativeFieldParserEntry.registerParser(Vec3.class, new SimpleFieldParser<Vec3>(){

            @Override
            protected void writeContent(Vec3 content, FriendlyByteBuf buffer) {
                buffer.writeDouble(content.f_82479_);
                buffer.writeDouble(content.f_82480_);
                buffer.writeDouble(content.f_82481_);
            }

            @Override
            protected Vec3 readContent(FriendlyByteBuf buffer) {
                return new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            }
        });
        CreativeFieldParserEntry.registerParser(Vec3d.class, new SimpleFieldParser<Vec3d>(){

            @Override
            protected void writeContent(Vec3d content, FriendlyByteBuf buffer) {
                buffer.writeDouble(content.x);
                buffer.writeDouble(content.y);
                buffer.writeDouble(content.z);
            }

            @Override
            protected Vec3d readContent(FriendlyByteBuf buffer) {
                return new Vec3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            }
        });
        CreativeFieldParserEntry.registerParser(Vec3f.class, new SimpleFieldParser<Vec3f>(){

            @Override
            protected void writeContent(Vec3f content, FriendlyByteBuf buffer) {
                buffer.writeFloat(content.x);
                buffer.writeFloat(content.y);
                buffer.writeFloat(content.z);
            }

            @Override
            protected Vec3f readContent(FriendlyByteBuf buffer) {
                return new Vec3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            }
        });
        CreativeFieldParserEntry.registerParser(Vector3f.class, new SimpleFieldParser<Vector3f>(){

            @Override
            protected void writeContent(Vector3f content, FriendlyByteBuf buffer) {
                buffer.writeFloat(content.m_122239_());
                buffer.writeFloat(content.m_122260_());
                buffer.writeFloat(content.m_122269_());
            }

            @Override
            protected Vector3f readContent(FriendlyByteBuf buffer) {
                return new Vector3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            }
        });
        CreativeFieldParserEntry.registerParser(UUID.class, new SimpleFieldParser<UUID>(){

            @Override
            protected void writeContent(UUID content, FriendlyByteBuf buffer) {
                buffer.m_130070_(content.toString());
            }

            @Override
            protected UUID readContent(FriendlyByteBuf buffer) {
                return UUID.fromString(buffer.m_130136_(Short.MAX_VALUE));
            }
        });
        CreativeFieldParserEntry.registerParser(JsonObject.class, new SimpleFieldParser<JsonObject>(){

            @Override
            protected void writeContent(JsonObject content, FriendlyByteBuf buffer) {
                buffer.m_130070_(content.toString());
            }

            @Override
            protected JsonObject readContent(FriendlyByteBuf buffer) {
                return (JsonObject)GSON.fromJson(buffer.m_130136_(Short.MAX_VALUE), JsonObject.class);
            }
        });
        CreativeFieldParserEntry.registerSpecialParser(new CreativeFieldParserSpecial((x, y) -> x.isArray()){

            @Override
            public void write(Object content, Class classType, Type genericType, FriendlyByteBuf buffer) {
                Class<?> subClass = classType.getComponentType();
                CreativeFieldParser subParser = CreativeFieldParserEntry.getParser(subClass, null);
                int length = Array.getLength(content);
                buffer.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    subParser.write(Array.get(content, i), subClass, null, buffer);
                }
            }

            @Override
            public Object read(Class classType, Type genericType, FriendlyByteBuf buffer) {
                int length = buffer.readInt();
                Class<?> subClass = classType.getComponentType();
                CreativeFieldParser subParser = CreativeFieldParserEntry.getParser(subClass, null);
                Object object = Array.newInstance(subClass, length);
                for (int i = 0; i < length; ++i) {
                    Array.set(object, i, subParser.read(subClass, null, buffer));
                }
                return object;
            }
        });
        CreativeFieldParserEntry.registerSpecialParser(new CreativeFieldParserSpecial((x, y) -> x.equals(ArrayList.class) || x.equals(List.class)){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void write(Object content, Class classType, Type genericType, FriendlyByteBuf buffer) {
                Type subType;
                if (!(genericType instanceof ParameterizedType)) throw new RuntimeException("Missing generic type");
                Type[] types = ((ParameterizedType)genericType).getActualTypeArguments();
                if (types.length != 1) throw new RuntimeException("Invalid generic type");
                Class subClass = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                CreativeFieldParser subParser = CreativeFieldParserEntry.getParser(subClass, subType = types[0]);
                if (subParser == null) {
                    throw new RuntimeException("Invalid class type " + classType.getComponentType().getName());
                }
                int length = ((List)content).size();
                buffer.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    subParser.write(((List)content).get(i), subClass, subType, buffer);
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Object read(Class classType, Type genericType, FriendlyByteBuf buffer) {
                Type subType;
                if (!(genericType instanceof ParameterizedType)) throw new RuntimeException("Missing generic type");
                Type[] types = ((ParameterizedType)genericType).getActualTypeArguments();
                if (types.length != 1) throw new RuntimeException("Invalid generic type");
                Class subClass = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                CreativeFieldParser subParser = CreativeFieldParserEntry.getParser(subClass, subType = types[0]);
                if (subParser == null) {
                    throw new RuntimeException("Invalid class type " + classType.getComponentType().getName());
                }
                int length = buffer.readInt();
                ArrayList list = new ArrayList(length);
                for (int j = 0; j < length; ++j) {
                    list.add(subParser.read(subClass, subType, buffer));
                }
                return list;
            }
        });
        CreativeFieldParserEntry.registerSpecialParser(new CreativeFieldParserSpecial((x, y) -> x.isEnum()){

            @Override
            public void write(Object content, Class classType, Type genericType, FriendlyByteBuf buffer) {
                buffer.m_130068_((Enum)content);
            }

            @Override
            public Object read(Class classType, Type genericType, FriendlyByteBuf buffer) {
                return buffer.m_130066_(classType);
            }
        });
    }

    public static abstract class CreativeFieldParser<T> {
        public abstract void write(T var1, Class var2, Type var3, FriendlyByteBuf var4);

        public abstract T read(Class var1, Type var2, FriendlyByteBuf var3);
    }

    public static abstract class CreativeFieldParserSpecial
    extends CreativeFieldParser<Object> {
        public final BiPredicate<Class, Type> predicate;

        public CreativeFieldParserSpecial(BiPredicate<Class, Type> predicate) {
            this.predicate = predicate;
        }
    }

    @FunctionalInterface
    public static interface BiPredicate<T, V> {
        public boolean test(T var1, V var2);
    }

    public static abstract class SimpleFieldParser<T>
    extends CreativeFieldParser<T> {
        protected abstract void writeContent(T var1, FriendlyByteBuf var2);

        @Override
        public void write(T content, Class classType, Type genericType, FriendlyByteBuf buffer) {
            this.writeContent(content, buffer);
        }

        protected abstract T readContent(FriendlyByteBuf var1);

        @Override
        public T read(Class classType, Type genericType, FriendlyByteBuf buffer) {
            return this.readContent(buffer);
        }
    }
}

