/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.registry;

import java.util.Collection;
import java.util.HashMap;

public class NamedHandlerRegistry<T> {
    private HashMap<String, T> handlers = new HashMap();
    private HashMap<T, String> handlersInv = new HashMap();
    private T defaultHandler;
    private boolean allowOverwrite = false;

    public NamedHandlerRegistry(T handler) {
        this.defaultHandler = handler;
    }

    public NamedHandlerRegistry<T> allowOverwrite() {
        this.allowOverwrite = true;
        return this;
    }

    public T getDefault() {
        return this.defaultHandler;
    }

    public void register(String id, T handler) {
        if (!this.allowOverwrite && this.handlers.containsKey(id)) {
            throw new IllegalArgumentException("'" + id + "' already exists");
        }
        this.handlers.put(id, handler);
        this.handlersInv.put(handler, id);
    }

    public String getId(T type) {
        return this.handlersInv.get(type);
    }

    public T get(String id) {
        return this.handlers.getOrDefault(id, this.defaultHandler);
    }

    public Collection<String> keys() {
        return this.handlers.keySet();
    }
}

