/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RequestTag
implements IDeliverable {
    private static final Set<TypeToken<?>> TYPE_TOKENS = ReflectionUtils.getSuperClasses(TypeToken.of(RequestTag.class)).stream().filter(type -> !type.equals(TypeConstants.OBJECT)).collect(Collectors.toSet());
    private static final String NBT_TAG = "Tag";
    private static final String NBT_RESULT = "Result";
    private static final String NBT_COUNT = "Count";
    private static final String NBT_MINCOUNT = "MinCount";
    @NotNull
    private final net.minecraft.tags.Tag<Item> theTag;
    @NotNull
    private ItemStack result;
    private int count;
    private int minCount;

    public RequestTag(@NotNull net.minecraft.tags.Tag<Item> tag, int count) {
        this(tag, count, count);
    }

    public RequestTag(@NotNull net.minecraft.tags.Tag<Item> tag, int count, int minCount) {
        this(tag, ItemStackUtils.EMPTY, count, minCount);
    }

    public RequestTag(@NotNull net.minecraft.tags.Tag<Item> tag, @NotNull ItemStack result, int count, int minCount) {
        this.theTag = tag;
        this.result = result;
        this.count = count;
        this.minCount = minCount;
    }

    @Override
    public boolean matches(@NotNull ItemStack stack) {
        return stack.m_150922_(this.theTag);
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public int getMinimumCount() {
        return this.minCount;
    }

    @Override
    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    @NotNull
    public net.minecraft.tags.Tag<Item> getTag() {
        return this.theTag;
    }

    @Override
    public void setResult(@NotNull ItemStack result) {
        this.result = result;
    }

    @Override
    public IDeliverable copyWithCount(int newCount) {
        return new RequestTag(this.theTag, this.result, newCount, this.minCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestTag tag1 = (RequestTag)o;
        return this.getCount() == tag1.getCount() && this.getMinimumCount() == tag1.getMinimumCount() && this.getTag().equals(tag1.getTag()) && this.getResult().equals(tag1.getResult());
    }

    public int hashCode() {
        int result1 = ItemTags.m_13193_().m_7473_(this.getTag()).toString().hashCode();
        result1 = 31 * result1 + this.getResult().hashCode();
        return result1;
    }

    public static CompoundTag serialize(IFactoryController controller, RequestTag input) {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_(NBT_TAG, ItemTags.m_13193_().m_7473_(input.getTag()).toString());
        if (!ItemStackUtils.isEmpty(input.getResult()).booleanValue()) {
            compound.m_128365_(NBT_RESULT, (Tag)input.getResult().serializeNBT());
        }
        compound.m_128405_(NBT_COUNT, input.getCount());
        compound.m_128405_(NBT_MINCOUNT, input.getMinimumCount());
        return compound;
    }

    public static void serialize(IFactoryController controller, FriendlyByteBuf buffer, RequestTag input) {
        buffer.m_130070_(ItemTags.m_13193_().m_7473_(input.getTag()).toString());
        buffer.writeBoolean(ItemStackUtils.isEmpty(input.getResult()) == false);
        if (!ItemStackUtils.isEmpty(input.getResult()).booleanValue()) {
            buffer.m_130055_(input.getResult());
        }
        buffer.writeInt(input.getCount());
        buffer.writeInt(input.getMinimumCount());
    }

    public static RequestTag deserialize(IFactoryController controller, FriendlyByteBuf buffer) {
        net.minecraft.tags.Tag theTag = ItemTags.m_13193_().m_13404_(ResourceLocation.m_135820_((String)buffer.m_130136_(Short.MAX_VALUE)));
        ItemStack result = buffer.readBoolean() ? buffer.m_130267_() : ItemStack.f_41583_;
        int count = buffer.readInt();
        int minCount = buffer.readInt();
        return new RequestTag((net.minecraft.tags.Tag<Item>)theTag, result, count, minCount);
    }

    public static RequestTag deserialize(IFactoryController controller, CompoundTag compound) {
        int count;
        Tag.Named theTag = ItemTags.m_13194_((String)compound.m_128461_(NBT_TAG));
        ItemStack result = compound.m_128431_().contains(NBT_RESULT) ? ItemStackUtils.deserializeFromNBT(compound.m_128469_(NBT_RESULT)) : ItemStackUtils.EMPTY;
        int minCount = count = compound.m_128451_("size");
        if (compound.m_128431_().contains(NBT_COUNT)) {
            count = compound.m_128451_(NBT_COUNT);
            minCount = compound.m_128451_(NBT_MINCOUNT);
        }
        return new RequestTag((net.minecraft.tags.Tag<Item>)theTag, result, count, minCount);
    }

    @Override
    public Set<TypeToken<?>> getSuperClasses() {
        return TYPE_TOKENS;
    }
}

