/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity;

import com.minecolonies.api.entity.ICustomAttackSound;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.items.ModItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpearEntity
extends ThrownTrident
implements ICustomAttackSound {
    private static final int MAX_TIME_ALIVE = 1200;
    public static final int BASE_DAMAGE = 8;
    public static final String NBT_WEAPON = "Weapon";
    public static final String NBT_DEALT_DAMAGE = "DealtDamage";
    protected ItemStack weapon = new ItemStack((ItemLike)ModItems.spear);
    private boolean dealtDamage;

    public SpearEntity(EntityType<? extends ThrownTrident> type, Level world) {
        super(type, world);
        this.m_5654_();
    }

    public SpearEntity(Level world, LivingEntity thrower, ItemStack thrownWeapon) {
        super(ModEntities.SPEAR, world);
        this.weapon = thrownWeapon.m_41777_();
        this.m_5602_((Entity)thrower);
        this.m_5654_();
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @NotNull
    public ItemStack m_7941_() {
        return this.weapon.m_41777_();
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 startVec, Vec3 endVec) {
        return this.dealtDamage ? null : super.m_6351_(startVec, endVec);
    }

    protected void m_5790_(EntityHitResult result) {
        Entity ownerEntity;
        Entity targetEntity = result.m_82443_();
        float damageAmount = 8.0f;
        if (targetEntity instanceof LivingEntity) {
            damageAmount += EnchantmentHelper.m_44833_((ItemStack)this.weapon, (MobType)((LivingEntity)targetEntity).m_6336_());
        }
        DamageSource damageSource = new IndirectEntityDamageSource("spear", (Entity)this, (Entity)((ownerEntity = this.m_37282_()) == null ? this : ownerEntity)).m_19366_();
        this.dealtDamage = true;
        if (targetEntity.m_6469_(damageSource, damageAmount)) {
            if (targetEntity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (targetEntity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)targetEntity;
                if (ownerEntity instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingEntity, (Entity)ownerEntity);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)ownerEntity), (Entity)livingEntity);
                }
                this.m_7761_(livingEntity);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        this.m_5496_(SoundEvents.f_12514_, 1.0f, 1.0f);
    }

    @NotNull
    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128425_(NBT_WEAPON, 10)) {
            this.weapon = ItemStack.m_41712_((CompoundTag)nbt.m_128469_(NBT_WEAPON));
        }
        this.dealtDamage = nbt.m_128471_(NBT_DEALT_DAMAGE);
    }

    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128365_(NBT_WEAPON, (Tag)this.weapon.m_41739_(new CompoundTag()));
        nbt.m_128379_(NBT_DEALT_DAMAGE, this.dealtDamage);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 1200) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void m_6901_() {
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED) {
            super.m_6901_();
        }
    }

    protected float m_6882_() {
        return 0.9f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    @Override
    public SoundEvent getAttackSound() {
        return SoundEvents.f_12520_;
    }
}

