/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.inventory;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.ItemStackUtils;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryCitizen
implements IItemHandlerModifiable,
Nameable {
    private static final int NO_SLOT = -1;
    private static final int DEFAULT_INV_SIZE = 27;
    private static final int ROW_SIZE = 9;
    private int freeSlots = 27;
    private NonNullList<ItemStack> mainInventory = NonNullList.m_122780_((int)27, (Object)ItemStackUtils.EMPTY);
    private int mainItem = -1;
    private int offhandItem = -1;
    private String customName;
    private ICitizenData citizen;

    public InventoryCitizen(String title, boolean localeEnabled, ICitizenData citizen) {
        this.citizen = citizen;
        if (localeEnabled) {
            this.customName = title;
        }
    }

    public InventoryCitizen(String title, boolean localeEnabled) {
        if (localeEnabled) {
            this.customName = title;
        }
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public ItemStack getHeldItem(InteractionHand hand) {
        if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
            return this.getStackInSlot(this.mainItem);
        }
        return this.getStackInSlot(this.offhandItem);
    }

    public void setHeldItem(InteractionHand hand, int slot) {
        if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
            this.mainItem = slot;
        }
        this.offhandItem = slot;
    }

    public int getHeldItemSlot(InteractionHand hand) {
        if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
            return this.mainItem;
        }
        return this.offhandItem;
    }

    public int getSlots() {
        return this.mainInventory.size();
    }

    public boolean hasSpace() {
        return this.freeSlots > 0;
    }

    public boolean isEmpty() {
        return this.freeSlots == this.mainInventory.size();
    }

    public boolean isFull() {
        return this.freeSlots == 0;
    }

    private void resizeInventory(int size, int futureSize) {
        if (size < futureSize) {
            NonNullList inv = NonNullList.m_122780_((int)futureSize, (Object)ItemStackUtils.EMPTY);
            for (int i = 0; i < this.mainInventory.size(); ++i) {
                inv.set(i, (Object)((ItemStack)this.mainInventory.get(i)));
            }
            this.mainInventory = inv;
            this.freeSlots += futureSize - size;
        }
    }

    @NotNull
    public Component m_7755_() {
        return new TranslatableComponent(this.m_8077_() ? this.customName : "citizen.inventory");
    }

    public boolean m_8077_() {
        return this.customName != null;
    }

    @NotNull
    public ItemStack getStackInSlot(int index) {
        if (index == -1) {
            return ItemStack.f_41583_;
        }
        if (index >= this.mainInventory.size()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.mainInventory.get(index);
    }

    public <T extends LivingEntity> boolean damageInventoryItem(int slot, int amount, @Nullable T entityIn, @Nullable Consumer<T> onBroken) {
        ItemStack stack = (ItemStack)this.mainInventory.get(slot);
        if (!ItemStackUtils.isEmpty(stack).booleanValue()) {
            stack.m_41622_(stack.m_41720_().damageItem(stack, amount, entityIn, onBroken), entityIn, onBroken);
            if (ItemStackUtils.isEmpty(stack).booleanValue()) {
                ++this.freeSlots;
            }
        }
        return ItemStackUtils.isEmpty(stack);
    }

    public boolean shrinkInventoryItem(int slot) {
        ItemStack stack = (ItemStack)this.mainInventory.get(slot);
        if (!ItemStackUtils.isEmpty(stack).booleanValue()) {
            stack.m_41764_(stack.m_41613_() - 1);
            if (ItemStackUtils.isEmpty(stack).booleanValue()) {
                ++this.freeSlots;
            }
        }
        return ItemStackUtils.isEmpty(stack);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return stack;
        }
        ItemStack copy = stack.m_41777_();
        ItemStack inSlot = (ItemStack)this.mainInventory.get(slot);
        if (inSlot.m_41613_() >= inSlot.m_41741_() || !inSlot.m_41619_() && !ItemStackUtils.compareItemStacksIgnoreStackSize(inSlot, copy).booleanValue()) {
            return copy;
        }
        if (inSlot.m_41619_()) {
            if (!simulate) {
                this.markDirty();
                --this.freeSlots;
                this.mainInventory.set(slot, (Object)copy);
                return ItemStack.f_41583_;
            }
            return ItemStack.f_41583_;
        }
        int avail = inSlot.m_41741_() - inSlot.m_41613_();
        if (avail >= copy.m_41613_()) {
            if (!simulate) {
                this.markDirty();
                inSlot.m_41764_(inSlot.m_41613_() + copy.m_41613_());
            }
            return ItemStack.f_41583_;
        }
        if (!simulate) {
            this.markDirty();
            inSlot.m_41764_(inSlot.m_41613_() + avail);
        }
        copy.m_41764_(copy.m_41613_() - avail);
        return copy;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack inSlot = (ItemStack)this.mainInventory.get(slot);
        if (inSlot.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (amount >= inSlot.m_41613_()) {
            if (!simulate) {
                this.markDirty();
                ++this.freeSlots;
                this.mainInventory.set(slot, (Object)ItemStack.f_41583_);
            }
            return inSlot;
        }
        ItemStack copy = inSlot.m_41777_();
        copy.m_41764_(amount);
        if (!simulate) {
            this.markDirty();
            inSlot.m_41764_(inSlot.m_41613_() - amount);
            if (ItemStackUtils.isEmpty(inSlot).booleanValue()) {
                ++this.freeSlots;
            }
        }
        return copy;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public void markDirty() {
        if (this.citizen != null) {
            this.citizen.markDirty();
        }
    }

    @NotNull
    public Component m_5446_() {
        return this.m_8077_() ? new TextComponent(this.customName) : new TextComponent(this.citizen.getName());
    }

    public ListTag write(ListTag nbtTagList) {
        double researchEffect;
        if (this.citizen != null && this.citizen.getColony() != null && (researchEffect = this.citizen.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.CITIZEN_INV_SLOTS)) > 0.0 && (double)this.mainInventory.size() < 27.0 + researchEffect) {
            this.resizeInventory(this.mainInventory.size(), (int)(27.0 + researchEffect));
        }
        CompoundTag sizeNbt = new CompoundTag();
        sizeNbt.m_128405_("tagSIze", this.mainInventory.size());
        nbtTagList.add((Object)sizeNbt);
        this.freeSlots = this.mainInventory.size();
        for (int i = 0; i < this.mainInventory.size(); ++i) {
            if (((ItemStack)this.mainInventory.get(i)).m_41619_()) continue;
            CompoundTag compoundNBT = new CompoundTag();
            compoundNBT.m_128344_("Slot", (byte)i);
            ((ItemStack)this.mainInventory.get(i)).m_41739_(compoundNBT);
            nbtTagList.add((Object)compoundNBT);
            --this.freeSlots;
        }
        return nbtTagList;
    }

    public void read(ListTag nbtTagList) {
        if (this.mainInventory.size() < nbtTagList.m_128728_(0).m_128451_("tagSIze")) {
            int size = nbtTagList.m_128728_(0).m_128451_("tagSIze");
            size -= size % 9;
            this.mainInventory = NonNullList.m_122780_((int)size, (Object)ItemStackUtils.EMPTY);
        }
        this.freeSlots = this.mainInventory.size();
        for (int i = 1; i < nbtTagList.size(); ++i) {
            CompoundTag compoundNBT = nbtTagList.m_128728_(i);
            int j = compoundNBT.m_128445_("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundNBT);
            if (itemstack.m_41619_() || j >= this.mainInventory.size()) continue;
            this.mainInventory.set(j, (Object)itemstack);
            --this.freeSlots;
        }
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (!ItemStackUtils.isEmpty(stack).booleanValue()) {
            if (ItemStackUtils.isEmpty((ItemStack)this.mainInventory.get(slot)).booleanValue()) {
                --this.freeSlots;
            }
        } else if (!ItemStackUtils.isEmpty((ItemStack)this.mainInventory.get(slot)).booleanValue()) {
            ++this.freeSlots;
        }
        this.mainInventory.set(slot, (Object)stack);
    }
}

