/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.inventory.container;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.inventory.ModContainers;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.ItemStackUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ContainerBuildingInventory
extends AbstractContainerMenu {
    private final IItemHandler buildingInventory;
    private final TileEntityColonyBuilding tileEntityColonyBuilding;
    private final int inventorySize;

    public static ContainerBuildingInventory fromFriendlyByteBuf(int windowId, Inventory inv, FriendlyByteBuf packetBuffer) {
        int colonyId = packetBuffer.m_130242_();
        BlockPos tePos = packetBuffer.m_130135_();
        return new ContainerBuildingInventory(windowId, inv, colonyId, tePos);
    }

    public ContainerBuildingInventory(int windowId, final Inventory inv, final int colonyId, final BlockPos pos) {
        super(ModContainers.buildingInv, windowId);
        int i;
        this.tileEntityColonyBuilding = (TileEntityColonyBuilding)inv.f_35978_.f_19853_.m_7702_(pos);
        this.buildingInventory = this.tileEntityColonyBuilding.getInventory();
        int size = this.buildingInventory.getSlots();
        this.inventorySize = size / 9;
        int columns = this.inventorySize <= 8 ? 9 : size / 8 + 1;
        int extraOffset = this.inventorySize <= 8 ? 0 : 2;
        int index = 0;
        for (int j = 0; j < Math.min(this.inventorySize, 8); ++j) {
            for (int k = 0; k < columns; ++k) {
                if (index >= size) continue;
                this.m_38897_((Slot)new SlotItemHandler(this.buildingInventory, index, 8 + k * 18, 18 + j * 18){

                    public void m_5852_(ItemStack stack) {
                        IColony colony;
                        IBuilding building;
                        super.m_5852_(stack);
                        if (!inv.f_35978_.f_19853_.f_46443_ && !ItemStackUtils.isEmpty(stack).booleanValue() && (building = (colony = IColonyManager.getInstance().getColonyByWorld(colonyId, inv.f_35978_.f_19853_)).getBuildingManager().getBuilding(pos)) != null) {
                            building.overruleNextOpenRequestWithStack(stack);
                        }
                    }
                });
                ++index;
            }
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inv, j + i * 9 + 9, 8 + j * 18, 30 + extraOffset + 18 * Math.min(this.inventorySize, 8) + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inv, i, 8 + i * 18, 88 + extraOffset + 18 * Math.min(this.inventorySize, 8)));
        }
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot == null || !slot.m_6657_()) {
            return ItemStackUtils.EMPTY;
        }
        ItemStack stackCopy = slot.m_7993_().m_41777_();
        int maxIndex = this.inventorySize * 9;
        if (index < maxIndex ? !this.m_38903_(stackCopy, maxIndex, this.f_38839_.size(), true) : !this.m_38903_(stackCopy, 0, maxIndex, false)) {
            return ItemStackUtils.EMPTY;
        }
        if (ItemStackUtils.getSize(stackCopy) == 0) {
            slot.m_5852_(ItemStackUtils.EMPTY);
        } else {
            slot.m_5852_(stackCopy);
        }
        return stackCopy;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
    }

    public boolean m_6875_(@NotNull Player playerIn) {
        return this.tileEntityColonyBuilding.isUsableByPlayer(playerIn);
    }

    public int getSize() {
        return this.inventorySize;
    }
}

