/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.inventory.container;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.inventory.ModContainers;
import com.minecolonies.api.util.ItemStackUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ContainerCitizenInventory
extends AbstractContainerMenu {
    private final Inventory playerInventory;
    private final int inventorySize;
    private String displayName;

    public static ContainerCitizenInventory fromFriendlyByteBuf(int windowId, Inventory inv, FriendlyByteBuf packetBuffer) {
        int colonyId = packetBuffer.m_130242_();
        int citizenId = packetBuffer.m_130242_();
        return new ContainerCitizenInventory(windowId, inv, colonyId, citizenId);
    }

    public ContainerCitizenInventory(int windowId, final Inventory inv, final int colonyId, final int citizenId) {
        super(ModContainers.citizenInv, windowId);
        int i;
        BlockPos workBuilding;
        InventoryCitizen inventory;
        this.playerInventory = inv;
        IColony colony = inv.f_35978_.f_19853_.f_46443_ ? IColonyManager.getInstance().getColonyView(colonyId, (ResourceKey<Level>)inv.f_35978_.f_19853_.m_46472_()) : IColonyManager.getInstance().getColonyByWorld(colonyId, inv.f_35978_.f_19853_);
        if (colony == null) {
            this.inventorySize = 0;
            return;
        }
        if (inv.f_35978_.f_19853_.f_46443_) {
            data = ((IColonyView)colony).getCitizen(citizenId);
            inventory = data.getInventory();
            this.displayName = data.getName();
            workBuilding = data.getWorkBuilding();
        } else {
            data = citizenId > 0 ? colony.getCitizenManager().getCivilian(citizenId) : (ICitizenData)colony.getVisitorManager().getCivilian(citizenId);
            inventory = data.getInventory();
            this.displayName = data.getName();
            workBuilding = data.getWorkBuilding() == null ? null : data.getWorkBuilding().getID();
        }
        this.inventorySize = inventory.getSlots() / 9;
        int size = inventory.getSlots();
        int columns = this.inventorySize <= 8 ? 9 : size / 8 + 1;
        int extraOffset = this.inventorySize <= 8 ? 0 : 2;
        int index = 0;
        for (int j = 0; j < Math.min(this.inventorySize, 8); ++j) {
            for (int k = 0; k < columns; ++k) {
                if (index >= size) continue;
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inventory, index, 8 + k * 18, 18 + j * 18){

                    public void m_5852_(@NotNull ItemStack stack) {
                        if (workBuilding != null && !ContainerCitizenInventory.this.playerInventory.f_35978_.f_19853_.f_46443_ && !ItemStackUtils.isEmpty(stack).booleanValue()) {
                            IColony colony = IColonyManager.getInstance().getColonyByWorld(colonyId, inv.f_35978_.f_19853_);
                            IBuilding building = colony.getBuildingManager().getBuilding(workBuilding);
                            ICitizenData citizenData = colony.getCitizenManager().getCivilian(citizenId);
                            building.overruleNextOpenRequestOfCitizenWithStack(citizenData, stack);
                        }
                        super.m_5852_(stack);
                    }
                });
                ++index;
            }
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)this.playerInventory, j + i * 9 + 9, 8 + j * 18, 30 + extraOffset + 18 * Math.min(this.inventorySize, 8) + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)this.playerInventory, i, 8 + i * 18, 88 + extraOffset + 18 * Math.min(this.inventorySize, 8)));
        }
    }

    @NotNull
    public ItemStack m_7648_(Player playerIn, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot == null || !slot.m_6657_()) {
            return ItemStackUtils.EMPTY;
        }
        ItemStack stackCopy = slot.m_7993_().m_41777_();
        int maxIndex = this.inventorySize * 9;
        if (index < maxIndex ? !this.m_38903_(stackCopy, maxIndex, this.f_38839_.size(), true) : !this.m_38903_(stackCopy, 0, maxIndex, false)) {
            return ItemStackUtils.EMPTY;
        }
        if (ItemStackUtils.getSize(stackCopy) == 0) {
            slot.m_5852_(ItemStackUtils.EMPTY);
        } else {
            slot.m_5852_(stackCopy);
        }
        return stackCopy;
    }

    public boolean m_6875_(@NotNull Player playerIn) {
        return true;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

