/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.tileentities;

import com.minecolonies.api.blocks.AbstractBlockMinecoloniesRack;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTileEntityRack
extends BlockEntity
implements MenuProvider {
    protected boolean single = true;
    protected BlockPos relativeNeighbor = null;
    protected boolean main = false;
    protected boolean inWarehouse = false;
    protected BlockPos buildingPos = BlockPos.f_121853_;
    protected ItemStackHandler inventory = this.createInventory(27);

    public AbstractTileEntityRack(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public abstract ItemStackHandler createInventory(int var1);

    public void updateWarehouseIfAvailable(ItemStack stack) {
        if (!(ItemStackUtils.isEmpty(stack).booleanValue() || this.f_58857_ == null || this.f_58857_.f_46443_ || !this.inWarehouse && this.buildingPos.equals((Object)BlockPos.f_121853_) || !IColonyManager.getInstance().isCoordinateInAnyColony(this.f_58857_, this.f_58858_))) {
            IBuilding building;
            IColony colony = IColonyManager.getInstance().getClosestColony(this.f_58857_, this.f_58858_);
            if (this.inWarehouse && colony != null && colony.getRequestManager() != null) {
                colony.getRequestManager().onColonyUpdate(request -> request.getRequest() instanceof IDeliverable && ((IDeliverable)request.getRequest()).matches(stack));
            } else if (!this.buildingPos.equals((Object)BlockPos.f_121853_) && (building = colony.getBuildingManager().getBuilding(this.buildingPos)) != null) {
                building.overruleNextOpenRequestWithStack(stack);
            }
        }
    }

    public abstract void setInWarehouse(Boolean var1);

    public abstract int getFreeSlots();

    public abstract boolean hasItemStack(ItemStack var1, int var2, boolean var3);

    public abstract int getCount(ItemStack var1, boolean var2, boolean var3);

    public abstract int getCount(ItemStorage var1);

    public abstract boolean hasItemStack(@NotNull Predicate<ItemStack> var1);

    public abstract boolean hasSimilarStack(@NotNull ItemStack var1);

    public abstract void upgradeRackSize();

    public void setBuildingPos(BlockPos pos) {
        if (!(this.f_58857_ == null || this.buildingPos != null && this.buildingPos.equals((Object)pos))) {
            this.m_6596_();
        }
        this.buildingPos = pos;
    }

    public abstract int getUpgradeSize();

    public abstract int getItemCount(Predicate<ItemStack> var1);

    public abstract void updateItemStorage();

    protected abstract void updateBlockState();

    public abstract AbstractTileEntityRack getOtherChest();

    public abstract boolean isEmpty();

    public void setMain(boolean main) {
        this.main = main;
        this.m_6596_();
    }

    public void neighborChanged(BlockPos newNeighbor) {
        if (this.f_58857_ == null) {
            return;
        }
        BlockEntity entity = this.f_58857_.m_7702_(newNeighbor);
        if (this.relativeNeighbor == null && this.f_58857_.m_8055_(newNeighbor).m_60734_() instanceof AbstractBlockMinecoloniesRack && (!(entity instanceof AbstractTileEntityRack) || ((AbstractTileEntityRack)entity).getOtherChest() == null)) {
            if (!this.setNeighbor(newNeighbor)) {
                return;
            }
            this.setSingle(false);
            if (entity instanceof AbstractTileEntityRack) {
                if (!((AbstractTileEntityRack)entity).isMain()) {
                    this.main = true;
                    ((AbstractTileEntityRack)entity).setMain(false);
                }
                ((AbstractTileEntityRack)entity).setNeighbor(this.m_58899_());
                entity.m_6596_();
            }
            this.updateItemStorage();
            this.m_6596_();
            this.updateBlockState();
        } else if (this.relativeNeighbor != null && this.f_58858_.m_141950_((Vec3i)this.relativeNeighbor).equals((Object)newNeighbor) && this.f_58857_.m_8055_(newNeighbor).m_60734_() != ModBlocks.blockRack) {
            this.relativeNeighbor = null;
            this.setSingle(true);
            this.main = false;
            this.updateItemStorage();
            this.updateBlockState();
        }
    }

    public void setSingle(boolean single) {
        this.single = single;
    }

    public boolean isMain() {
        return this.main;
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    public abstract BlockPos getNeighbor();

    public abstract boolean setNeighbor(BlockPos var1);

    public class RackInventory
    extends ItemStackHandler {
        public RackInventory(int defaultSize) {
            super(defaultSize);
        }

        protected void onContentsChanged(int slot) {
            AbstractTileEntityRack.this.updateItemStorage();
            super.onContentsChanged(slot);
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            this.validateSlotIndex(slot);
            boolean changed = !ItemStack.m_41728_((ItemStack)stack, (ItemStack)((ItemStack)this.stacks.get(slot)));
            this.stacks.set(slot, (Object)stack);
            if (changed) {
                this.onContentsChanged(slot);
            }
            AbstractTileEntityRack.this.updateWarehouseIfAvailable(stack);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            ItemStack result = super.insertItem(slot, stack, simulate);
            if ((result.m_41619_() || result.m_41613_() < stack.m_41613_()) && !simulate) {
                AbstractTileEntityRack.this.updateWarehouseIfAvailable(stack);
            }
            return result;
        }
    }
}

