/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.OptionalPredicate;
import java.util.Optional;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class CraftingUtils {
    private CraftingUtils() {
        throw new IllegalStateException("Tried to initialize: CraftingUtils but this is a Utility class.");
    }

    public static int calculateMaxCraftingCount(@NotNull ItemStack outputStack, @NotNull IRecipeStorage storage) {
        int craftingCount = (int)Math.ceil((double)Math.max(ItemStackUtils.getSize(outputStack), ItemStackUtils.getSize(storage.getPrimaryOutput())) / (double)ItemStackUtils.getSize(storage.getPrimaryOutput()));
        for (ItemStorage ingredientStorage : storage.getCleanedInput()) {
            ItemStack ingredient = ingredientStorage.getItemStack();
            int ingredientInputCount = ItemStackUtils.getSize(ingredient) * craftingCount;
            if (ingredientInputCount <= ingredient.m_41741_()) continue;
            craftingCount = Math.max(ingredient.m_41741_(), ItemStackUtils.getSize(storage.getPrimaryOutput())) / ItemStackUtils.getSize(storage.getPrimaryOutput());
        }
        return craftingCount;
    }

    public static int calculateMaxCraftingCount(@NotNull int count, @NotNull IRecipeStorage storage) {
        return (int)Math.ceil((double)Math.max(count, ItemStackUtils.getSize(storage.getPrimaryOutput())) / (double)ItemStackUtils.getSize(storage.getPrimaryOutput()));
    }

    public static OptionalPredicate<ItemStack> getProductValidatorBasedOnTags(@NotNull String crafterJobName) {
        return stack -> {
            Tag excludedProducts = (Tag)ModTags.crafterProductExclusions.get(crafterJobName);
            if (excludedProducts != null && excludedProducts.m_8110_((Object)stack.m_41720_())) {
                return Optional.of(false);
            }
            Tag allowedProducts = (Tag)ModTags.crafterProduct.get(crafterJobName);
            if (allowedProducts != null && allowedProducts.m_8110_((Object)stack.m_41720_())) {
                return Optional.of(true);
            }
            return Optional.empty();
        };
    }

    public static OptionalPredicate<ItemStack> getIngredientValidatorBasedOnTags(@NotNull String crafterJobName) {
        return stack -> {
            Tag excludedIngredients = (Tag)ModTags.crafterIngredientExclusions.get(crafterJobName);
            if (excludedIngredients != null && excludedIngredients.m_8110_((Object)stack.m_41720_())) {
                return Optional.of(false);
            }
            Tag allowedIngredients = (Tag)ModTags.crafterIngredient.get(crafterJobName);
            if (allowedIngredients != null && allowedIngredients.m_8110_((Object)stack.m_41720_())) {
                return Optional.of(true);
            }
            return Optional.empty();
        };
    }

    public static Optional<Boolean> isRecipeCompatibleBasedOnTags(@NotNull IGenericRecipe recipe, @NotNull String crafterJobName) {
        return OptionalPredicate.combine(recipe.matchesOutput(CraftingUtils.getProductValidatorBasedOnTags(crafterJobName)), () -> recipe.matchesInput(CraftingUtils.getIngredientValidatorBasedOnTags(crafterJobName)));
    }
}

