/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.sounds.ModSoundEvents;
import com.minecolonies.api.util.Tuple;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.world.NoteBlockEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SoundUtils {
    private static final int ONE_HUNDRED = 100;
    public static final double PITCH = 0.9;
    private static final Random rand = new Random();
    public static final double VOLUME = 0.5;
    private static final double BASE_PITCH = 0.8;
    private static final double PITCH_DIVIDER = 1.0;
    private static final double PITCH_MULTIPLIER = 0.4;
    public static final NoteBlockEvent.Note[] PENTATONIC = new NoteBlockEvent.Note[]{NoteBlockEvent.Note.A, NoteBlockEvent.Note.B, NoteBlockEvent.Note.D, NoteBlockEvent.Note.E, NoteBlockEvent.Note.F_SHARP, NoteBlockEvent.Note.A, NoteBlockEvent.Note.B, NoteBlockEvent.Note.D};
    private static final double MIN_REQUIRED_SOUND_DIST = 100.0;

    private SoundUtils() {
    }

    public static void playRandomSound(@NotNull Level worldIn, @NotNull BlockPos pos, @NotNull ICitizenData citizen) {
        boolean playerCloseEnough = false;
        for (Player player : citizen.getColony().getPackageManager().getCloseSubscribers()) {
            if (!(player.m_142538_().m_123331_((Vec3i)pos) < 100.0)) continue;
            playerCloseEnough = true;
            break;
        }
        if (!playerCloseEnough) {
            return;
        }
        double v = rand.nextDouble();
        if (v <= 0.1) {
            if (citizen.getSaturation() < 2.0) {
                SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.SATURATION_LOW, citizen);
            } else {
                SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.SATURATION_HIGH, citizen);
            }
        } else if (v <= 0.2) {
            if (citizen.getCitizenHappinessHandler().getHappiness(citizen.getColony()) < 5.0) {
                SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.UNHAPPY, citizen);
            } else {
                SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.HAPPY, citizen);
            }
        } else if (v <= 0.3) {
            SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.GENERAL, citizen);
        } else if (v <= 0.4 && citizen.getEntity().isPresent() && citizen.getEntity().get().getCitizenDiseaseHandler().isSick()) {
            SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.SICKNESS, citizen);
        } else if (v <= 0.5 && (citizen.getHomeBuilding() == null || citizen.getHomeBuilding().getBuildingLevel() <= 2)) {
            SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.BAD_HOUSING, citizen);
        } else if (v <= 0.6 && worldIn.m_46471_()) {
            SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.BAD_WEATHER, citizen);
        } else if (v <= 1.0) {
            SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.NOISE, citizen);
        }
    }

    public static void playSoundAtCitizen(@NotNull Level worldIn, @NotNull BlockPos position, @NotNull SoundEvent event) {
        worldIn.m_5594_(null, position, event, SoundSource.NEUTRAL, 0.5f, 0.9f);
    }

    public static void playSuccessSound(@NotNull Player player, @NotNull BlockPos position) {
        if (player instanceof ServerPlayer) {
            ((ServerPlayer)player).f_8906_.m_141995_((Packet)new ClientboundSoundPacket(SoundEvents.f_12210_, SoundSource.NEUTRAL, (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), 1.0f, 1.0f));
        }
    }

    public static void playErrorSound(@NotNull Player player, @NotNull BlockPos position) {
        if (player instanceof ServerPlayer) {
            ((ServerPlayer)player).f_8906_.m_141995_((Packet)new ClientboundSoundPacket(SoundEvents.f_12169_, SoundSource.NEUTRAL, (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), 1.0f, 0.3f));
        }
    }

    public static void playSoundAtCitizenWith(@NotNull Level worldIn, @NotNull BlockPos position, @Nullable EventType type, @Nullable ICitizenData citizenData) {
        SoundEvent event;
        if (citizenData == null) {
            return;
        }
        Map<EventType, Tuple<SoundEvent, SoundEvent>> map = citizenData.getJob() != null ? ModSoundEvents.CITIZEN_SOUND_EVENTS.get(citizenData.getJob().getJobRegistryEntry().getRegistryName().m_135815_()) : ModSoundEvents.CITIZEN_SOUND_EVENTS.get(citizenData.isChild() ? "child" : "citizen");
        SoundEvent soundEvent = event = citizenData.isFemale() ? map.get((Object)type).getB() : map.get((Object)type).getA();
        if (type.getChance() > rand.nextDouble() * 100.0) {
            worldIn.m_5594_(null, position, event, SoundSource.NEUTRAL, 0.5f, 0.9f);
        }
    }

    public static double getRandomPitch(Random random) {
        return 1.0 / (random.nextDouble() * 0.4 + 0.8);
    }

    public static double getRandomPentatonic(Random random) {
        int index = random.nextInt(PENTATONIC.length);
        int tone = PENTATONIC[index].ordinal() + Math.floorDiv(index, 5) * 12;
        return Math.pow(2.0, (double)(tone - 12) / 12.0);
    }

    public static void playSoundForPlayer(ServerPlayer playerEntity, SoundEvent sound, float volume, float pitch) {
        playerEntity.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(sound, playerEntity.m_5720_(), playerEntity.m_20185_(), playerEntity.m_20186_(), playerEntity.m_20189_(), 16.0f * volume, pitch));
    }
}

