/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.client.gui.ColorPalette;
import com.minecolonies.coremod.client.gui.townhall.AbstractWindowTownHall;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class WindowBannerPicker
extends Screen {
    private static final int GUI_Y = 30;
    private static final int SIDE = 20;
    private static final int PATTERN_HEIGHT = 30;
    private static final int PATTERN_WIDTH = 15;
    private static final int PATTERN_MARGIN = 3;
    private static final int PATTERN_COLUMNS = 8;
    private static final int PATTERN_ROWS = 4;
    private static final BannerPattern[][] EXCLUSION = new BannerPattern[][]{{BannerPattern.GRADIENT, BannerPattern.GRADIENT_UP}, {BannerPattern.BRICKS, BannerPattern.FLOWER}, {BannerPattern.SKULL, BannerPattern.CREEPER}, {BannerPattern.GLOBE, BannerPattern.PIGLIN}, {BannerPattern.MOJANG}, {BannerPattern.BASE}};
    private final List<BannerPattern> patterns;
    private final List<Pair<BannerPattern, DyeColor>> layers;
    private final IColonyView colony;
    private final AbstractWindowTownHall window;
    private final ModelPart modelRender;
    private ColorPalette colors;
    private int activeLayer = 0;
    private boolean scrolling = false;
    private int scrollRow = 0;

    public WindowBannerPicker(IColonyView colony, AbstractWindowTownHall hallWindow) {
        super((Component)new TextComponent("Flag"));
        this.colony = colony;
        this.window = hallWindow;
        this.modelRender = Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171264_).m_171324_("flag");
        ArrayList<BannerPattern> exclusion = new ArrayList<BannerPattern>();
        for (int i = ((ITownHallView)hallWindow.building).getBuildingLevel(); i <= ((ITownHallView)hallWindow.building).getBuildingMaxLevel(); ++i) {
            exclusion.addAll(Arrays.asList(EXCLUSION[i]));
        }
        this.patterns = new LinkedList<BannerPattern>(Arrays.asList(BannerPattern.values()));
        this.patterns.removeAll(exclusion);
        this.layers = BannerBlockEntity.m_58484_((DyeColor)DyeColor.WHITE, (ListTag)colony.getColonyFlag());
        if (this.layers.size() > 1) {
            this.layers.remove(0);
        }
    }

    protected void m_7856_() {
        int paletteX = WindowBannerPicker.center(this.f_96543_, 8, 15, 0, 0) - 70;
        this.colors = new ColorPalette(paletteX, this.f_96544_ / 2, 2, x$0 -> {
            Button cfr_ignored_0 = (Button)this.m_142416_((GuiEventListener)x$0);
        });
        this.colors.onchange = color -> this.setLayer(null, color);
        this.createLayerButtons();
        this.createPatternButtons();
        this.createCloseButtons();
    }

    protected void createLayerButtons() {
        for (int layer = 0; layer <= 6; ++layer) {
            int posX = (this.f_96543_ - 120) / 2 + layer * 20;
            this.m_142416_((GuiEventListener)new LayerButton(posX, 30, 20, 20, layer));
        }
        this.m_142416_((GuiEventListener)new Button(WindowBannerPicker.center(this.f_96543_, 6, 20, 7, 0), 30, 20, 20, (Component)new TextComponent(ChatFormatting.RED + "X"), pressed -> this.layers.remove(this.activeLayer)){

            public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
                this.f_93623_ = WindowBannerPicker.this.activeLayer < WindowBannerPicker.this.layers.size() && WindowBannerPicker.this.activeLayer != 0;
                super.m_6305_(stack, mouseX, mouseY, partialTicks);
            }
        });
    }

    protected void createPatternButtons() {
        for (int i = 0; i < this.patterns.size(); ++i) {
            int posX = WindowBannerPicker.center(this.f_96543_, 8, 15, i % 8, 3);
            int posY = WindowBannerPicker.center(this.f_96544_ + 30, 4, 30, Math.floorDiv(i, 8), 3);
            this.m_142416_((GuiEventListener)new PatternButton(posX, posY, 30, this.patterns.get(i)));
        }
    }

    protected void createCloseButtons() {
        this.m_142416_((GuiEventListener)new Button(WindowBannerPicker.center(this.f_96543_, 2, 80, 1, 10), this.f_96544_ - 40, 80, 20, (Component)new TranslatableComponent("gui.done"), pressed -> {
            BannerPattern.Builder builder = new BannerPattern.Builder();
            for (Pair<BannerPattern, DyeColor> pair : this.layers) {
                builder.m_58588_((BannerPattern)pair.getFirst(), (DyeColor)pair.getSecond());
            }
            this.colony.setColonyFlag(builder.m_58587_());
            this.window.open();
        }));
        this.m_142416_((GuiEventListener)new Button(WindowBannerPicker.center(this.f_96543_, 2, 80, 0, 10), this.f_96544_ - 40, 80, 20, (Component)new TranslatableComponent("gui.cancel"), pressed -> this.window.open()));
    }

    public static int center(int length, int count, int side, int n, int margin) {
        return (length - count * (side + margin)) / 2 + n * (side + margin) + margin / 2;
    }

    public void setLayer(@Nullable BannerPattern pattern, DyeColor color) {
        if (pattern == null) {
            if (this.activeLayer == this.layers.size()) {
                return;
            }
            pattern = this.activeLayer == 0 ? BannerPattern.BASE : (BannerPattern)this.layers.get(this.activeLayer).getFirst();
        }
        if (this.activeLayer == this.layers.size()) {
            this.layers.add((Pair<BannerPattern, DyeColor>)new Pair((Object)pattern, (Object)color));
        } else {
            this.layers.set(this.activeLayer, (Pair<BannerPattern, DyeColor>)new Pair((Object)pattern, (Object)color));
        }
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.drawFlag();
        int scrollRows = (int)(Math.ceil((float)this.patterns.size() / 8.0f) - 4.0);
        if (scrollRows > 0 && this.activeLayer > 0) {
            int trackHeight = 132;
            double barHeight = (float)trackHeight * (4.0f / (float)(scrollRows + 4));
            int trackX = WindowBannerPicker.center(this.f_96543_, 8, 15, 8, 3);
            int trackY = (int)((float)WindowBannerPicker.center(this.f_96544_, 4, 30, 0, 3) + (float)this.scrollRow * ((float)trackHeight / (float)(scrollRows + 4)));
            WindowBannerPicker.m_93172_((PoseStack)stack, (int)(trackX + 2), (int)trackY, (int)(trackX + 6), (int)(trackY + (int)barHeight), (int)-1140850689);
        }
        WindowBannerPicker.m_93208_((PoseStack)stack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"com.minecolonies.coremod.gui.flag.choose", (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)16, (int)0xFFFFFF);
    }

    private void drawFlag() {
        Lighting.m_84930_();
        double posX = ((double)this.f_96543_ + 120.0) / 2.0 + 40.0;
        double posY = (double)this.f_96544_ / 2.0;
        PoseStack transform = new PoseStack();
        transform.m_85837_(posX, posY + 40.0, 0.0);
        transform.m_85841_(40.0f, -40.0f, 1.0f);
        transform.m_85837_(0.5, 0.5, 0.5);
        transform.m_85841_(1.0f, -1.0f, -1.0f);
        this.renderBanner(transform, this.layers);
    }

    private void drawBannerPattern(BannerPattern pattern, int x, int y) {
        Lighting.m_84930_();
        ArrayList<Pair<BannerPattern, DyeColor>> list = new ArrayList<Pair<BannerPattern, DyeColor>>();
        list.add(new Pair((Object)BannerPattern.BASE, (Object)DyeColor.GRAY));
        list.add(new Pair((Object)pattern, (Object)DyeColor.WHITE));
        PoseStack transform = new PoseStack();
        transform.m_85836_();
        transform.m_85837_((double)x + 2.5, (double)(y + 29), 0.0);
        transform.m_85841_(10.0f, -11.0f, 1.0f);
        transform.m_85837_(0.5, 0.5, 0.5);
        transform.m_85841_(1.0f, -1.0f, -1.0f);
        this.renderBanner(transform, list);
    }

    public void renderBanner(PoseStack transform, List<Pair<BannerPattern, DyeColor>> layers) {
        this.modelRender.f_104203_ = 0.0f;
        this.modelRender.f_104201_ = -32.0f;
        MultiBufferSource.BufferSource source = this.f_96541_.m_91269_().m_110104_();
        BannerRenderer.m_112065_((PoseStack)transform, (MultiBufferSource)source, (int)0xF000F0, (int)OverlayTexture.f_118083_, (ModelPart)this.modelRender, (Material)ModelBakery.f_119224_, (boolean)true, layers);
        transform.m_85849_();
        source.m_109911_();
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        if (this.activeLayer > 0) {
            this.scrollRow = (int)Mth.m_14008_((double)((double)this.scrollRow - scroll), (double)0.0, (double)(Math.ceil(this.patterns.size() / 8) - 4.0 + 1.0));
        }
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int p_231044_5_) {
        this.scrolling = false;
        int trackX = WindowBannerPicker.center(this.f_96543_, 8, 15, 8, 3);
        int trackY = WindowBannerPicker.center(this.f_96544_, 4, 30, 0, 3);
        int trackEnd = trackY + 132;
        if (mouseX > (double)(trackX + 2) && mouseX < (double)(trackX + 8) && mouseY > (double)trackY && mouseY < (double)trackEnd) {
            this.scrolling = true;
        }
        return super.m_6375_(mouseX, mouseY, p_231044_5_);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling && this.activeLayer > 0) {
            int trackStart = WindowBannerPicker.center(this.f_96544_, 4, 30, 0, 3);
            int trackLength = 132;
            double scrollRatio = Mth.m_14008_((double)((mouseY - (double)trackStart) / (double)trackLength), (double)0.0, (double)1.0);
            this.scrollRow = (int)Math.round(scrollRatio * (Math.ceil(this.patterns.size() / 8) - 4.0 + 1.0));
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public class LayerButton
    extends Button {
        private final int layer;

        public LayerButton(int x, int y, int width, int height, int layer) {
            super(x - (layer == 0 ? width * 2 : 0), y, width * (layer == 0 ? 3 : 1), height, (Component)(layer == 0 ? new TranslatableComponent("com.minecolonies.coremod.gui.flag.base_layer") : new TextComponent(String.valueOf(layer))), pressed -> {});
            this.layer = layer;
        }

        public void m_5691_() {
            WindowBannerPicker.this.activeLayer = this.layer;
            if (this.layer >= WindowBannerPicker.this.layers.size()) {
                WindowBannerPicker.this.colors.setSelected(((DyeColor)WindowBannerPicker.this.layers.get(0).getSecond()).equals((Object)DyeColor.BLACK) ? DyeColor.WHITE : DyeColor.BLACK);
            } else {
                WindowBannerPicker.this.colors.setSelected((DyeColor)WindowBannerPicker.this.layers.get(WindowBannerPicker.this.activeLayer).getSecond());
            }
        }

        public void m_6305_(PoseStack stack, int p_render_1_, int p_render_2_, float p_render_3_) {
            this.f_93623_ = this.layer <= WindowBannerPicker.this.layers.size();
            super.m_6305_(stack, p_render_1_, p_render_2_, p_render_3_);
            if (WindowBannerPicker.this.activeLayer == this.layer) {
                LayerButton.m_93172_((PoseStack)stack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)1725798911);
            }
        }
    }

    public class PatternButton
    extends Button {
        private final BannerPattern pattern;
        private final int index;

        public PatternButton(int x, int y, int height, BannerPattern pattern) {
            super(x, y, height / 2, height, (Component)new TextComponent(""), btn -> {});
            this.pattern = pattern;
            this.index = WindowBannerPicker.this.patterns.indexOf(pattern);
        }

        public void m_5691_() {
            WindowBannerPicker.this.setLayer(this.pattern, WindowBannerPicker.this.colors.getSelected());
        }

        public void m_6305_(PoseStack stack, int p_render_1_, int p_render_2_, float p_render_3_) {
            this.f_93624_ = WindowBannerPicker.this.scrollRow * 8 <= this.index && this.index < 8 * (WindowBannerPicker.this.scrollRow + 4);
            boolean bl = this.f_93623_ = WindowBannerPicker.this.activeLayer != 0;
            if (!this.f_93623_ || !this.f_93624_) {
                return;
            }
            int position = Math.floorDiv(this.index - WindowBannerPicker.this.scrollRow * 8, 8);
            this.f_93621_ = WindowBannerPicker.center(WindowBannerPicker.this.f_96544_, 4, 30, position, 3);
            super.m_6305_(stack, p_render_1_, p_render_2_, p_render_3_);
            try {
                WindowBannerPicker.this.drawBannerPattern(this.pattern, this.f_93620_, this.f_93621_);
            }
            catch (Exception ex) {
                Log.getLogger().warn(this.pattern.m_58572_());
                Log.getLogger().error((Object)ex);
            }
        }

        public void m_6303_(PoseStack stack, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
            if (this.f_93624_) {
                if (this.f_93622_ && this.f_93623_) {
                    PatternButton.m_93172_((PoseStack)stack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)-570425345);
                }
                if (WindowBannerPicker.this.activeLayer < WindowBannerPicker.this.layers.size() && WindowBannerPicker.this.layers.get(WindowBannerPicker.this.activeLayer).getFirst() == this.pattern) {
                    PatternButton.m_93172_((PoseStack)stack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)-2258689);
                } else {
                    PatternButton.m_93172_((PoseStack)stack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)0x33888888);
                }
            }
        }
    }
}

