/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonHandler;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.Box;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.WindowClipBoard;
import com.minecolonies.coremod.client.gui.citizen.RequestWindowCitizen;
import com.minecolonies.coremod.colony.requestsystem.requests.AbstractRequest;
import com.minecolonies.coremod.network.messages.server.ClickGuiButtonTriggerMessage;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowRequestDetail
extends BOWindow
implements ButtonHandler {
    private static final String BOX_ID_REQUEST = "requestDetail";
    private static final String REQUESTER = "requester";
    private static final String LIST_ELEMENT_ID_REQUEST_STACK = "requestStack";
    private static final int LIFE_COUNT_DIVIDER = 30;
    private static final String LIST_ELEMENT_ID_REQUEST_LOCATION = "targetLocation";
    private static final String RESOLVER = "resolver";
    private static final String DELIVERY_IMAGE = "deliveryImage";
    private final IRequest<?> request;
    private final int colonyId;
    private int lifeCount = 0;
    private final BOWindow prevWindow;

    public WindowRequestDetail(@Nullable BOWindow prevWindow, IRequest<?> request, int colonyId) {
        super(new ResourceLocation("minecolonies:gui/windowrequestdetail.xml"));
        this.prevWindow = prevWindow;
        this.request = request;
        this.colonyId = colonyId;
    }

    public void onUpdate() {
        super.onUpdate();
        if (!Screen.m_96638_()) {
            ++this.lifeCount;
        }
        ItemIcon exampleStackDisplay = (ItemIcon)this.findPaneOfTypeByID(LIST_ELEMENT_ID_REQUEST_STACK, ItemIcon.class);
        List<ItemStack> displayStacks = this.request.getDisplayStacks();
        if (!displayStacks.isEmpty()) {
            exampleStackDisplay.setItem(displayStacks.get(this.lifeCount / 30 % displayStacks.size()));
        } else {
            exampleStackDisplay.setItem(ItemStackUtils.EMPTY);
        }
    }

    public void onOpened() {
        Box box = (Box)this.findPaneOfTypeByID(BOX_ID_REQUEST, Box.class);
        Text description = (Text)((AbstractTextBuilder.TextBuilder)((AbstractTextBuilder.TextBuilder)((AbstractTextBuilder.TextBuilder)PaneBuilders.textBuilder().style(ChatFormatting.m_126645_((char)'r'))).style(ChatFormatting.m_126645_((char)'0'))).append(this.request.getLongDisplayString())).build();
        description.setPosition(1, 1);
        description.setSize(box.getWidth() - 2, 1000000);
        box.addChild((Pane)description);
        box.setSize(box.getWidth(), description.getRenderedTextHeight() + 2);
        description.setSize(box.getWidth() - 2, box.getHeight());
        Image logo = (Image)this.findPaneOfTypeByID(DELIVERY_IMAGE, Image.class);
        ItemIcon exampleStackDisplay = (ItemIcon)this.findPaneOfTypeByID(LIST_ELEMENT_ID_REQUEST_STACK, ItemIcon.class);
        List<ItemStack> displayStacks = this.request.getDisplayStacks();
        IColonyView colony = IColonyManager.getInstance().getColonyView(this.colonyId, (ResourceKey<Level>)Minecraft.m_91087_().f_91073_.m_46472_());
        if (!displayStacks.isEmpty()) {
            exampleStackDisplay.setItem(displayStacks.get(this.lifeCount / 30 % displayStacks.size()));
        } else if (!this.request.getDisplayIcon().equals((Object)AbstractRequest.MISSING)) {
            logo.setVisible(true);
            logo.setImage(this.request.getDisplayIcon(), false);
            PaneBuilders.tooltipBuilder().hoverPane((Pane)logo).build().setText(this.request.getResolverToolTip(colony));
        }
        ((Text)this.findPaneOfTypeByID(REQUESTER, Text.class)).setText(this.request.getRequester().getRequesterDisplayName(colony.getRequestManager(), this.request));
        ((Text)this.findPaneOfTypeByID(LIST_ELEMENT_ID_REQUEST_LOCATION, Text.class)).setText(this.request.getRequester().getLocation().toString());
        if (colony == null) {
            Log.getLogger().warn("---Colony Null in WindowRequestDetail---");
            return;
        }
        try {
            IRequestResolver<?> resolver = colony.getRequestManager().getResolverForRequest((IToken<?>)this.request.getId());
            if (resolver == null) {
                Log.getLogger().warn("---IRequestResolver Null in WindowRequestDetail---");
                return;
            }
            ((Text)this.findPaneOfTypeByID(RESOLVER, Text.class)).setText("Resolver: " + resolver.getRequesterDisplayName(colony.getRequestManager(), this.request).getString());
        }
        catch (IllegalArgumentException e) {
            Log.getLogger().warn("---IRequestResolver Null in WindowRequestDetail---", (Throwable)e);
        }
        Pane fulfillButton = this.window.getChildren().stream().filter(pane -> pane.getID().equals("fulfill")).findFirst().get();
        if (this.prevWindow instanceof RequestWindowCitizen && !((RequestWindowCitizen)this.prevWindow).fulfillable(this.request) || this.prevWindow instanceof WindowClipBoard) {
            fulfillButton.hide();
        }
        Pane cancelButton = this.window.getChildren().stream().filter(pane -> pane.getID().equals("cancel")).findFirst().get();
        if (this.prevWindow instanceof RequestWindowCitizen && !((RequestWindowCitizen)this.prevWindow).cancellable(this.request)) {
            cancelButton.hide();
        }
    }

    public void onButtonClicked(@NotNull Button button) {
        if (button.getID().equals("fulfill")) {
            if (this.prevWindow instanceof RequestWindowCitizen) {
                ((RequestWindowCitizen)this.prevWindow).fulfill(this.request);
                Network.getNetwork().sendToServer(new ClickGuiButtonTriggerMessage(button.getID(), "minecolonies:gui/windowrequestdetail.xml"));
            }
            this.window.close();
        } else if (button.getID().equals("cancel")) {
            if (this.prevWindow instanceof RequestWindowCitizen) {
                ((RequestWindowCitizen)this.prevWindow).cancel(this.request);
            }
            this.window.close();
        } else {
            this.prevWindow.open();
        }
    }
}

