/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.containers;

import com.google.common.collect.Lists;
import com.minecolonies.api.inventory.container.ContainerField;
import com.minecolonies.api.tileentities.AbstractScarecrowTileEntity;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.network.messages.server.FieldPlotResizeMessage;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Direction;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class WindowField
extends AbstractContainerScreen<ContainerField> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("minecolonies", "textures/gui/scarecrow.png");
    private static final int X_OFFSET = 8;
    private static final int Y_OFFSET = 6;
    private static final int TEXT_COLOR = 0x404040;
    private static final int BUTTON_SIDE_LENGTH = 24;
    private final AbstractScarecrowTileEntity tileEntity;
    private final int[] radii = new int[4];

    public WindowField(ContainerField container, Inventory playerInventory, Component iTextComponent) {
        super((AbstractContainerMenu)container, playerInventory, iTextComponent);
        this.tileEntity = container.getTileEntity();
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_97735_ + this.f_97726_ / 2 + 1;
        int centerY = this.f_97736_ + this.f_97727_ / 2;
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            int xFromPolar = (int)Math.sin(Math.PI * (double)(4 - dir.m_122416_()) / 2.0) * 24;
            int yFromPolar = (int)Math.cos(Math.PI * (double)(4 - dir.m_122416_()) / 2.0) * 24;
            this.radii[dir.m_122416_()] = this.tileEntity.getRadius(dir);
            DirectionalButton db = new DirectionalButton(centerX + xFromPolar - 12, centerY - 40 + yFromPolar - 12, 24, 24, (Component)new TextComponent(String.valueOf(this.radii[dir.m_122416_()])), dir);
            this.m_142416_((GuiEventListener)db);
        }
    }

    protected void m_7027_(@NotNull PoseStack stack, int mouseX, int mouseY) {
        if (!this.tileEntity.getOwner().isEmpty()) {
            this.f_96547_.m_92889_(stack, (Component)new TranslatableComponent("com.minecolonies.coremod.gui.field.worker", new Object[]{this.tileEntity.getOwner()}), 8.0f, -12.0f, 0xFFFFFF);
        }
        this.f_96547_.m_92889_(stack, (Component)new TranslatableComponent("block.minecolonies.blockhutfield"), 8.0f, 6.0f, 0x404040);
        for (Widget widget : this.f_169369_) {
            if (!(widget instanceof AbstractWidget) || !((AbstractWidget)widget).m_5953_((double)mouseX, (double)mouseY)) continue;
            ((AbstractWidget)widget).m_7428_(stack, mouseX - this.f_97735_, mouseY - this.f_97736_);
            break;
        }
    }

    protected void m_7286_(@NotNull PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int marginHorizontal = (this.f_96543_ - this.f_97726_) / 2;
        int marginVertical = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(stack, marginHorizontal, marginVertical, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_6305_(@NotNull PoseStack stack, int x, int y, float z) {
        this.m_7333_(stack);
        super.m_6305_(stack, x, y, z);
        this.m_7025_(stack, x, y);
    }

    protected class DirectionalButton
    extends Button {
        public Direction direction;
        public int textureX;
        public int textureY;
        public int columns;

        public DirectionalButton(int x, int y, int width, int height, Component text, Direction direction) {
            super(x, y, width, height, text, button -> {});
            this.textureX = 176;
            this.textureY = 0;
            this.columns = 2;
            this.direction = direction;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.m_93680_(mouseX, mouseY)) {
                int index = this.direction.m_122416_();
                int delta = this.m_7972_(button) ? 1 : -1;
                WindowField.this.radii[index] = (WindowField.this.radii[index] + delta) % (ScarecrowTileEntity.getMaxRange() + 1);
                if (WindowField.this.radii[index] < 0) {
                    WindowField.this.radii[index] = ScarecrowTileEntity.getMaxRange();
                }
                this.m_93666_((Component)new TextComponent(String.valueOf(WindowField.this.radii[index])));
                Network.getNetwork().sendToServer(new FieldPlotResizeMessage(WindowField.this.radii[index], this.direction, WindowField.this.tileEntity.m_58899_()));
                return true;
            }
            return false;
        }

        public int getTextureXOffset() {
            return this.textureX + 24 * Math.floorDiv(this.direction.m_122416_(), this.columns);
        }

        public int getTextureYOffset() {
            return this.textureY + 72 * (this.direction.m_122416_() % this.columns);
        }

        public int getTextOffset(Direction.Axis axis) {
            switch (this.direction) {
                case NORTH: {
                    return axis == Direction.Axis.X ? 0 : 2;
                }
                case EAST: {
                    return axis == Direction.Axis.X ? -2 : 0;
                }
                case SOUTH: {
                    return axis == Direction.Axis.X ? 0 : -2;
                }
                case WEST: {
                    return axis == Direction.Axis.X ? 2 : 0;
                }
            }
            return 0;
        }

        public void m_6303_(@NotNull PoseStack stack, int mouseX, int mouseY, float partialTicks) {
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontrenderer = minecraft.f_91062_;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            int i = this.m_7202_(this.f_93622_);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.m_93228_(stack, this.f_93620_, this.f_93621_, this.getTextureXOffset(), this.getTextureYOffset() + i * 24, this.f_93618_, this.f_93619_);
            this.m_7906_(stack, minecraft, mouseX, mouseY);
            int j = this.getFGColor();
            DirectionalButton.m_93215_((PoseStack)stack, (Font)fontrenderer, (Component)this.m_6035_(), (int)(this.f_93620_ + this.f_93618_ / 2 + this.getTextOffset(Direction.Axis.X)), (int)(this.f_93621_ + (this.f_93619_ - 8) / 2 + this.getTextOffset(Direction.Axis.Y)), (int)(j | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24));
        }

        public void m_7428_(@NotNull PoseStack stack, int mouseX, int mouseY) {
            if (!((ContainerField)WindowField.this.f_97732_).m_142621_().m_41619_()) {
                return;
            }
            ArrayList lines = Lists.newArrayList((Object[])new FormattedText[]{new TextComponent(new TranslatableComponent("com.minecolonies.coremod.gui.field." + this.direction.m_7912_()).getString()), new TextComponent(ChatFormatting.GRAY + ChatFormatting.ITALIC + new TranslatableComponent(this.getDirectionalTranslationKey()).getString())});
            WindowField.this.m_96617_(stack, Language.m_128107_().m_128112_((List)lines), mouseX, mouseY);
        }

        public String getDirectionalTranslationKey() {
            Direction[] looks = Direction.m_122382_((Entity)Minecraft.m_91087_().f_91074_);
            Direction facing = looks[0].m_122434_() == Direction.Axis.Y ? looks[1] : looks[0];
            switch (facing.m_122424_().m_122416_() - this.direction.m_122416_()) {
                case -3: 
                case 1: {
                    return "com.minecolonies.coremod.gui.field.to_right";
                }
                case -2: 
                case 2: {
                    return "com.minecolonies.coremod.gui.field.opposite";
                }
                case -1: 
                case 3: {
                    return "com.minecolonies.coremod.gui.field.to_left";
                }
            }
            return "com.minecolonies.coremod.gui.field.near";
        }
    }
}

