/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.huts;

import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.TextField;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.client.gui.AbstractWindowWorkerModuleBuilding;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCrusher;
import java.util.List;

public class WindowHutCrusherModule
extends AbstractWindowWorkerModuleBuilding<BuildingCrusher.View> {
    private static final String BLOCK_BUTTON = "block";
    private static final String BUTTON_SAVE = "save";
    private static final String QTY_INPUT = "qty";
    private static final String CRUSHER_RESOURCE_SUFFIX = ":gui/windowhutcrusher.xml";
    private ItemStorage mode;

    public WindowHutCrusherModule(BuildingCrusher.View building) {
        super(building, "minecolonies:gui/windowhutcrusher.xml");
        Button crushingSettingsButton = (Button)this.findPaneOfTypeByID(BLOCK_BUTTON, Button.class);
        TextField crushingSettingsInput = (TextField)this.findPaneOfTypeByID(QTY_INPUT, TextField.class);
        this.registerButton(BLOCK_BUTTON, this::switchCrushingMode);
        this.registerButton(BUTTON_SAVE, this::saveCrushingMode);
        this.mode = (ItemStorage)building.getCrusherMode().m_14418_();
        crushingSettingsInput.setText(((Integer)building.getCrusherMode().m_14419_()).toString());
        this.setupSettings(crushingSettingsButton);
    }

    private void saveCrushingMode() {
        TextField crushingSettingsInput = (TextField)this.findPaneOfTypeByID(QTY_INPUT, TextField.class);
        try {
            int qty = Integer.parseInt(crushingSettingsInput.getText());
            ((BuildingCrusher.View)this.building).setCrusherMode(this.mode, qty);
        }
        catch (NumberFormatException ex) {
            Log.getLogger().warn("Wrong input!");
        }
    }

    private void switchCrushingMode(Button crushingSettingsButton) {
        List<ItemStorage> modes = ((BuildingCrusher.View)this.building).getCrusherModes();
        int index = ((BuildingCrusher.View)this.building).getCrusherModes().indexOf(this.mode) + 1;
        if (index >= modes.size()) {
            index = 0;
        }
        this.mode = modes.get(index);
        this.setupSettings(crushingSettingsButton);
    }

    private void setupSettings(Button crushingSettingsButton) {
        if (this.mode != null) {
            crushingSettingsButton.setText(this.mode.getItemStack().m_41786_());
        }
    }
}

