/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.render;

import com.minecolonies.api.client.render.modeltype.CitizenModel;
import com.minecolonies.api.client.render.modeltype.IModelType;
import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.client.render.modeltype.registry.IModelTypeRegistry;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.apiimp.initializer.ModModelTypeInitializer;
import com.minecolonies.coremod.client.render.worldevent.RenderTypes;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderBipedCitizen
extends MobRenderer<AbstractEntityCitizen, CitizenModel<AbstractEntityCitizen>> {
    private static final double SHADOW_SIZE = 0.5;
    public static boolean isItGhostTime = false;

    public RenderBipedCitizen(EntityRendererProvider.Context context) {
        super(context, new CitizenModel(context.m_174023_(ModelLayers.f_171162_)), 0.5f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.m_174023_(ModelLayers.f_171164_)), new HumanoidModel(context.m_174023_(ModelLayers.f_171165_))));
        super.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this));
        ModModelTypeInitializer.init(context);
    }

    public void render(@NotNull AbstractEntityCitizen citizen, float limbSwing, float partialTicks, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource renderTypeBuffer, int light) {
        this.setupMainModelFrom(citizen);
        CitizenModel citizenModel = (CitizenModel)this.f_115290_;
        ItemStack mainHandStack = citizen.m_21205_();
        ItemStack offHandStack = citizen.m_21206_();
        HumanoidModel.ArmPose armPoseMainHand = this.getArmPoseFrom(citizen, mainHandStack);
        HumanoidModel.ArmPose armPoseOffHand = this.getArmPoseFrom(citizen, offHandStack);
        this.updateArmPose(citizen, citizenModel, armPoseMainHand, armPoseOffHand);
        if (isItGhostTime) {
            RenderSystem.m_69478_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
            super.m_7392_((Mob)citizen, limbSwing, partialTicks, matrixStack, renderTypeBuffer, light);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69461_();
        } else {
            super.m_7392_((Mob)citizen, limbSwing, partialTicks, matrixStack, renderTypeBuffer, light);
        }
    }

    private void setupMainModelFrom(@NotNull AbstractEntityCitizen citizen) {
        @Nullable IModelType modelType = IModelTypeRegistry.getInstance().getModelType(citizen.getModelType());
        Object object = this.f_115290_ = citizen.isFemale() ? modelType.getFemaleModel() : modelType.getMaleModel();
        if (this.f_115290_ == null) {
            Object object2 = this.f_115290_ = citizen.isFemale() ? modelType.getFemaleModel() : modelType.getMaleModel();
        }
        if (citizen.getCitizenDataView() != null && citizen.getCitizenDataView().getCustomTexture() != null) {
            this.f_115290_ = IModelTypeRegistry.getInstance().getModelType(ModModelTypes.CUSTOM_ID).getMaleModel();
        }
        ((CitizenModel)this.f_115290_).f_102610_ = citizen.m_6162_();
        ((CitizenModel)this.f_115290_).f_102609_ = citizen.m_20202_() != null;
        ((CitizenModel)this.f_115290_).f_102608_ = citizen.f_20921_;
    }

    protected void renderNameTag(@NotNull AbstractEntityCitizen entityIn, @NotNull Component str, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource buffer, int maxDistance) {
        double distance;
        super.m_7649_((Entity)entityIn, str, matrixStack, buffer, maxDistance);
        if (entityIn.getCitizenDataView() != null && entityIn.getCitizenDataView().hasVisibleInteractions() && (distance = this.f_114476_.m_114378_(entityIn.m_20185_(), entityIn.m_20186_(), entityIn.m_20189_())) <= 4096.0) {
            double yOffset = ((CitizenModel)this.f_115290_).f_102610_ ? -0.3 : 0.0;
            boolean isSneaking = entityIn.m_6144_();
            double height = entityIn.m_20206_() + 0.5f - (isSneaking ? 0.25f : 0.0f);
            double y = height + 0.3 + yOffset;
            ResourceLocation texture = entityIn.getCitizenDataView().getInteractionIcon();
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, y, 0.0);
            matrixStack.m_85845_(this.f_114476_.m_114470_());
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
            matrixStack.m_85841_(-0.025f, -0.025f, 0.025f);
            VertexConsumer r = buffer.m_6299_(RenderTypes.getPrimitiveTex(texture));
            Matrix4f matrixA = matrixStack.m_85850_().m_85861_();
            r.m_85982_(matrixA, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
            r.m_85982_(matrixA, 0.0f, 10.0f, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
            r.m_85982_(matrixA, 10.0f, 10.0f, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
            r.m_85982_(matrixA, 10.0f, 0.0f, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
            matrixStack.m_85849_();
        }
    }

    private HumanoidModel.ArmPose getArmPoseFrom(@NotNull AbstractEntityCitizen citizen, ItemStack mainHandStack) {
        HumanoidModel.ArmPose pose = HumanoidModel.ArmPose.EMPTY;
        if (!mainHandStack.m_41619_()) {
            pose = HumanoidModel.ArmPose.ITEM;
            if (citizen.m_21212_() > 0) {
                UseAnim enumActionMainHand = mainHandStack.m_41780_();
                if (enumActionMainHand == UseAnim.BLOCK) {
                    pose = HumanoidModel.ArmPose.BLOCK;
                } else if (enumActionMainHand == UseAnim.BOW) {
                    pose = HumanoidModel.ArmPose.BOW_AND_ARROW;
                }
            }
        }
        return pose;
    }

    private void updateArmPose(@NotNull AbstractEntityCitizen citizen, HumanoidModel<AbstractEntityCitizen> citizenModel, HumanoidModel.ArmPose armPoseMainHand, HumanoidModel.ArmPose armPoseOffHand) {
        if (citizen.m_5737_() == HumanoidArm.RIGHT) {
            citizenModel.f_102816_ = armPoseMainHand;
            citizenModel.f_102815_ = armPoseOffHand;
        } else {
            citizenModel.f_102816_ = armPoseOffHand;
            citizenModel.f_102815_ = armPoseMainHand;
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(AbstractEntityCitizen entity) {
        if (entity.getCitizenDataView() != null && entity.getCitizenDataView().getCustomTexture() != null) {
            return entity.getCitizenDataView().getCustomTexture();
        }
        return entity.getTexture();
    }
}

