/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.render.worldevent;

import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.client.StructureClientHandler;
import com.ldtteam.structurize.helpers.Settings;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.network.messages.SchematicRequestMessage;
import com.ldtteam.structurize.util.PlacementSettings;
import com.ldtteam.structurize.util.WorldRenderMacros;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.coremod.client.render.worldevent.WorldEventContext;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.server.ServerLifecycleHooks;

public class NearColonyBuildingsRenderer {
    private static final double PREVIEW_RANGE = 25.0;
    private static final double CACHE_RESET_RANGE = 12.5;
    private static Map<BlockPos, RenderData> blueprintCache = new HashMap<BlockPos, RenderData>();
    private static BlockPos lastCacheRebuild = null;
    public static Set<String> alreadyRequestedStructures = new HashSet<String>();

    static void render(WorldEventContext ctx) {
        if (Settings.instance.getActiveStructure() == null || !ctx.hasNearestColony() || !((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getClient().neighborbuildingrendering.get()).booleanValue()) {
            blueprintCache.clear();
            lastCacheRebuild = null;
            return;
        }
        if (ctx.mainHandItem.m_41720_() != ModItems.buildTool.get()) {
            alreadyRequestedStructures.clear();
            return;
        }
        BlockPos activePosition = Settings.instance.getPosition();
        if (lastCacheRebuild == null || !lastCacheRebuild.m_123314_((Vec3i)activePosition, 12.5)) {
            NearColonyBuildingsRenderer.rebuildCache(ctx);
            lastCacheRebuild = activePosition;
        }
        for (Map.Entry<BlockPos, RenderData> nearbyBuilding : blueprintCache.entrySet()) {
            RenderData buildingData = nearbyBuilding.getValue();
            BlockPos position = nearbyBuilding.getKey();
            if (buildingData.blueprint != null) {
                StructureClientHandler.renderStructureAtPos((Blueprint)buildingData.blueprint, (float)ctx.partialTicks, (BlockPos)position, (PoseStack)ctx.poseStack);
            }
            WorldRenderMacros.renderLineBox((VertexConsumer)ctx.bufferSource.m_6299_(WorldRenderMacros.LINES_WITH_WIDTH), (PoseStack)ctx.poseStack, (BlockPos)buildingData.boxStartPos, (BlockPos)buildingData.boxEndPos, (int)0, (int)0, (int)255, (int)255, (float)0.08f);
        }
    }

    private static void rebuildCache(WorldEventContext ctx) {
        BlockPos activePosition = Settings.instance.getPosition();
        HashMap<BlockPos, RenderData> newCache = new HashMap<BlockPos, RenderData>();
        for (IBuildingView buildingView : ctx.nearestColony.getBuildings()) {
            BlockPos currentPosition;
            if (buildingView.getBuildingType() == ModBuildings.postBox || buildingView.getBuildingType() == ModBuildings.stash || !activePosition.m_123314_((Vec3i)(currentPosition = buildingView.getPosition()), 25.0)) continue;
            if (blueprintCache.containsKey(currentPosition)) {
                newCache.put(currentPosition, blueprintCache.get(currentPosition));
                continue;
            }
            BlockEntity tile = ctx.clientLevel.m_7702_(buildingView.getID());
            String schematicName = buildingView.getSchematicName();
            if (tile instanceof IBlueprintDataProvider && !((IBlueprintDataProvider)tile).getSchematicName().isEmpty()) {
                schematicName = ((IBlueprintDataProvider)tile).getSchematicName().replaceAll("\\d$", "");
            }
            StructureName sn = new StructureName("schematics", buildingView.getStyle(), schematicName + buildingView.getBuildingMaxLevel());
            String structureName = sn.toString();
            String md5 = Structures.getMD5((String)structureName);
            LoadOnlyStructureHandler wrapper = new LoadOnlyStructureHandler((Level)ctx.clientLevel, buildingView.getID(), structureName, new PlacementSettings(), true);
            if (!wrapper.hasBluePrint() || !wrapper.isCorrectMD5(md5)) {
                if (alreadyRequestedStructures.contains(structureName)) continue;
                alreadyRequestedStructures.add(structureName);
                Log.getLogger().error("Couldn't find schematic: " + structureName + " requesting to server if possible.");
                if (ServerLifecycleHooks.getCurrentServer() != null) continue;
                Network.getNetwork().sendToServer((IMessage)new SchematicRequestMessage(structureName));
                continue;
            }
            Blueprint blueprint = wrapper.getBluePrint();
            Mirror mirror = buildingView.isMirrored() ? Mirror.FRONT_BACK : Mirror.NONE;
            blueprint.rotateWithMirror(BlockPosUtil.getRotationFromRotations(buildingView.getRotation()), mirror, (Level)ctx.clientLevel);
            BlockPos primaryOffset = blueprint.getPrimaryBlockOffset();
            BlockPos boxStartPos = currentPosition.m_141950_((Vec3i)primaryOffset);
            BlockPos size = new BlockPos((int)blueprint.getSizeX(), (int)blueprint.getSizeY(), (int)blueprint.getSizeZ());
            BlockPos boxEndPos = boxStartPos.m_141952_((Vec3i)size).m_141950_((Vec3i)new BlockPos(1, 1, 1));
            blueprint.setRenderSource(buildingView.getID());
            if (buildingView.getBuildingLevel() < buildingView.getBuildingMaxLevel()) {
                newCache.put(currentPosition, new RenderData(blueprint, boxStartPos, boxEndPos));
                continue;
            }
            newCache.put(currentPosition, new RenderData(null, boxStartPos, boxEndPos));
        }
        blueprintCache = newCache;
    }

    private record RenderData(Blueprint blueprint, BlockPos boxStartPos, BlockPos boxEndPos) {
    }
}

