/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.minecolonies.api.colony.ColonyState;
import com.minecolonies.api.colony.CompactColonyReference;
import com.minecolonies.api.colony.ICitizenDataManager;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.IVisitorViewData;
import com.minecolonies.api.colony.buildings.registry.IBuildingDataManager;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.colony.managers.interfaces.ICitizenManager;
import com.minecolonies.api.colony.managers.interfaces.IColonyPackageManager;
import com.minecolonies.api.colony.managers.interfaces.IEventDescriptionManager;
import com.minecolonies.api.colony.managers.interfaces.IEventManager;
import com.minecolonies.api.colony.managers.interfaces.IGraveManager;
import com.minecolonies.api.colony.managers.interfaces.IProgressManager;
import com.minecolonies.api.colony.managers.interfaces.IRaiderManager;
import com.minecolonies.api.colony.managers.interfaces.IRegisteredStructureManager;
import com.minecolonies.api.colony.managers.interfaces.IReproductionManager;
import com.minecolonies.api.colony.managers.interfaces.IVisitorManager;
import com.minecolonies.api.colony.permissions.ColonyPlayer;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.colony.workorders.WorkOrderView;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.research.IResearchManager;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.GraveManagerView;
import com.minecolonies.coremod.colony.VisitorDataView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.coremod.colony.managers.ResearchManager;
import com.minecolonies.coremod.colony.permissions.PermissionsView;
import com.minecolonies.coremod.colony.requestsystem.management.manager.StandardRequestManager;
import com.minecolonies.coremod.colony.workorders.AbstractWorkOrder;
import com.minecolonies.coremod.network.messages.PermissionsMessage;
import com.minecolonies.coremod.network.messages.server.colony.ColonyFlagChangeMessage;
import com.minecolonies.coremod.network.messages.server.colony.TownHallRenameMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColonyView
implements IColonyView {
    private static final int REQUEST_MANAGER_MAX_SIZE = 700000;
    private final int id;
    private final Map<Integer, WorkOrderView> workOrders = new HashMap<Integer, WorkOrderView>();
    @NotNull
    private final PermissionsView permissions = new PermissionsView();
    @NotNull
    private final Map<BlockPos, IBuildingView> buildings = new HashMap<BlockPos, IBuildingView>();
    @NotNull
    private final Map<Integer, ICitizenDataView> citizens = new HashMap<Integer, ICitizenDataView>();
    private Map<Integer, IVisitorViewData> visitors = new HashMap<Integer, IVisitorViewData>();
    private String name = "Unknown";
    private ResourceKey<Level> dimensionId;
    private ChatFormatting teamColonyColor = ChatFormatting.WHITE;
    private ListTag colonyFlag = new BannerPattern.Builder().m_58588_(BannerPattern.BASE, DyeColor.WHITE).m_58587_();
    private BlockPos center = BlockPos.f_121853_;
    private boolean manualHiring = false;
    private boolean manualHousing = false;
    private boolean moveIn = true;
    @Nullable
    private ITownHallView townHall;
    private int citizenCount = 0;
    private int citizenCountWithEmptyGuardTowers = 0;
    private boolean hasColonyWarehouse;
    private final List<BlockPos> lastSpawnPoints = new ArrayList<BlockPos>();
    private final Set<BlockPos> freePositions = new HashSet<BlockPos>();
    private final Set<Block> freeBlocks = new HashSet<Block>();
    private final Map<BlockPos, BlockState> wayPoints = new HashMap<BlockPos, BlockState>();
    private double overallHappiness = 5.0;
    private int lastContactInHours = 0;
    private IRequestManager requestManager;
    private boolean isUnderRaid;
    private Level world;
    private boolean printProgress;
    private long mercenaryLastUseTime = 0L;
    private String style = "";
    private List<CompactColonyReference> allies;
    private List<CompactColonyReference> feuds;
    private final IResearchManager manager;
    private boolean spiesEnabled;
    private Set<Long> ticketedChunks = new HashSet<Long>();
    private String textureStyle;
    private final IGraveManager graveManager = new GraveManagerView();

    private ColonyView(int id) {
        this.id = id;
        this.manager = new ResearchManager(this);
    }

    @NotNull
    public static ColonyView createFromNetwork(int id) {
        return new ColonyView(id);
    }

    public static void serializeNetworkData(@NotNull Colony colony, @NotNull FriendlyByteBuf buf, boolean hasNewSubscribers) {
        buf.m_130070_(colony.getName());
        buf.m_130070_(colony.getDimension().m_135782_().toString());
        buf.m_130064_(colony.getCenter());
        buf.writeBoolean(colony.isManualHiring());
        buf.writeInt(colony.getCitizenManager().getMaxCitizens());
        buf.writeInt(colony.getCitizenManager().getPotentialMaxCitizens());
        Set<Block> freeBlocks = colony.getFreeBlocks();
        Set<BlockPos> freePos = colony.getFreePositions();
        Map<BlockPos, BlockState> waypoints = colony.getWayPoints();
        buf.writeInt(freeBlocks.size());
        for (Block block : freeBlocks) {
            buf.m_130070_(block.getRegistryName().toString());
        }
        buf.writeInt(freePos.size());
        for (BlockPos blockPos : freePos) {
            buf.m_130064_(blockPos);
        }
        buf.writeDouble(colony.getOverallHappiness());
        buf.writeBoolean(colony.hasWarehouse());
        buf.writeInt(waypoints.size());
        for (Map.Entry entry : waypoints.entrySet()) {
            buf.m_130064_((BlockPos)entry.getKey());
            buf.writeInt(Block.m_49956_((BlockState)((BlockState)entry.getValue())));
        }
        buf.writeInt(colony.getLastContactInHours());
        buf.writeBoolean(colony.isManualHousing());
        buf.writeBoolean(colony.canMoveIn());
        buf.m_130070_(colony.getTextureStyleId());
        if (colony.getRequestManager() != null && (colony.getRequestManager().isDirty() || hasNewSubscribers)) {
            int preSize = buf.writerIndex();
            buf.writeBoolean(true);
            colony.getRequestManager().serialize(StandardFactoryController.getInstance(), buf);
            int n = buf.writerIndex();
            if (n - preSize >= 700000) {
                Log.getLogger().warn("Colony " + colony.getID() + " has a very big memory imprint, this could be a memory leak, please contact the mod author!");
            }
        } else {
            buf.writeBoolean(false);
        }
        buf.writeInt(colony.getRaiderManager().getLastSpawnPoints().size());
        for (BlockPos blockPos : colony.getRaiderManager().getLastSpawnPoints()) {
            buf.m_130064_(blockPos);
        }
        buf.writeInt(colony.getTeamColonyColor().ordinal());
        CompoundTag flagNBT = new CompoundTag();
        flagNBT.m_128365_("Patterns", (Tag)colony.getColonyFlag());
        buf.m_130079_(flagNBT);
        buf.writeBoolean(colony.getProgressManager().isPrintingProgress());
        buf.writeLong(colony.getMercenaryUseTime());
        buf.m_130070_(colony.getStyle());
        buf.writeBoolean(colony.getRaiderManager().isRaided());
        buf.writeBoolean(colony.getRaiderManager().areSpiesEnabled());
        ArrayList<IColony> arrayList = new ArrayList<IColony>();
        for (ColonyPlayer colonyPlayer : colony.getPermissions().getFilteredPlayers(Rank::isColonyManager)) {
            IColony iColony = IColonyManager.getInstance().getIColonyByOwner(colony.getWorld(), colonyPlayer.getID());
            if (iColony == null) continue;
            for (ColonyPlayer owner : colony.getPermissions().getPlayersByRank(colony.getPermissions().getRankOwner())) {
                if (!iColony.getPermissions().getRank(owner.getID()).isColonyManager() || iColony.getID() == colony.getID()) continue;
                arrayList.add(iColony);
            }
        }
        buf.writeInt(arrayList.size());
        for (IColony iColony : arrayList) {
            buf.m_130070_(iColony.getName());
            buf.m_130064_(iColony.getCenter());
            buf.writeInt(iColony.getID());
            buf.writeBoolean(iColony.hasTownHall());
            buf.m_130070_(iColony.getDimension().m_135782_().toString());
        }
        ArrayList<IColony> feuds = new ArrayList<IColony>();
        for (ColonyPlayer colonyPlayer : colony.getPermissions().getFilteredPlayers(Rank::isHostile)) {
            IColony col3 = IColonyManager.getInstance().getIColonyByOwner(colony.getWorld(), colonyPlayer.getID());
            if (col3 == null) continue;
            for (ColonyPlayer owner : colony.getPermissions().getPlayersByRank(colony.getPermissions().getRankOwner())) {
                if (!col3.getPermissions().getRank(owner.getID()).isHostile()) continue;
                feuds.add(col3);
            }
        }
        buf.writeInt(feuds.size());
        for (IColony iColony : feuds) {
            buf.m_130070_(iColony.getName());
            buf.m_130064_(iColony.getCenter());
            buf.writeInt(iColony.getID());
            buf.m_130070_(iColony.getDimension().m_135782_().toString());
        }
        CompoundTag compoundTag = new CompoundTag();
        colony.getResearchManager().writeToNBT(compoundTag);
        buf.m_130079_(compoundTag);
        if (hasNewSubscribers || colony.isTicketedChunksDirty()) {
            buf.writeInt(colony.getTicketedChunks().size());
            for (long pos : colony.getTicketedChunks()) {
                buf.writeLong(pos);
            }
        } else {
            buf.writeInt(-1);
        }
        CompoundTag compoundTag2 = new CompoundTag();
        colony.getGraveManager().write(compoundTag2);
        buf.m_130079_(compoundTag2);
    }

    @Override
    public List<BlockPos> getFreePositions() {
        return new ArrayList<BlockPos>(this.freePositions);
    }

    @Override
    public List<Block> getFreeBlocks() {
        return new ArrayList<Block>(this.freeBlocks);
    }

    @Override
    public void addFreePosition(@NotNull BlockPos pos) {
        this.freePositions.add(pos);
    }

    @Override
    public void addFreeBlock(@NotNull Block block) {
        this.freeBlocks.add(block);
    }

    @Override
    public void removeFreePosition(@NotNull BlockPos pos) {
        this.freePositions.remove(pos);
    }

    @Override
    public void removeFreeBlock(@NotNull Block block) {
        this.freeBlocks.remove(block);
    }

    @Override
    public void setCanBeAutoDeleted(boolean canBeDeleted) {
    }

    @Override
    public ResourceKey<Level> getDimension() {
        return this.dimensionId;
    }

    @Override
    public boolean isManualHiring() {
        return this.manualHiring;
    }

    @Override
    public void setManualHiring(boolean manualHiring) {
        this.manualHiring = manualHiring;
    }

    @Override
    public CompoundTag write(CompoundTag colonyCompound) {
        return new CompoundTag();
    }

    @Override
    public void read(CompoundTag compound) {
    }

    @Override
    public boolean isManualHousing() {
        return this.manualHousing;
    }

    @Override
    public void setManualHousing(boolean manualHousing) {
        this.manualHousing = manualHousing;
    }

    @Override
    public void addWayPoint(BlockPos pos, BlockState newWayPointState) {
    }

    @Override
    public boolean isValidAttackingGuard(AbstractEntityCitizen entity) {
        return false;
    }

    @Override
    public boolean canMoveIn() {
        return this.moveIn;
    }

    @Override
    public boolean useAdditionalChildTime(int amount) {
        return false;
    }

    @Override
    public void updateHasChilds() {
    }

    @Override
    public void addLoadedChunk(long chunkPos, LevelChunk chunk) {
    }

    @Override
    public void removeLoadedChunk(long chunkPos) {
    }

    @Override
    public int getLoadedChunkCount() {
        return 0;
    }

    @Override
    public ColonyState getState() {
        return null;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public Set<Long> getTicketedChunks() {
        return this.ticketedChunks;
    }

    @Override
    public void setTextureStyle(String style) {
        this.textureStyle = style;
    }

    @Override
    public String getTextureStyleId() {
        return this.textureStyle;
    }

    @Override
    public void notifyPlayers(Component component) {
    }

    @Override
    public void notifyColonyManagers(Component component) {
    }

    @Override
    public void setMoveIn(boolean newMoveIn) {
        this.moveIn = newMoveIn;
    }

    @Override
    @Nullable
    public ITownHallView getTownHall() {
        return this.townHall;
    }

    @Override
    public IBuildingView getBuilding(int x, int y, int z) {
        return this.getBuilding(new BlockPos(x, y, z));
    }

    @Override
    public IBuildingView getBuilding(BlockPos buildingId) {
        return this.buildings.get(buildingId);
    }

    @Override
    @NotNull
    public Map<UUID, ColonyPlayer> getPlayers() {
        return this.permissions.getPlayers();
    }

    @Override
    public int getCitizenCount() {
        return this.citizenCount;
    }

    @Override
    public int getCitizenCountLimit() {
        return this.citizenCountWithEmptyGuardTowers;
    }

    @Override
    public Map<Integer, ICitizenDataView> getCitizens() {
        return Collections.unmodifiableMap(this.citizens);
    }

    @Override
    public Collection<WorkOrderView> getWorkOrders() {
        return Collections.unmodifiableCollection(this.workOrders.values());
    }

    @Override
    public ICitizenDataView getCitizen(int id) {
        if (id > 0) {
            return this.citizens.get(id);
        }
        return this.visitors.get(id);
    }

    @Override
    @Nullable
    public IMessage handleColonyViewMessage(@NotNull FriendlyByteBuf buf, @NotNull Level world, boolean isNewSubscription) {
        this.world = world;
        this.name = buf.m_130136_(Short.MAX_VALUE);
        this.dimensionId = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(buf.m_130136_(Short.MAX_VALUE)));
        this.center = buf.m_130135_();
        this.manualHiring = buf.readBoolean();
        this.citizenCount = buf.readInt();
        this.citizenCountWithEmptyGuardTowers = buf.readInt();
        if (isNewSubscription) {
            this.citizens.clear();
            this.townHall = null;
            this.buildings.clear();
        }
        this.freePositions.clear();
        this.freeBlocks.clear();
        this.wayPoints.clear();
        this.lastSpawnPoints.clear();
        int blockListSize = buf.readInt();
        for (int i = 0; i < blockListSize; ++i) {
            this.freeBlocks.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(buf.m_130136_(Short.MAX_VALUE))));
        }
        int posListSize = buf.readInt();
        for (int i = 0; i < posListSize; ++i) {
            this.freePositions.add(buf.m_130135_());
        }
        this.overallHappiness = buf.readDouble();
        this.hasColonyWarehouse = buf.readBoolean();
        int wayPointListSize = buf.readInt();
        for (int i = 0; i < wayPointListSize; ++i) {
            this.wayPoints.put(buf.m_130135_(), Block.m_49803_((int)buf.readInt()));
        }
        this.lastContactInHours = buf.readInt();
        this.manualHousing = buf.readBoolean();
        this.moveIn = buf.readBoolean();
        this.textureStyle = buf.m_130136_(Short.MAX_VALUE);
        if (buf.readBoolean()) {
            this.requestManager = new StandardRequestManager(this);
            this.requestManager.deserialize(StandardFactoryController.getInstance(), buf);
        }
        int barbSpawnListSize = buf.readInt();
        for (int i = 0; i < barbSpawnListSize; ++i) {
            this.lastSpawnPoints.add(buf.m_130135_());
        }
        Collections.reverse(this.lastSpawnPoints);
        this.teamColonyColor = ChatFormatting.values()[buf.readInt()];
        this.colonyFlag = buf.m_130260_().m_128437_("Patterns", 10);
        this.printProgress = buf.readBoolean();
        this.mercenaryLastUseTime = buf.readLong();
        this.style = buf.m_130136_(Short.MAX_VALUE);
        this.isUnderRaid = buf.readBoolean();
        this.spiesEnabled = buf.readBoolean();
        this.allies = new ArrayList<CompactColonyReference>();
        this.feuds = new ArrayList<CompactColonyReference>();
        int noOfAllies = buf.readInt();
        for (int i = 0; i < noOfAllies; ++i) {
            this.allies.add(new CompactColonyReference(buf.m_130136_(Short.MAX_VALUE), buf.m_130135_(), buf.readInt(), buf.readBoolean(), (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(buf.m_130136_(Short.MAX_VALUE)))));
        }
        int noOfFeuds = buf.readInt();
        for (int i = 0; i < noOfFeuds; ++i) {
            this.feuds.add(new CompactColonyReference(buf.m_130136_(Short.MAX_VALUE), buf.m_130135_(), buf.readInt(), false, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(buf.m_130136_(Short.MAX_VALUE)))));
        }
        this.manager.readFromNBT(buf.m_130260_());
        int ticketChunkCount = buf.readInt();
        if (ticketChunkCount != -1) {
            this.ticketedChunks = new HashSet<Long>(ticketChunkCount);
            for (int i = 0; i < ticketChunkCount; ++i) {
                this.ticketedChunks.add(buf.readLong());
            }
        }
        this.graveManager.read(buf.m_130260_());
        return null;
    }

    @Override
    @Nullable
    public IMessage handlePermissionsViewMessage(@NotNull FriendlyByteBuf buf) {
        this.permissions.deserialize(buf);
        return null;
    }

    @Override
    @Nullable
    public IMessage handleColonyViewWorkOrderMessage(FriendlyByteBuf buf) {
        this.workOrders.clear();
        int amount = buf.readInt();
        for (int i = 0; i < amount; ++i) {
            @Nullable WorkOrderView workOrder = AbstractWorkOrder.createWorkOrderView(buf);
            if (workOrder == null) continue;
            this.workOrders.put(workOrder.getId(), workOrder);
        }
        return null;
    }

    @Override
    @Nullable
    public IMessage handleColonyViewCitizensMessage(int id, FriendlyByteBuf buf) {
        ICitizenDataView citizen = ICitizenDataManager.getInstance().createFromNetworkData(id, buf, this);
        if (citizen != null) {
            this.citizens.put(citizen.getId(), citizen);
        }
        return null;
    }

    @Override
    public void handleColonyViewVisitorMessage(FriendlyByteBuf visitorBuf, boolean refresh) {
        HashMap<Integer, IVisitorViewData> visitorCache = new HashMap<Integer, IVisitorViewData>(this.visitors);
        if (refresh) {
            this.visitors.clear();
        }
        int i = visitorBuf.readInt();
        for (int j = 0; j < i; ++j) {
            int id = visitorBuf.readInt();
            IVisitorViewData dataView = visitorCache.containsKey(id) ? (IVisitorViewData)visitorCache.get(id) : new VisitorDataView(id, this);
            dataView.deserialize(visitorBuf);
            this.visitors.put(dataView.getId(), dataView);
        }
    }

    @Override
    @Nullable
    public IMessage handleColonyViewRemoveCitizenMessage(int citizen) {
        this.citizens.remove(citizen);
        return null;
    }

    @Override
    @Nullable
    public IMessage handleColonyViewRemoveBuildingMessage(BlockPos buildingId) {
        IBuildingView building = this.buildings.remove(buildingId);
        if (this.townHall == building) {
            this.townHall = null;
        }
        return null;
    }

    @Override
    @Nullable
    public IMessage handleColonyViewRemoveWorkOrderMessage(int workOrderId) {
        this.workOrders.remove(workOrderId);
        return null;
    }

    @Override
    @Nullable
    public IMessage handleColonyBuildingViewMessage(BlockPos buildingId, @NotNull FriendlyByteBuf buf) {
        if (this.buildings.containsKey(buildingId)) {
            buf.m_130136_(Short.MAX_VALUE);
            this.buildings.get(buildingId).deserialize(buf);
        } else {
            @Nullable IBuildingView building = IBuildingDataManager.getInstance().createViewFrom(this, buildingId, buf);
            if (building != null) {
                this.buildings.put(building.getID(), building);
                if (building instanceof BuildingTownHall.View) {
                    this.townHall = (ITownHallView)building;
                }
            }
        }
        return null;
    }

    @Override
    public void addPlayer(String player) {
        Network.getNetwork().sendToServer(new PermissionsMessage.AddPlayer(this, player));
    }

    @Override
    public void removePlayer(UUID player) {
        Network.getNetwork().sendToServer(new PermissionsMessage.RemovePlayer(this, player));
    }

    @Override
    public double getOverallHappiness() {
        return this.overallHappiness;
    }

    @Override
    public BlockPos getCenter() {
        return this.center;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ChatFormatting getTeamColonyColor() {
        return this.teamColonyColor;
    }

    @Override
    public ListTag getColonyFlag() {
        return this.colonyFlag;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        Network.getNetwork().sendToServer(new TownHallRenameMessage(this, name));
    }

    @Override
    @NotNull
    public IPermissions getPermissions() {
        return this.permissions;
    }

    @Override
    public boolean isCoordInColony(@NotNull Level w, @NotNull BlockPos pos) {
        LevelChunk chunk = w.m_46745_(pos);
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(CLOSE_COLONY_CAP, null).orElseGet(null);
        return cap.getOwningColony() == this.getID();
    }

    @Override
    public long getDistanceSquared(@NotNull BlockPos pos) {
        return BlockPosUtil.getDistanceSquared2D(this.center, pos);
    }

    @Override
    public boolean hasTownHall() {
        return this.townHall != null;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public boolean hasWarehouse() {
        return this.hasColonyWarehouse;
    }

    @Override
    public boolean hasBuilding(String name, int level, boolean singleBuilding) {
        int sum = 0;
        for (IBuildingView building : this.buildings.values()) {
            if (!building.getBuildingType().getRegistryName().m_135815_().equalsIgnoreCase(name) || !(singleBuilding ? building.getBuildingLevel() >= level : (sum += building.getBuildingLevel()) >= level)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDay() {
        return false;
    }

    @Override
    public PlayerTeam getTeam() {
        return this.world.m_6188_().m_83489_(this.getTeamName());
    }

    @Override
    public int getLastContactInHours() {
        return this.lastContactInHours;
    }

    @Override
    public Level getWorld() {
        return this.world;
    }

    @Override
    @NotNull
    public IRequestManager getRequestManager() {
        return this.requestManager;
    }

    @Override
    public void markDirty() {
    }

    @Override
    public boolean canBeAutoDeleted() {
        return false;
    }

    @Override
    @Nullable
    public IRequester getRequesterBuildingForPosition(@NotNull BlockPos pos) {
        return this.getBuilding(pos);
    }

    @Override
    public void removeVisitingPlayer(Player player) {
    }

    @Override
    @NotNull
    public List<Player> getMessagePlayerEntities() {
        return new ArrayList<Player>();
    }

    @Override
    public void addVisitingPlayer(Player player) {
    }

    @Override
    public void onWorldLoad(@NotNull Level w) {
    }

    @Override
    public void onWorldUnload(@NotNull Level w) {
    }

    @Override
    public void onServerTick(@NotNull TickEvent.ServerTickEvent event) {
    }

    @Override
    @NotNull
    public IWorkManager getWorkManager() {
        return null;
    }

    @Override
    public void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
    }

    @Override
    public Map<BlockPos, BlockState> getWayPoints() {
        return this.wayPoints;
    }

    @Override
    public List<BlockPos> getLastSpawnPoints() {
        return new ArrayList<BlockPos>(this.lastSpawnPoints);
    }

    @Override
    public boolean isPrintingProgress() {
        return this.printProgress;
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public CompoundTag getColonyTag() {
        return null;
    }

    @Override
    public boolean isColonyUnderAttack() {
        return false;
    }

    @Override
    public boolean isValidAttackingPlayer(Player entity) {
        return false;
    }

    @Override
    public void addGuardToAttackers(AbstractEntityCitizen entityCitizen, Player followPlayer) {
    }

    @Override
    public void setColonyColor(ChatFormatting color) {
    }

    @Override
    public void setColonyFlag(ListTag colonyFlag) {
        this.colonyFlag = colonyFlag;
        Network.getNetwork().sendToServer(new ColonyFlagChangeMessage(this, colonyFlag));
    }

    @Override
    public List<IBuildingView> getBuildings() {
        return new ArrayList<IBuildingView>(this.buildings.values());
    }

    @Override
    @NotNull
    public List<Player> getImportantMessageEntityPlayers() {
        return new ArrayList<Player>();
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(String style) {
    }

    @Override
    public IRegisteredStructureManager getBuildingManager() {
        return null;
    }

    @Override
    public IGraveManager getGraveManager() {
        return this.graveManager;
    }

    @Override
    public ICitizenManager getCitizenManager() {
        return null;
    }

    @Override
    public IVisitorManager getVisitorManager() {
        return null;
    }

    @Override
    public IRaiderManager getRaiderManager() {
        return null;
    }

    @Override
    public IEventManager getEventManager() {
        return null;
    }

    @Override
    public IReproductionManager getReproductionManager() {
        return null;
    }

    @Override
    public IEventDescriptionManager getEventDescriptionManager() {
        return null;
    }

    @Override
    public IColonyPackageManager getPackageManager() {
        return null;
    }

    @Override
    public IProgressManager getProgressManager() {
        return null;
    }

    @Override
    public boolean isRaiding() {
        return this.isUnderRaid;
    }

    @Override
    public long getMercenaryUseTime() {
        return this.mercenaryLastUseTime;
    }

    @Override
    public void usedMercenaries() {
        this.mercenaryLastUseTime = this.world.m_46467_();
    }

    @Override
    public List<CompactColonyReference> getAllies() {
        return this.allies;
    }

    @Override
    public List<CompactColonyReference> getFeuds() {
        return this.feuds;
    }

    @Override
    public IResearchManager getResearchManager() {
        return this.manager;
    }

    @Override
    public boolean areSpiesEnabled() {
        return this.spiesEnabled;
    }

    @Override
    public ICitizenDataView getVisitor(int citizenId) {
        return this.visitors.get(citizenId);
    }
}

