/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.colony.CitizenData;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class VisitorData
extends CitizenData
implements IVisitorData {
    private static final String TAG_RECRUIT_COST = "rcost";
    private static final String TAG_RECRUIT_COST_QTY = "rcostqty";
    private BlockPos sittingPosition = BlockPos.f_121853_;
    private ItemStack recruitCost = ItemStack.f_41583_;
    private UUID textureUUID;

    public VisitorData(int id, IColony colony) {
        super(id, colony);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compoundNBT = super.serializeNBT();
        CompoundTag item = new CompoundTag();
        this.recruitCost.m_41739_(item);
        compoundNBT.m_128365_(TAG_RECRUIT_COST, (Tag)item);
        compoundNBT.m_128405_(TAG_RECRUIT_COST_QTY, this.recruitCost.m_41613_());
        BlockPosUtil.write(compoundNBT, "sit", this.sittingPosition);
        if (this.textureUUID != null) {
            compoundNBT.m_128362_("textureUUID", this.textureUUID);
        }
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundTag nbtTagCompound) {
        super.deserializeNBT(nbtTagCompound);
        this.sittingPosition = BlockPosUtil.read(nbtTagCompound, "sit");
        this.recruitCost = ItemStack.m_41712_((CompoundTag)nbtTagCompound.m_128469_(TAG_RECRUIT_COST));
        this.recruitCost.m_41764_(nbtTagCompound.m_128451_(TAG_RECRUIT_COST_QTY));
        if (nbtTagCompound.m_128441_("textureUUID")) {
            this.textureUUID = nbtTagCompound.m_128342_("textureUUID");
        }
    }

    @Override
    public void setRecruitCosts(ItemStack item) {
        this.recruitCost = item;
    }

    @Override
    public ItemStack getRecruitCost() {
        return this.recruitCost;
    }

    public static IVisitorData loadVisitorFromNBT(IColony colony, CompoundTag nbt) {
        VisitorData data = new VisitorData(nbt.m_128451_("id"), colony);
        data.deserializeNBT((Tag)nbt);
        return data;
    }

    @Override
    public void serializeViewNetworkData(@NotNull FriendlyByteBuf buf) {
        super.serializeViewNetworkData(buf);
        buf.m_130055_(this.recruitCost);
        buf.writeInt(this.recruitCost.m_41613_());
        if (this.textureUUID == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.m_130077_(this.textureUUID);
        }
    }

    @Override
    public BlockPos getSittingPosition() {
        return this.sittingPosition;
    }

    @Override
    public void setSittingPosition(BlockPos pos) {
        this.sittingPosition = pos;
    }

    @Override
    public void updateEntityIfNecessary() {
        BlockPos spawnPos;
        Entity entity;
        if (this.getEntity().isPresent() && (entity = (Entity)this.getEntity().get()).m_6084_() && WorldUtil.isEntityBlockLoaded((LevelAccessor)entity.f_19853_, entity.m_142538_())) {
            return;
        }
        if (this.getLastPosition() != BlockPos.f_121853_ && this.getLastPosition().m_123341_() != 0 && this.getLastPosition().m_123343_() != 0 && WorldUtil.isEntityBlockLoaded((LevelAccessor)this.getColony().getWorld(), this.getLastPosition())) {
            this.getColony().getVisitorManager().spawnOrCreateCivilian(this, this.getColony().getWorld(), this.getLastPosition(), true);
        } else if (this.getHomeBuilding() != null && WorldUtil.isEntityBlockLoaded((LevelAccessor)this.getColony().getWorld(), this.getHomeBuilding().getID()) && (spawnPos = BlockPosUtil.findSpawnPosAround(this.getColony().getWorld(), this.getHomeBuilding().getID())) != null) {
            this.getColony().getVisitorManager().spawnOrCreateCivilian(this, this.getColony().getWorld(), spawnPos, true);
        }
    }

    @Override
    public void applyResearchEffects() {
    }

    @Override
    public void setCustomTexture(UUID texture) {
        this.textureUUID = texture;
    }

    @Override
    public boolean hasCustomTexture() {
        return this.textureUUID != null;
    }
}

