/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules.settings;

import com.ldtteam.blockui.Loader;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.View;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingsModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.coremod.colony.buildings.modules.settings.StringSetting;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlantationSetting
extends StringSetting {
    public static final String SUGAR_CANE_AND_CACTUS = Items.f_41909_.m_5524_() + "/" + Items.f_41982_.m_5524_();
    public static final String CACTUS_AND_BAMBOO = Items.f_41982_.m_5524_() + "/" + Items.f_41911_.m_5524_();
    public static final String BAMBOO_AND_SUGAR_CANE = Items.f_41911_.m_5524_() + "/" + Items.f_41909_.m_5524_();
    private static final String SPLIT_TOKEN = "/";
    private boolean hasResearch;

    public PlantationSetting(String ... settings) {
        super(settings);
    }

    public PlantationSetting(List<String> settings, int currentIndex) {
        super(settings, currentIndex);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setupHandler(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, BOWindow window) {
        this.hasResearch = building.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.PLANT_2) > 0.0;
        Loader.createFromXMLFile((ResourceLocation)new ResourceLocation("minecolonies:gui/layouthuts/layoutstringsetting.xml"), (View)((View)pane));
        ((Text)pane.findPaneOfTypeByID("id", Text.class)).setText((MutableComponent)new TextComponent(key.getUniqueId().toString()));
        ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setHandler(button -> settingsModuleView.trigger(key));
    }

    @Override
    public void render(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, BOWindow window) {
        ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setText(this.getCombinedSetting());
    }

    @Override
    public boolean isIndexAllowed(int index) {
        boolean isAllowed = super.isIndexAllowed(index);
        if (!isAllowed) {
            return false;
        }
        int maxSplitTokens = this.hasResearch ? 1 : 0;
        String[] split = this.getSettings().get(index).split(SPLIT_TOKEN);
        return split.length - 1 <= maxSplitTokens;
    }

    private MutableComponent getCombinedSetting() {
        String[] inputSplit = this.getSettings().get(this.getCurrentIndex()).split(SPLIT_TOKEN);
        TranslatableComponent component = new TranslatableComponent("");
        for (int idx = 0; idx < inputSplit.length; ++idx) {
            component.m_7220_((Component)new TranslatableComponent(inputSplit[idx]));
            if (idx == inputSplit.length - 1) continue;
            component.m_130946_(" & ");
        }
        return component;
    }
}

