/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules.settings;

import com.ldtteam.blockui.Loader;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.View;
import com.minecolonies.api.colony.buildings.modules.settings.ISetting;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingsModuleView;
import com.minecolonies.api.colony.buildings.modules.settings.IStringSetting;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StringSetting
implements IStringSetting {
    private final List<String> settings;
    protected int currentIndex;

    public StringSetting(String ... settings) {
        this.settings = Arrays.asList(settings);
        this.currentIndex = 0;
    }

    public StringSetting(List<String> settings, int currentIndex) {
        this.settings = settings;
        this.currentIndex = currentIndex;
    }

    @Override
    public String getValue() {
        return this.settings.get(this.currentIndex);
    }

    @Override
    public String getDefault() {
        return this.settings.get(0);
    }

    @Override
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public List<String> getSettings() {
        return new ArrayList<String>(this.settings);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setupHandler(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, BOWindow window) {
        Loader.createFromXMLFile((ResourceLocation)new ResourceLocation("minecolonies:gui/layouthuts/layoutstringsetting.xml"), (View)((View)pane));
        ((Text)pane.findPaneOfTypeByID("id", Text.class)).setText(key.getUniqueId().toString());
        ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setHandler(button -> settingsModuleView.trigger(key));
    }

    @Override
    public void render(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, BOWindow window) {
        ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setText((MutableComponent)new TranslatableComponent(this.settings.get(this.currentIndex)));
    }

    @Override
    public void trigger() {
        boolean hasAllowedValue = false;
        for (int i = 0; i < this.settings.size(); ++i) {
            ++this.currentIndex;
            if (this.currentIndex >= this.settings.size()) {
                this.currentIndex = 0;
            }
            if (!this.isIndexAllowed(this.currentIndex)) continue;
            hasAllowedValue = true;
            break;
        }
        if (!hasAllowedValue) {
            Log.getLogger().warn(this.getClass().getName() + " could not select any allowed value, currentIndex is reset to 0, please report this to the developers.");
            this.currentIndex = 0;
        }
    }

    public boolean isIndexAllowed(int index) {
        return index >= 0 && index < this.settings.size();
    }

    @Override
    public void updateSetting(ISetting iSetting) {
        if (iSetting instanceof StringSetting) {
            this.settings.clear();
            this.settings.addAll(((StringSetting)iSetting).settings);
            if (this.currentIndex >= this.settings.size()) {
                this.currentIndex = this.settings.size() - 1;
            }
        }
    }

    @Override
    public void set(String value) {
        this.currentIndex = this.getSettings().indexOf(value);
    }
}

