/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBarracks;
import com.minecolonies.coremod.util.AdvancementUtils;
import com.minecolonies.coremod.util.ChunkDataHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class BuildingBarracksTower
extends AbstractBuildingGuards {
    private static final String TAG_POS = "pos";
    private static final String SCHEMATIC_NAME = "barrackstower";
    private BlockPos barracks = null;

    public BuildingBarracksTower(@NotNull IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SCHEMATIC_NAME;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void requestUpgrade(Player player, BlockPos builder) {
        int buildingLevel = this.getBuildingLevel();
        IBuilding building = this.getColony().getBuildingManager().getBuilding(this.barracks);
        if (building != null && buildingLevel < this.getMaxBuildingLevel() && buildingLevel < building.getBuildingLevel()) {
            this.requestWorkOrder(buildingLevel + 1, builder, false);
        } else {
            player.m_6352_((Component)new TranslatableComponent("com.minecolonies.coremod.worker.needbarracks"), player.m_142081_());
        }
    }

    @Override
    public boolean canDeconstruct() {
        return false;
    }

    @Override
    public int getClaimRadius(int newLevel) {
        return 0;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        IBuilding barrack = this.colony.getBuildingManager().getBuilding(this.barracks);
        if (barrack == null) {
            return;
        }
        ChunkDataHelper.claimColonyChunks(this.colony, true, this.barracks, barrack.getClaimRadius(newLevel));
        if (newLevel == barrack.getMaxBuildingLevel()) {
            boolean allUpgraded = true;
            for (BlockPos tower : ((BuildingBarracks)barrack).getTowers()) {
                Log.getLogger().info("Upgraded: " + allUpgraded);
                if (this.colony.getBuildingManager().getBuilding(tower).getBuildingLevel() == barrack.getMaxBuildingLevel()) continue;
                allUpgraded = false;
            }
            if (allUpgraded) {
                AdvancementUtils.TriggerAdvancementPlayersForColony(this.colony, AdvancementTriggers.ALL_TOWERS::trigger);
            }
        }
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        this.barracks = NbtUtils.m_129239_((CompoundTag)compound.m_128469_(TAG_POS));
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        if (this.barracks != null) {
            compound.m_128365_(TAG_POS, (Tag)NbtUtils.m_129224_((BlockPos)this.barracks));
        }
        return compound;
    }

    public void addBarracks(BlockPos pos) {
        this.barracks = pos;
    }
}

