/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.compatibility.CompatibilityManager;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AnimalHerdingModule;
import com.minecolonies.coremod.colony.buildings.modules.settings.BeekeeperCollectionSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.coremod.colony.crafting.LootTableAnalyzer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class BuildingBeekeeper
extends AbstractBuilding {
    public static final ISettingKey<BeekeeperCollectionSetting> MODE = new SettingKey<BeekeeperCollectionSetting>(BeekeeperCollectionSetting.class, new ResourceLocation("minecolonies", "beekeeper"));
    public static final String HONEYCOMB = "com.minecolonies.core.apiary.setting.honeycomb";
    public static final String HONEY = "com.minecolonies.core.apiary.setting.honey";
    public static final String BOTH = "com.minecolonies.core.apiary.setting.both";
    private static final String BEEKEEPER = "beekeeper";
    private Set<BlockPos> hives = new HashSet<BlockPos>();

    public BuildingBeekeeper(@NotNull IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(stack -> Items.f_42574_ == stack.m_41720_(), new Tuple((Object)1, (Object)true));
        this.keepX.put(stack -> Items.f_42590_ == stack.m_41720_(), new Tuple((Object)4, (Object)true));
        this.keepX.put(stack -> ItemTags.f_13149_.m_8110_((Object)stack.m_41720_()), new Tuple((Object)64, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return BEEKEEPER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        NBTUtils.streamCompound(compound.m_128437_("hives", 10)).map(NbtUtils::m_129239_).forEach(this.hives::add);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128365_("hives", (Tag)this.hives.stream().map(NbtUtils::m_129224_).collect(NBTUtils.toListNBT()));
        return nbt;
    }

    @Override
    public void serializeToView(@NotNull FriendlyByteBuf buf) {
        super.serializeToView(buf);
    }

    public Set<BlockPos> getHives() {
        return Collections.unmodifiableSet(new HashSet<BlockPos>(this.hives));
    }

    public void removeHive(BlockPos pos) {
        this.hives.remove(pos);
    }

    public void addHive(BlockPos pos) {
        this.hives.add(pos);
    }

    public String getHarvestTypes() {
        return this.getSetting(MODE).getValue();
    }

    public int getMaximumHives() {
        return (int)Math.pow(2.0, this.getBuildingLevel() - 1);
    }

    public static class HerdingModule
    extends AnimalHerdingModule {
        public HerdingModule() {
            super(ModJobs.beekeeper, EntityType.f_20550_, ItemStack.f_41583_);
        }

        @Override
        @NotNull
        public List<ItemStack> getBreedingItems() {
            if (this.building != null) {
                // empty if block
            }
            return CompatibilityManager.getAllBeekeeperFlowers().stream().map(flower -> new ItemStack((ItemLike)flower.getItem(), 2)).collect(Collectors.toList());
        }

        @Override
        @NotNull
        public List<LootTableAnalyzer.LootDrop> getExpectedLoot() {
            ArrayList<LootTableAnalyzer.LootDrop> drops = new ArrayList<LootTableAnalyzer.LootDrop>(super.getExpectedLoot());
            drops.add(new LootTableAnalyzer.LootDrop(Collections.singletonList(new ItemStack((ItemLike)Items.f_42784_, 3)), 1.0f, 0.0f, false));
            drops.add(new LootTableAnalyzer.LootDrop(Collections.singletonList(new ItemStack((ItemLike)Items.f_42787_)), 1.0f, 0.0f, false));
            return drops;
        }
    }
}

