/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableMap;
import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.huts.WindowHutCrusherModule;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.server.colony.building.crusher.CrusherSetModeMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BuildingCrusher
extends AbstractBuilding {
    private static final double BUILDING_LEVEL_MULTIPLIER = 16.0;
    private static final String CRUSHER_DESC = "crusher";
    private static final int MAX_BUILDING_LEVEL = 5;
    private final Map<ItemStorage, IRecipeStorage> crusherRecipes = new HashMap<ItemStorage, IRecipeStorage>();
    private int dailyQuantity = 0;
    private int currentDailyQuantity = 0;
    private ItemStorage crusherMode = null;
    private boolean oneByOne = false;

    public BuildingCrusher(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        super.onColonyTick(colony);
        if (this.crusherMode == null || this.crusherMode.isEmpty()) {
            this.loadCrusherMode();
        }
    }

    private void loadCrusherMode() {
        CraftingModule module = this.getFirstModuleOccurance(CraftingModule.class);
        this.crusherRecipes.clear();
        ImmutableMap<IToken<?>, IRecipeStorage> recipes = IColonyManager.getInstance().getRecipeManager().getRecipes();
        for (IToken<?> token : module.getRecipes()) {
            IRecipeStorage storage = (IRecipeStorage)recipes.get(token);
            if (storage == null) continue;
            ItemStorage key = storage.getCleanedInput().get(0);
            if (this.crusherMode == null) {
                this.crusherMode = key;
            }
            this.crusherRecipes.put(key, storage);
        }
    }

    public IRecipeStorage getCurrentRecipe() {
        return this.crusherRecipes.get(this.crusherMode);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return CRUSHER_DESC;
    }

    public void setCrusherMode(ItemStorage crusherMode, int dailyQuantity) {
        this.crusherMode = crusherMode;
        this.dailyQuantity = dailyQuantity;
    }

    public Tuple<ItemStorage, Integer> getCrusherMode() {
        return new Tuple((Object)this.crusherMode, (Object)this.dailyQuantity);
    }

    public void setCurrentDailyQuantity(int currentDailyQuantity) {
        this.currentDailyQuantity = currentDailyQuantity;
    }

    public int getMaxDailyQuantity() {
        if (this.getBuildingLevel() >= 5) {
            return Integer.MAX_VALUE;
        }
        return (int)(Math.pow(this.getBuildingLevel(), 2.0) * 16.0);
    }

    @Override
    public void onWakeUp() {
        super.onWakeUp();
        this.currentDailyQuantity = 0;
    }

    public int getCurrentDailyQuantity() {
        return this.currentDailyQuantity;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        this.dailyQuantity = compound.m_128451_("daily");
        this.currentDailyQuantity = compound.m_128451_("currentDaily");
        if (compound.m_128431_().contains("Crushermode")) {
            this.crusherMode = new ItemStorage(ItemStack.m_41712_((CompoundTag)compound.m_128469_("Crushermode")));
        }
        this.oneByOne = compound.m_128471_("Crusherratio");
        this.loadCrusherMode();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        compound.m_128405_("daily", this.dailyQuantity);
        compound.m_128405_("currentDaily", this.currentDailyQuantity);
        if (this.crusherMode != null) {
            CompoundTag crusherModeNBT = new CompoundTag();
            this.crusherMode.getItemStack().m_41739_(crusherModeNBT);
            compound.m_128365_("Crushermode", (Tag)crusherModeNBT);
        }
        compound.m_128379_("Crusherratio", this.oneByOne);
        return compound;
    }

    @Override
    public void serializeToView(@NotNull FriendlyByteBuf buf) {
        boolean oneOne;
        super.serializeToView(buf);
        boolean bl = oneOne = this.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.CRUSHING_11) > 0.0;
        if (this.crusherRecipes.isEmpty() || this.oneByOne != oneOne) {
            this.loadCrusherMode();
        }
        if (this.crusherMode == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.m_130055_(this.crusherMode.getItemStack());
        }
        buf.writeInt(this.dailyQuantity);
        buf.writeInt(this.crusherRecipes.size());
        for (ItemStorage storage : this.crusherRecipes.keySet()) {
            buf.m_130055_(storage.getItemStack());
        }
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Custom {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }
    }

    public static class View
    extends AbstractBuildingView {
        private int dailyQuantity = 0;
        private ItemStorage crusherMode;
        private final List<ItemStorage> crusherModes = new ArrayList<ItemStorage>();

        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        public void deserialize(@NotNull FriendlyByteBuf buf) {
            super.deserialize(buf);
            if (buf.readBoolean()) {
                this.crusherMode = new ItemStorage(buf.m_130267_());
            }
            this.dailyQuantity = buf.readInt();
            this.crusherModes.clear();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.crusherModes.add(new ItemStorage(buf.m_130267_()));
            }
        }

        public void setCrusherMode(ItemStorage crusherMode, int dailyQuantity) {
            this.crusherMode = crusherMode;
            this.dailyQuantity = dailyQuantity;
            Network.getNetwork().sendToServer(new CrusherSetModeMessage(this, crusherMode, dailyQuantity));
        }

        public Tuple<ItemStorage, Integer> getCrusherMode() {
            return new Tuple((Object)this.crusherMode, (Object)this.dailyQuantity);
        }

        public List<ItemStorage> getCrusherModes() {
            return this.crusherModes;
        }

        @Override
        @NotNull
        public BOWindow getWindow() {
            return new WindowHutCrusherModule(this);
        }
    }
}

