/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.api.util.constant.TagConstants;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class BuildingGlassblower
extends AbstractBuilding {
    protected static final String GLASS_BLOWER = "glassblower";
    private static final String GLASS_BLOWER_SMELTING = "glassblower_smelting";

    public BuildingGlassblower(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return GLASS_BLOWER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public static class DOCraftingModule
    extends AbstractCraftingBuildingModule.Custom {
        public DOCraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            ItemStack stack = recipe.getPrimaryOutput().m_41777_();
            if (stack.m_41720_().getRegistryName().m_135827_().equals("domum_ornamentum")) {
                CompoundTag dataNbt = stack.m_41698_("textureData");
                MaterialTextureData textureData = MaterialTextureData.deserializeFromNBT((CompoundTag)dataNbt);
                for (Block block : textureData.getTexturedComponents().values()) {
                    ItemStack ingredientStack = new ItemStack((ItemLike)block);
                    if (ItemStackUtils.isEmpty(ingredientStack).booleanValue() || !ModTags.crafterIngredient.get(BuildingGlassblower.GLASS_BLOWER).m_8110_((Object)ingredientStack.m_41720_())) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean canLearnCraftingRecipes() {
            return true;
        }

        @Override
        public boolean canLearnFurnaceRecipes() {
            return false;
        }

        @Override
        public boolean canLearnLargeRecipes() {
            return true;
        }
    }

    public static class SmeltingModule
    extends AbstractCraftingBuildingModule.Smelting {
        public SmeltingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(TagConstants.CRAFTING_GLASSBLOWER_SMELTING).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            return CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, TagConstants.CRAFTING_GLASSBLOWER_SMELTING).orElse(false);
        }
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(TagConstants.CRAFTING_GLASSBLOWER).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            return CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, TagConstants.CRAFTING_GLASSBLOWER).orElse(false);
        }
    }
}

